/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.content.Context;
import android.os.Looper;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzln;
import com.google.android.gms.internal.zzpa;
import com.google.android.gms.internal.zzpb;
import com.google.android.gms.internal.zzpc;
import com.google.android.gms.internal.zzpd;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.plus.Account;
import com.google.android.gms.plus.Moments;
import com.google.android.gms.plus.People;
import com.google.android.gms.plus.internal.PlusCommonExtras;
import com.google.android.gms.plus.internal.PlusSession;
import com.google.android.gms.plus.internal.zze;
import com.google.android.gms.plus.zzb;
import java.util.HashSet;
import java.util.Set;

public final class Plus {
    public static final Api.ClientKey<zze> zzNX = new Api.ClientKey();
    static final Api.zza<zze, PlusOptions> zzNY = new Api.zza<zze, PlusOptions>(){

        @Override
        public zze zza(Context context, Looper looper, com.google.android.gms.common.internal.zze zze2, PlusOptions plusOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (plusOptions == null) {
                plusOptions = new PlusOptions();
            }
            return new zze(context, looper, zze2, new PlusSession(zze2.zzns(), zzln.zzc(zze2.zznw()), plusOptions.zzaHc.toArray(new String[0]), new String[0], context.getPackageName(), context.getPackageName(), null, new PlusCommonExtras()), connectionCallbacks, onConnectionFailedListener);
        }

        @Override
        public int getPriority() {
            return 2;
        }
    };
    public static final Api<PlusOptions> API = new Api<PlusOptions>("Plus.API", zzNY, zzNX, new Scope[0]);
    public static final Scope SCOPE_PLUS_LOGIN = new Scope("https://www.googleapis.com/auth/plus.login");
    public static final Scope SCOPE_PLUS_PROFILE = new Scope("https://www.googleapis.com/auth/plus.me");
    public static final Moments MomentsApi = new zzpd();
    public static final People PeopleApi = new zzpe();
    public static final Account AccountApi = new zzpa();
    public static final zzb zzaGZ = new zzpc();
    public static final com.google.android.gms.plus.zza zzaHa = new zzpb();

    private Plus() {
    }

    public static zze zzf(GoogleApiClient googleApiClient, boolean bl) {
        zzu.zzb(googleApiClient != null, (Object)"GoogleApiClient parameter is required.");
        zzu.zza(googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        zzu.zza(googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Plus.API Api. Pass this into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Plus.API and is not connected to Plus. Use GoogleApiClient.hasConnectedApi(Plus.API) to guard this call.");
        }
        return bl2 ? googleApiClient.zza(zzNX) : null;
    }

    public static abstract class zza<R extends Result>
    extends zza.zza<R, zze> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzNX, googleApiClient);
        }
    }

    public static final class PlusOptions
    implements Api.ApiOptions.Optional {
        final String zzaHb;
        final Set<String> zzaHc;

        private PlusOptions() {
            this.zzaHb = null;
            this.zzaHc = new HashSet<String>();
        }

        private PlusOptions(Builder builder) {
            this.zzaHb = builder.zzaHb;
            this.zzaHc = builder.zzaHc;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            String zzaHb;
            final Set<String> zzaHc = new HashSet<String>();

            public Builder setServerClientId(String clientId) {
                this.zzaHb = clientId;
                return this;
            }

            public Builder addActivityTypes(String ... activityTypes) {
                zzu.zzb(activityTypes, (Object)"activityTypes may not be null.");
                for (int i = 0; i < activityTypes.length; ++i) {
                    this.zzaHc.add(activityTypes[i]);
                }
                return this;
            }

            public PlusOptions build() {
                return new PlusOptions(this);
            }
        }
    }
}

