/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzrm;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzrq;
import java.io.IOException;

public final class zzrf {
    private final byte[] buffer;
    private int zzaVK;
    private int zzaVL;
    private int zzaVM;
    private int zzaVN;
    private int zzaVO;
    private int zzaVP = Integer.MAX_VALUE;
    private int zzaVQ;
    private int zzaVR = 64;
    private int zzaVS = 0x4000000;

    public static zzrf zzz(byte[] byArray) {
        return zzrf.zza(byArray, 0, byArray.length);
    }

    public static zzrf zza(byte[] byArray, int n, int n2) {
        return new zzrf(byArray, n, n2);
    }

    public int zzBr() throws IOException {
        if (this.zzBE()) {
            this.zzaVO = 0;
            return 0;
        }
        this.zzaVO = this.zzBy();
        if (this.zzaVO == 0) {
            throw zzrm.zzBQ();
        }
        return this.zzaVO;
    }

    public void zzkz(int n) throws zzrm {
        if (this.zzaVO != n) {
            throw zzrm.zzBR();
        }
    }

    public boolean zzkA(int n) throws IOException {
        switch (zzrq.zzkU(n)) {
            case 0: {
                this.zzBu();
                return true;
            }
            case 1: {
                this.zzBB();
                return true;
            }
            case 2: {
                this.zzkG(this.zzBy());
                return true;
            }
            case 3: {
                this.zzBs();
                this.zzkz(zzrq.zzD(zzrq.zzkV(n), 4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.zzBA();
                return true;
            }
        }
        throw zzrm.zzBS();
    }

    public void zzBs() throws IOException {
        int n;
        while ((n = this.zzBr()) != 0 && this.zzkA(n)) {
        }
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.zzBB());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.zzBA());
    }

    public long zzBt() throws IOException {
        return this.zzBz();
    }

    public int zzBu() throws IOException {
        return this.zzBy();
    }

    public boolean zzBv() throws IOException {
        return this.zzBy() != 0;
    }

    public String readString() throws IOException {
        int n = this.zzBy();
        if (n <= this.zzaVL - this.zzaVN && n > 0) {
            String string2 = new String(this.buffer, this.zzaVN, n, "UTF-8");
            this.zzaVN += n;
            return string2;
        }
        return new String(this.zzkF(n), "UTF-8");
    }

    public void zza(zzrn zzrn2, int n) throws IOException {
        if (this.zzaVQ >= this.zzaVR) {
            throw zzrm.zzBT();
        }
        ++this.zzaVQ;
        zzrn2.zzb(this);
        this.zzkz(zzrq.zzD(n, 4));
        --this.zzaVQ;
    }

    public void zza(zzrn zzrn2) throws IOException {
        int n = this.zzBy();
        if (this.zzaVQ >= this.zzaVR) {
            throw zzrm.zzBT();
        }
        int n2 = this.zzkC(n);
        ++this.zzaVQ;
        zzrn2.zzb(this);
        this.zzkz(0);
        --this.zzaVQ;
        this.zzkD(n2);
    }

    public byte[] readBytes() throws IOException {
        int n = this.zzBy();
        if (n <= this.zzaVL - this.zzaVN && n > 0) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, this.zzaVN, byArray, 0, n);
            this.zzaVN += n;
            return byArray;
        }
        return this.zzkF(n);
    }

    public int zzBw() throws IOException {
        return zzrf.zzkB(this.zzBy());
    }

    public long zzBx() throws IOException {
        return zzrf.zzV(this.zzBz());
    }

    public int zzBy() throws IOException {
        byte by = this.zzBF();
        if (by >= 0) {
            return by;
        }
        int n = by & 0x7F;
        by = this.zzBF();
        if (by >= 0) {
            n |= by << 7;
        } else {
            n |= (by & 0x7F) << 7;
            by = this.zzBF();
            if (by >= 0) {
                n |= by << 14;
            } else {
                n |= (by & 0x7F) << 14;
                by = this.zzBF();
                if (by >= 0) {
                    n |= by << 21;
                } else {
                    n |= (by & 0x7F) << 21;
                    by = this.zzBF();
                    n |= by << 28;
                    if (by < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (this.zzBF() < 0) continue;
                            return n;
                        }
                        throw zzrm.zzBP();
                    }
                }
            }
        }
        return n;
    }

    public long zzBz() throws IOException {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.zzBF();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw zzrm.zzBP();
    }

    public int zzBA() throws IOException {
        byte by = this.zzBF();
        byte by2 = this.zzBF();
        byte by3 = this.zzBF();
        byte by4 = this.zzBF();
        return by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by4 & 0xFF) << 24;
    }

    public long zzBB() throws IOException {
        byte by = this.zzBF();
        byte by2 = this.zzBF();
        byte by3 = this.zzBF();
        byte by4 = this.zzBF();
        byte by5 = this.zzBF();
        byte by6 = this.zzBF();
        byte by7 = this.zzBF();
        byte by8 = this.zzBF();
        return (long)by & 0xFFL | ((long)by2 & 0xFFL) << 8 | ((long)by3 & 0xFFL) << 16 | ((long)by4 & 0xFFL) << 24 | ((long)by5 & 0xFFL) << 32 | ((long)by6 & 0xFFL) << 40 | ((long)by7 & 0xFFL) << 48 | ((long)by8 & 0xFFL) << 56;
    }

    public static int zzkB(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long zzV(long l) {
        return l >>> 1 ^ -(l & 1L);
    }

    private zzrf(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.zzaVK = n;
        this.zzaVL = n + n2;
        this.zzaVN = n;
    }

    public int zzkC(int n) throws zzrm {
        if (n < 0) {
            throw zzrm.zzBO();
        }
        int n2 = this.zzaVP;
        if ((n += this.zzaVN) > n2) {
            throw zzrm.zzBN();
        }
        this.zzaVP = n;
        this.zzBC();
        return n2;
    }

    private void zzBC() {
        this.zzaVL += this.zzaVM;
        int n = this.zzaVL;
        if (n > this.zzaVP) {
            this.zzaVM = n - this.zzaVP;
            this.zzaVL -= this.zzaVM;
        } else {
            this.zzaVM = 0;
        }
    }

    public void zzkD(int n) {
        this.zzaVP = n;
        this.zzBC();
    }

    public int zzBD() {
        if (this.zzaVP == Integer.MAX_VALUE) {
            return -1;
        }
        int n = this.zzaVN;
        return this.zzaVP - n;
    }

    public boolean zzBE() {
        return this.zzaVN == this.zzaVL;
    }

    public int getPosition() {
        return this.zzaVN - this.zzaVK;
    }

    public byte[] zzx(int n, int n2) {
        if (n2 == 0) {
            return zzrq.zzaWo;
        }
        byte[] byArray = new byte[n2];
        int n3 = this.zzaVK + n;
        System.arraycopy(this.buffer, n3, byArray, 0, n2);
        return byArray;
    }

    public void zzkE(int n) {
        if (n > this.zzaVN - this.zzaVK) {
            throw new IllegalArgumentException("Position " + n + " is beyond current " + (this.zzaVN - this.zzaVK));
        }
        if (n < 0) {
            throw new IllegalArgumentException("Bad position " + n);
        }
        this.zzaVN = this.zzaVK + n;
    }

    public byte zzBF() throws IOException {
        if (this.zzaVN == this.zzaVL) {
            throw zzrm.zzBN();
        }
        return this.buffer[this.zzaVN++];
    }

    public byte[] zzkF(int n) throws IOException {
        if (n < 0) {
            throw zzrm.zzBO();
        }
        if (this.zzaVN + n > this.zzaVP) {
            this.zzkG(this.zzaVP - this.zzaVN);
            throw zzrm.zzBN();
        }
        if (n <= this.zzaVL - this.zzaVN) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, this.zzaVN, byArray, 0, n);
            this.zzaVN += n;
            return byArray;
        }
        throw zzrm.zzBN();
    }

    public void zzkG(int n) throws IOException {
        if (n < 0) {
            throw zzrm.zzBO();
        }
        if (this.zzaVN + n > this.zzaVP) {
            this.zzkG(this.zzaVP - this.zzaVN);
            throw zzrm.zzBN();
        }
        if (n <= this.zzaVL - this.zzaVN) {
            this.zzaVN += n;
        } else {
            throw zzrm.zzBN();
        }
    }
}

