/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzgd;
import java.util.Locale;

@zzgd
public final class zzgk {
    public final int zzEn;
    public final boolean zzEo;
    public final boolean zzEp;
    public final String zzEq;
    public final String zzEr;
    public final boolean zzEs;
    public final boolean zzEt;
    public final boolean zzEu;
    public final String zzEv;
    public final String zzEw;
    public final int zzEx;
    public final int zzEy;
    public final int zzEz;
    public final int zzEA;
    public final int zzEB;
    public final int zzEC;
    public final float zzCy;
    public final int zzCw;
    public final int zzCx;
    public final double zzED;
    public final boolean zzEE;
    public final boolean zzEF;
    public final int zzEG;

    zzgk(int n, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4, boolean bl5, String string4, String string5, int n2, int n3, int n4, int n5, int n6, int n7, float f, int n8, int n9, double d, boolean bl6, boolean bl7, int n10) {
        this.zzEn = n;
        this.zzEo = bl;
        this.zzEp = bl2;
        this.zzEq = string2;
        this.zzEr = string3;
        this.zzEs = bl3;
        this.zzEt = bl4;
        this.zzEu = bl5;
        this.zzEv = string4;
        this.zzEw = string5;
        this.zzEx = n2;
        this.zzEy = n3;
        this.zzEz = n4;
        this.zzEA = n5;
        this.zzEB = n6;
        this.zzEC = n7;
        this.zzCy = f;
        this.zzCw = n8;
        this.zzCx = n9;
        this.zzED = d;
        this.zzEE = bl6;
        this.zzEF = bl7;
        this.zzEG = n10;
    }

    public static final class zza {
        private int zzEn;
        private boolean zzEt;
        private boolean zzEu;
        private int zzEx;
        private int zzEB;
        private int zzEC;
        private String zzEq;
        private int zzEy;
        private int zzEz;
        private int zzEA;
        private boolean zzEF;
        private int zzEG;
        private double zzED;
        private boolean zzEE;
        private boolean zzEo;
        private boolean zzEp;
        private String zzEr;
        private boolean zzEs;
        private String zzEv;
        private String zzEw;
        private float zzCy;
        private int zzCw;
        private int zzCx;

        public zza(Context context) {
            PackageManager packageManager = context.getPackageManager();
            this.zzA(context);
            this.zza(context, packageManager);
            this.zzB(context);
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            Locale locale = Locale.getDefault();
            this.zzEo = zza.zza(packageManager, "geo:0,0?q=donuts") != null;
            this.zzEp = zza.zza(packageManager, "http://www.google.com") != null;
            this.zzEr = locale.getCountry();
            this.zzEs = zzk.zzcA().zzgv();
            this.zzEv = locale.getLanguage();
            this.zzEw = zza.zza(packageManager);
            this.zzCy = displayMetrics.density;
            this.zzCw = displayMetrics.widthPixels;
            this.zzCx = displayMetrics.heightPixels;
        }

        public zza(Context context, zzgk zzgk2) {
            PackageManager packageManager = context.getPackageManager();
            this.zzA(context);
            this.zza(context, packageManager);
            this.zzB(context);
            this.zzEo = zzgk2.zzEo;
            this.zzEp = zzgk2.zzEp;
            this.zzEr = zzgk2.zzEr;
            this.zzEs = zzgk2.zzEs;
            this.zzEv = zzgk2.zzEv;
            this.zzEw = zzgk2.zzEw;
            this.zzCy = zzgk2.zzCy;
            this.zzCw = zzgk2.zzCw;
            this.zzCx = zzgk2.zzCx;
        }

        private void zzA(Context context) {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            this.zzEn = audioManager.getMode();
            this.zzEt = audioManager.isMusicActive();
            this.zzEu = audioManager.isSpeakerphoneOn();
            this.zzEx = audioManager.getStreamVolume(3);
            this.zzEB = audioManager.getRingerMode();
            this.zzEC = audioManager.getStreamVolume(2);
        }

        private void zza(Context context, PackageManager packageManager) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            this.zzEq = telephonyManager.getNetworkOperator();
            this.zzEy = zza.zza(context, connectivityManager, packageManager);
            this.zzEz = telephonyManager.getNetworkType();
            this.zzEA = telephonyManager.getPhoneType();
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzEF = connectivityManager.isActiveNetworkMetered();
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                this.zzEG = networkInfo != null ? connectivityManager.getActiveNetworkInfo().getDetailedState().ordinal() : -1;
            } else {
                this.zzEF = false;
                this.zzEG = -1;
            }
        }

        private void zzB(Context context) {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, intentFilter);
            if (intent != null) {
                int n = intent.getIntExtra("status", -1);
                int n2 = intent.getIntExtra("level", -1);
                int n3 = intent.getIntExtra("scale", -1);
                this.zzED = (float)n2 / (float)n3;
                this.zzEE = n == 2 || n == 5;
            } else {
                this.zzED = -1.0;
                this.zzEE = false;
            }
        }

        private static String zza(PackageManager packageManager) {
            ResolveInfo resolveInfo = zza.zza(packageManager, "market://details?id=com.google.android.gms.ads");
            if (resolveInfo == null) {
                return null;
            }
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null) {
                return null;
            }
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
                return packageInfo != null ? packageInfo.versionCode + "." + activityInfo.packageName : null;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }

        private static int zza(Context context, ConnectivityManager connectivityManager, PackageManager packageManager) {
            int n = -2;
            if (zzo.zzbv().zza(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                n = networkInfo != null ? networkInfo.getType() : -1;
            }
            return n;
        }

        private static ResolveInfo zza(PackageManager packageManager, String string2) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }

        public zzgk zzfJ() {
            return new zzgk(this.zzEn, this.zzEo, this.zzEp, this.zzEq, this.zzEr, this.zzEs, this.zzEt, this.zzEu, this.zzEv, this.zzEw, this.zzEx, this.zzEy, this.zzEz, this.zzEA, this.zzEB, this.zzEC, this.zzCy, this.zzCw, this.zzCx, this.zzED, this.zzEE, this.zzEF, this.zzEG);
        }
    }
}

