/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.gcm.GcmReceiver;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.MessengerCompat;
import com.google.android.gms.iid.zzc;
import com.google.android.gms.iid.zzd;
import java.io.IOException;

public class InstanceIDListenerService
extends Service {
    static String ACTION = "action";
    MessengerCompat zzawU = new MessengerCompat(new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            InstanceIDListenerService.this.zza(msg, MessengerCompat.zzc(msg));
        }
    });
    BroadcastReceiver zzawV = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                String string2 = intent.getStringExtra("registration_id");
                Log.d((String)"InstanceID", (String)("Received GSF callback using dynamic receiver: " + intent.getExtras()));
            }
            InstanceIDListenerService.this.zzn(intent);
            InstanceIDListenerService.this.stop();
        }
    };
    private static String zzavK = "google.com/iid";
    private static String zzawW = "CMD";
    int zzawX;
    int zzawY;

    public void zzn(Intent intent) {
        Object object;
        String string2 = intent.getStringExtra("subtype");
        InstanceID instanceID = null;
        if (string2 == null) {
            instanceID = InstanceID.getInstance((Context)this);
        } else {
            object = new Bundle();
            object.putString("subtype", string2);
            instanceID = InstanceID.zza((Context)this, object);
        }
        object = intent.getStringExtra(zzawW);
        if (null != intent.getStringExtra("error") || null != intent.getStringExtra("registration_id")) {
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                Log.d((String)"InstanceID", (String)("Register result in service " + string2));
            }
            instanceID.zzuh().zzr(intent);
            return;
        }
        if (Log.isLoggable((String)"InstanceID", (int)3)) {
            Log.d((String)"InstanceID", (String)("Service command " + string2 + " " + (String)object + " " + intent.getExtras()));
        }
        if (null != intent.getStringExtra("unregistered")) {
            instanceID.zzug().zzdi(string2 == null ? "" : string2);
            instanceID.zzuh().zzr(intent);
            return;
        }
        if ("RST".equals(object)) {
            instanceID.zzuf();
            this.zzab(true);
        } else if ("RST_FULL".equals(object)) {
            if (!instanceID.zzug().isEmpty()) {
                instanceID.zzug().zzul();
                this.zzab(true);
            }
        } else if ("SYNC".equals(object)) {
            instanceID.zzug().zzdi(string2);
            this.zzab(false);
        } else if ("PING".equals(object)) {
            try {
                GoogleCloudMessaging.getInstance((Context)this).send(zzavK, zzc.zzuk(), 0L, intent.getExtras());
            }
            catch (IOException iOException) {
                Log.w((String)"InstanceID", (String)"Failed to send ping response");
            }
        }
    }

    static void zza(Context context, zzd zzd2) {
        zzd2.zzul();
        Intent intent = new Intent("com.google.android.gms.iid.InstanceID");
        intent.putExtra(zzawW, "RST");
        intent.setPackage(context.getPackageName());
        context.startService(intent);
    }

    static void zzav(Context context) {
        Intent intent = new Intent("com.google.android.gms.iid.InstanceID");
        intent.setPackage(context.getPackageName());
        intent.putExtra(zzawW, "SYNC");
        context.startService(intent);
    }

    private void zza(Message message, int n) {
        zzc.zzaw((Context)this);
        PackageManager packageManager = this.getPackageManager();
        if (n != zzc.zzaxf && n != zzc.zzaxe) {
            Log.w((String)"InstanceID", (String)("Message from unexpected caller " + n + " mine=" + zzc.zzaxe + " appid=" + zzc.zzaxf));
            return;
        }
        this.zzn((Intent)message.obj);
    }

    public void onCreate() {
        IntentFilter intentFilter = new IntentFilter("com.google.android.c2dm.intent.REGISTRATION");
        intentFilter.addCategory(this.getPackageName());
        this.registerReceiver(this.zzawV, intentFilter, "com.google.android.c2dm.permission.RECEIVE", null);
    }

    public void onDestroy() {
        this.unregisterReceiver(this.zzawV);
    }

    public IBinder onBind(Intent intent) {
        if (intent != null && "com.google.android.gms.iid.InstanceID".equals(intent.getAction())) {
            return this.zzawU.getBinder();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        InstanceIDListenerService instanceIDListenerService = this;
        synchronized (instanceIDListenerService) {
            --this.zzawX;
            if (this.zzawX == 0) {
                this.stopSelf(this.zzawY);
            }
            if (Log.isLoggable((String)"InstanceID", (int)3)) {
                Log.d((String)"InstanceID", (String)("Stop " + this.zzawX + " " + this.zzawY));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzgn(int n) {
        InstanceIDListenerService instanceIDListenerService = this;
        synchronized (instanceIDListenerService) {
            ++this.zzawX;
            if (n > this.zzawY) {
                this.zzawY = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(Intent intent, int flags, int startId) {
        this.zzgn(startId);
        if (intent == null) {
            this.stop();
            return 2;
        }
        try {
            String string2 = intent.getAction();
            if ("com.google.android.gms.iid.InstanceID".equals(string2)) {
                Intent intent2;
                if (Build.VERSION.SDK_INT <= 18 && (intent2 = (Intent)intent.getParcelableExtra("GSF")) != null) {
                    this.startService(intent2);
                    int n = 1;
                    return n;
                }
                this.zzn(intent);
            }
        }
        finally {
            this.stop();
        }
        if (intent.getStringExtra("from") != null) {
            GcmReceiver.completeWakefulIntent((Intent)intent);
        }
        return 2;
    }

    public void zzab(boolean bl) {
        this.onTokenRefresh();
    }

    public void onTokenRefresh() {
    }
}

