/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfigImpl;
import java.util.ArrayList;

public abstract class TurnBasedMatchConfig {
    protected TurnBasedMatchConfig() {
    }

    public abstract int getVariant();

    public abstract int zztL();

    public abstract String[] getInvitedPlayerIds();

    public abstract Bundle getAutoMatchCriteria();

    public static Builder builder() {
        return new Builder();
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        int zzaui = -1;
        ArrayList<String> zzaux = new ArrayList();
        Bundle zzauy = null;
        int zzauH = 2;

        private Builder() {
        }

        public Builder addInvitedPlayer(String playerId) {
            zzu.zzu(playerId);
            this.zzaux.add(playerId);
            return this;
        }

        public Builder addInvitedPlayers(ArrayList<String> playerIds) {
            zzu.zzu(playerIds);
            this.zzaux.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            zzu.zzb(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or TurnBasedMatch.MATCH_VARIANT_ANY");
            this.zzaui = variant;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.zzauy = autoMatchCriteria;
            return this;
        }

        public TurnBasedMatchConfig build() {
            return new TurnBasedMatchConfigImpl(this);
        }
    }
}

