/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.drive.CreateFileActivityBuilder;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.OpenFileActivityBuilder;
import com.google.android.gms.drive.internal.CreateContentsRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.OnContentsResponse;
import com.google.android.gms.drive.internal.OnDriveIdResponse;
import com.google.android.gms.drive.internal.OnListEntriesResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.QueryRequest;
import com.google.android.gms.drive.internal.zzal;
import com.google.android.gms.drive.internal.zzbq;
import com.google.android.gms.drive.internal.zzn;
import com.google.android.gms.drive.internal.zzr;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzu;
import com.google.android.gms.drive.internal.zzw;
import com.google.android.gms.drive.query.Query;
import java.util.List;

public class zzq
implements DriveApi {
    @Override
    public PendingResult<DriveApi.MetadataBufferResult> query(GoogleApiClient apiClient, final Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be provided.");
        }
        return apiClient.zza(new zzg(apiClient){

            @Override
            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new QueryRequest(query), (zzal)new zzi(this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> newDriveContents(GoogleApiClient apiClient) {
        return this.zza(apiClient, 0x20000000);
    }

    public PendingResult<DriveApi.DriveContentsResult> zza(GoogleApiClient googleApiClient, final int n) {
        return googleApiClient.zza(new zzb(googleApiClient){

            @Override
            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new CreateContentsRequest(n), (zzal)new zzh(this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveIdResult> fetchDriveId(GoogleApiClient apiClient, final String resourceId) {
        return apiClient.zza(new zze(apiClient){

            @Override
            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new GetMetadataRequest(DriveId.zzcs(resourceId), false), (zzal)new zzc(this));
            }
        });
    }

    @Override
    public DriveFile getFile(GoogleApiClient apiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzu(driveId);
    }

    @Override
    public DriveFolder getFolder(GoogleApiClient apiClient, DriveId driveId) {
        if (driveId == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new zzw(driveId);
    }

    @Override
    public DriveFolder getRootFolder(GoogleApiClient apiClient) {
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        zzs zzs2 = apiClient.zza(Drive.zzNX);
        return new zzw(zzs2.zzpC());
    }

    @Override
    public DriveFolder getAppFolder(GoogleApiClient apiClient) {
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        zzs zzs2 = apiClient.zza(Drive.zzNX);
        DriveId driveId = zzs2.zzpD();
        return driveId != null ? new zzw(driveId) : null;
    }

    @Override
    public PendingResult<Status> requestSync(GoogleApiClient apiClient) {
        return apiClient.zzb(new zzr.zza(apiClient){

            @Override
            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new zzbq(this));
            }
        });
    }

    @Override
    public OpenFileActivityBuilder newOpenFileActivityBuilder() {
        return new OpenFileActivityBuilder();
    }

    @Override
    public CreateFileActivityBuilder newCreateFileActivityBuilder() {
        return new CreateFileActivityBuilder();
    }

    @Override
    public PendingResult<Status> cancelPendingActions(GoogleApiClient apiClient, List<String> trackingTags) {
        zzs zzs2 = apiClient.zza(Drive.zzNX);
        return zzs2.cancelPendingActions(apiClient, trackingTags);
    }

    private static class zzi
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveApi.MetadataBufferResult> zzOs;

        public zzi(zza.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzOs = zzb2;
        }

        @Override
        public void zza(OnListEntriesResponse onListEntriesResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListEntriesResponse.zzpP());
            this.zzOs.zzm(new zzf(Status.zzXP, metadataBuffer, onListEntriesResponse.zzpQ()));
        }

        @Override
        public void zzt(Status status) throws RemoteException {
            this.zzOs.zzm(new zzf(status, null, false));
        }
    }

    static class zzf
    implements DriveApi.MetadataBufferResult {
        private final Status zzOt;
        private final MetadataBuffer zzaeK;
        private final boolean zzaeL;

        public zzf(Status status, MetadataBuffer metadataBuffer, boolean bl) {
            this.zzOt = status;
            this.zzaeK = metadataBuffer;
            this.zzaeL = bl;
        }

        @Override
        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public MetadataBuffer getMetadataBuffer() {
            return this.zzaeK;
        }

        @Override
        public void release() {
            if (this.zzaeK != null) {
                this.zzaeK.release();
            }
        }
    }

    static abstract class zzg
    extends zzr<DriveApi.MetadataBufferResult> {
        zzg(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.MetadataBufferResult zzw(Status status) {
            return new zzf(status, null, false);
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzw(x0);
        }
    }

    static class zzc
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveApi.DriveIdResult> zzOs;

        public zzc(zza.zzb<DriveApi.DriveIdResult> zzb2) {
            this.zzOs = zzb2;
        }

        @Override
        public void zza(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.zzOs.zzm(new zzd(Status.zzXP, new zzn(onMetadataResponse.zzpS()).getDriveId()));
        }

        @Override
        public void zza(OnDriveIdResponse onDriveIdResponse) throws RemoteException {
            this.zzOs.zzm(new zzd(Status.zzXP, onDriveIdResponse.getDriveId()));
        }

        @Override
        public void zzt(Status status) throws RemoteException {
            this.zzOs.zzm(new zzd(status, null));
        }
    }

    private static class zzd
    implements DriveApi.DriveIdResult {
        private final Status zzOt;
        private final DriveId zzacT;

        public zzd(Status status, DriveId driveId) {
            this.zzOt = status;
            this.zzacT = driveId;
        }

        @Override
        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public DriveId getDriveId() {
            return this.zzacT;
        }
    }

    static abstract class zze
    extends zzr<DriveApi.DriveIdResult> {
        zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveIdResult zzv(Status status) {
            return new zzd(status, null);
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzv(x0);
        }
    }

    private static class zzh
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveApi.DriveContentsResult> zzOs;

        public zzh(zza.zzb<DriveApi.DriveContentsResult> zzb2) {
            this.zzOs = zzb2;
        }

        @Override
        public void zza(OnContentsResponse onContentsResponse) throws RemoteException {
            this.zzOs.zzm(new zza(Status.zzXP, new zzt(onContentsResponse.zzpJ())));
        }

        @Override
        public void zzt(Status status) throws RemoteException {
            this.zzOs.zzm(new zza(status, null));
        }
    }

    static class zza
    implements Releasable,
    DriveApi.DriveContentsResult {
        private final Status zzOt;
        private final DriveContents zzacW;

        public zza(Status status, DriveContents driveContents) {
            this.zzOt = status;
            this.zzacW = driveContents;
        }

        @Override
        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public DriveContents getDriveContents() {
            return this.zzacW;
        }

        @Override
        public void release() {
            if (this.zzacW != null) {
                this.zzacW.zzpf();
            }
        }
    }

    static abstract class zzb
    extends zzr<DriveApi.DriveContentsResult> {
        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveApi.DriveContentsResult zzu(Status status) {
            return new zza(status, null);
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzu(x0);
        }
    }

    static class zzj
    extends zzr.zza {
        zzj(GoogleApiClient googleApiClient, Status status) {
            super(googleApiClient);
            this.setResult(status);
        }

        @Override
        protected void zza(zzs zzs2) {
        }
    }
}

