/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.drive.metadata.CustomPropertyKey;
import com.google.android.gms.drive.metadata.internal.AppVisibleCustomProperties;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzlo;
import com.google.android.gms.internal.zzlq;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public final class MetadataChangeSet {
    public static final int INDEXABLE_TEXT_SIZE_LIMIT_BYTES = 131072;
    public static final int CUSTOM_PROPERTY_SIZE_LIMIT_BYTES = 124;
    public static final int MAX_PUBLIC_PROPERTIES_PER_RESOURCE = 30;
    public static final int MAX_PRIVATE_PROPERTIES_PER_RESOURCE_PER_APP = 30;
    public static final int MAX_TOTAL_PROPERTIES_PER_RESOURCE = 100;
    public static final MetadataChangeSet zzads = new MetadataChangeSet(MetadataBundle.zzpX());
    private final MetadataBundle zzadt;

    public MetadataChangeSet(MetadataBundle bag) {
        this.zzadt = MetadataBundle.zza(bag);
    }

    public Map<CustomPropertyKey, String> getCustomPropertyChangeMap() {
        AppVisibleCustomProperties appVisibleCustomProperties = this.zzadt.zza(zzlo.zzagM);
        return appVisibleCustomProperties == null ? Collections.emptyMap() : appVisibleCustomProperties.zzpT();
    }

    public String getDescription() {
        return this.zzadt.zza(zzlo.zzagN);
    }

    public String getIndexableText() {
        return this.zzadt.zza(zzlo.zzagT);
    }

    public Date getLastViewedByMeDate() {
        return this.zzadt.zza(zzlq.zzahz);
    }

    public String getMimeType() {
        return this.zzadt.zza(zzlo.zzahg);
    }

    public String getTitle() {
        return this.zzadt.zza(zzlo.zzahp);
    }

    public Boolean isPinned() {
        return this.zzadt.zza(zzlo.zzagY);
    }

    public Boolean isStarred() {
        return this.zzadt.zza(zzlo.zzahn);
    }

    public Boolean isViewed() {
        return this.zzadt.zza(zzlo.zzahf);
    }

    public MetadataBundle zzpm() {
        return this.zzadt;
    }

    public static class Builder {
        private final MetadataBundle zzadt = MetadataBundle.zzpX();
        private AppVisibleCustomProperties.zza zzadu;

        private AppVisibleCustomProperties.zza zzpn() {
            if (this.zzadu == null) {
                this.zzadu = new AppVisibleCustomProperties.zza();
            }
            return this.zzadu;
        }

        private int zzcu(String string2) {
            return string2 == null ? 0 : string2.getBytes().length;
        }

        private String zzj(String string2, int n, int n2) {
            return String.format("%s must be no more than %d bytes, but is %d bytes.", string2, n, n2);
        }

        private void zzk(String string2, int n, int n2) {
            zzu.zzb(n2 <= n, (Object)this.zzj(string2, n, n2));
        }

        public Builder setCustomProperty(CustomPropertyKey key, String value) {
            zzu.zzb(key, (Object)"key");
            zzu.zzb(value, (Object)"value");
            int n = this.zzcu(key.getKey()) + this.zzcu(value);
            this.zzk("The total size of key string and value string of a custom property", 124, n);
            this.zzpn().zza(key, value);
            return this;
        }

        public Builder deleteCustomProperty(CustomPropertyKey key) {
            zzu.zzb(key, (Object)"key");
            this.zzpn().zza(key, null);
            return this;
        }

        public Builder setDescription(String description) {
            this.zzadt.zzb(zzlo.zzagN, description);
            return this;
        }

        public Builder setIndexableText(String text) {
            int n = this.zzcu(text);
            this.zzk("Indexable text size", 131072, n);
            this.zzadt.zzb(zzlo.zzagT, text);
            return this;
        }

        public Builder setLastViewedByMeDate(Date date) {
            this.zzadt.zzb(zzlq.zzahz, date);
            return this;
        }

        public Builder setMimeType(String mimeType) {
            this.zzadt.zzb(zzlo.zzahg, mimeType);
            return this;
        }

        public Builder setPinned(boolean pinned) {
            this.zzadt.zzb(zzlo.zzagY, pinned);
            return this;
        }

        public Builder setStarred(boolean starred) {
            this.zzadt.zzb(zzlo.zzahn, starred);
            return this;
        }

        public Builder setTitle(String title) {
            this.zzadt.zzb(zzlo.zzahp, title);
            return this;
        }

        public Builder setViewed(boolean viewed) {
            this.zzadt.zzb(zzlo.zzahf, viewed);
            return this;
        }

        public MetadataChangeSet build() {
            if (this.zzadu != null) {
                this.zzadt.zzb(zzlo.zzagM, this.zzadu.zzpU());
            }
            return new MetadataChangeSet(this.zzadt);
        }
    }
}

