/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.request;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.internal.constants.RequestUpdateResultOutcome;
import java.util.HashMap;
import java.util.Set;

public final class RequestUpdateOutcomes {
    private static final String[] zzatw = new String[]{"requestId", "outcome"};
    private final int zzTS;
    private final HashMap<String, Integer> zzatx;

    private RequestUpdateOutcomes(int statusCode, HashMap<String, Integer> outcomeMap) {
        this.zzTS = statusCode;
        this.zzatx = outcomeMap;
    }

    public int getRequestOutcome(String requestId) {
        zzu.zzb(this.zzatx.containsKey(requestId), (Object)("Request " + requestId + " was not part of the update operation!"));
        return this.zzatx.get(requestId);
    }

    public Set<String> getRequestIds() {
        return this.zzatx.keySet();
    }

    public static RequestUpdateOutcomes zzX(DataHolder dataHolder) {
        Builder builder = new Builder();
        builder.zzfQ(dataHolder.getStatusCode());
        int n = dataHolder.getCount();
        for (int i = 0; i < n; ++i) {
            int n2 = dataHolder.zzbh(i);
            builder.zzx(dataHolder.zzd("requestId", i, n2), dataHolder.zzc("outcome", i, n2));
        }
        return builder.zztD();
    }

    public static final class Builder {
        private HashMap<String, Integer> zzatx = new HashMap();
        private int zzTS = 0;

        public Builder zzx(String string2, int n) {
            if (RequestUpdateResultOutcome.isValid(n)) {
                this.zzatx.put(string2, n);
            }
            return this;
        }

        public Builder zzfQ(int n) {
            this.zzTS = n;
            return this;
        }

        public RequestUpdateOutcomes zztD() {
            return new RequestUpdateOutcomes(this.zzTS, this.zzatx);
        }
    }
}

