/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.BleScanCallback;
import com.google.android.gms.fitness.request.zza;
import com.google.android.gms.fitness.request.zzaa;
import com.google.android.gms.fitness.request.zzn;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzmu;
import java.util.Collections;
import java.util.List;

public class StartBleScanRequest
implements SafeParcelable {
    private final int zzCY;
    private final List<DataType> zzajQ;
    private final zzn zzamK;
    private final int zzamL;
    private final zzmu zzalN;
    private final String zzMZ;
    public static final Parcelable.Creator<StartBleScanRequest> CREATOR = new zzaa();

    StartBleScanRequest(int versionCode, List<DataType> dataTypes, IBinder bleScanCallback, int timeoutSecs, IBinder callback, String packageName) {
        this.zzCY = versionCode;
        this.zzajQ = dataTypes;
        this.zzamK = zzn.zza.zzbI(bleScanCallback);
        this.zzamL = timeoutSecs;
        this.zzalN = callback == null ? null : zzmu.zza.zzbF(callback);
        this.zzMZ = packageName;
    }

    private StartBleScanRequest(Builder builder) {
        this(zzkx.zzb(builder.zzami), builder.zzamK, builder.zzamL, null, null);
    }

    public StartBleScanRequest(StartBleScanRequest request, zzmu callback, String packageName) {
        this(request.zzajQ, request.zzamK, request.zzamL, callback, packageName);
    }

    public StartBleScanRequest(List<DataType> dataTypes, zzn bleScanCallback, int timeoutSecs, zzmu callback, String packageName) {
        this.zzCY = 3;
        this.zzajQ = dataTypes;
        this.zzamK = bleScanCallback;
        this.zzamL = timeoutSecs;
        this.zzalN = callback;
        this.zzMZ = packageName;
    }

    public List<DataType> getDataTypes() {
        return Collections.unmodifiableList(this.zzajQ);
    }

    public int getTimeoutSecs() {
        return this.zzamL;
    }

    public IBinder zzrq() {
        return this.zzamK.asBinder();
    }

    public IBinder zzqU() {
        return this.zzalN == null ? null : this.zzalN.asBinder();
    }

    public String getPackageName() {
        return this.zzMZ;
    }

    public String toString() {
        return zzt.zzt(this).zzg("dataTypes", this.zzajQ).zzg("timeoutSecs", this.zzamL).toString();
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzaa.zza(this, parcel, flags);
    }

    public static class Builder {
        private DataType[] zzami = new DataType[0];
        private zzn zzamK;
        private int zzamL = 10;

        public Builder setDataTypes(DataType ... dataTypes) {
            this.zzami = dataTypes;
            return this;
        }

        public Builder setBleScanCallback(BleScanCallback bleScanCallback) {
            this.zza(zza.zza.zzqS().zza(bleScanCallback));
            return this;
        }

        public Builder zza(zzn zzn2) {
            this.zzamK = zzn2;
            return this;
        }

        public Builder setTimeoutSecs(int stopTimeSecs) {
            zzu.zzb(stopTimeSecs > 0, (Object)"Stop time must be greater than zero");
            zzu.zzb(stopTimeSecs <= 60, (Object)"Stop time must be less than 1 minute");
            this.zzamL = stopTimeSecs;
            return this;
        }

        public StartBleScanRequest build() {
            zzu.zza(this.zzamK != null, (Object)"Must set BleScanCallback");
            return new StartBleScanRequest(this);
        }
    }
}

