/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.internal.zzs;

public final class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String zzadn;
    private final boolean zzado;
    private final int zzadp;

    public ExecutionOptions(String trackingTag, boolean notifyOnCompletion, int conflictStrategy) {
        this.zzadn = trackingTag;
        this.zzado = notifyOnCompletion;
        this.zzadp = conflictStrategy;
    }

    public String zzpi() {
        return this.zzadn;
    }

    public boolean zzpj() {
        return this.zzado;
    }

    public int zzpk() {
        return this.zzadp;
    }

    public static boolean zzbX(int n) {
        switch (n) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzbY(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzct(String string2) {
        return string2 != null && !string2.isEmpty() && string2.length() <= 65536;
    }

    public static void zza(GoogleApiClient googleApiClient, ExecutionOptions executionOptions) {
        zzs zzs2 = googleApiClient.zza(Drive.zzNX);
        if (executionOptions.zzpj() && !zzs2.zzpE()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)o;
        return zzt.equal(this.zzadn, executionOptions.zzadn) && this.zzadp == executionOptions.zzadp && this.zzado == executionOptions.zzado;
    }

    public int hashCode() {
        return zzt.hashCode(this.zzadn, this.zzadp, this.zzado);
    }

    public static final class Builder {
        private String zzadn;
        private boolean zzado;
        private int zzadp = 0;

        public Builder setTrackingTag(String trackingTag) {
            if (!ExecutionOptions.zzct(trackingTag)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.zzadn = trackingTag;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean notify) {
            this.zzado = notify;
            return this;
        }

        public Builder setConflictStrategy(int strategy) {
            if (!ExecutionOptions.zzbY(strategy)) {
                throw new IllegalArgumentException("Unrecognized value for conflict strategy: " + strategy);
            }
            this.zzadp = strategy;
            return this;
        }

        public ExecutionOptions build() {
            if (this.zzadp == 1 && !this.zzado) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
            return new ExecutionOptions(this.zzadn, this.zzado, this.zzadp);
        }
    }
}

