/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.internal.ApplicationStatus;
import com.google.android.gms.cast.internal.DeviceStatus;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzi;
import com.google.android.gms.cast.internal.zzj;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.BinderWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zze
extends com.google.android.gms.common.internal.zzi<zzi> {
    private static final zzl zzQW = new zzl("CastClientImpl");
    private ApplicationMetadata zzUl;
    private final CastDevice zzUm;
    private final Cast.Listener zzQI;
    private final Map<String, Cast.MessageReceivedCallback> zzUn;
    private final long zzUo;
    private zzb zzUp;
    private String zzUq;
    private boolean zzSi;
    private boolean zzUr;
    private boolean zzUs;
    private boolean zzUt;
    private double zzSh;
    private int zzUu;
    private int zzUv;
    private final AtomicLong zzUw;
    private String zzUx;
    private String zzUy;
    private Bundle zzUz;
    private final Map<Long, zza.zzb<Status>> zzUA;
    private zza.zzb<Cast.ApplicationConnectionResult> zzUB;
    private zza.zzb<Status> zzUC;
    private static final Object zzUD = new Object();
    private static final Object zzUE = new Object();

    public zze(Context context, Looper looper, CastDevice castDevice, long l, Cast.Listener listener, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, connectionCallbacks, onConnectionFailedListener);
        this.zzUm = castDevice;
        this.zzQI = listener;
        this.zzUo = l;
        this.zzUn = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzUw = new AtomicLong(0L);
        this.zzUA = new HashMap<Long, zza.zzb<Status>>();
        this.zzlL();
    }

    private void zzlL() {
        this.zzUt = false;
        this.zzUu = -1;
        this.zzUv = -1;
        this.zzUl = null;
        this.zzUq = null;
        this.zzSh = 0.0;
        this.zzSi = false;
    }

    @Override
    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        zzQW.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzUt = true;
            this.zzUr = true;
            this.zzUs = true;
        } else {
            this.zzUt = false;
        }
        int n3 = n;
        if (n == 1001) {
            this.zzUz = new Bundle();
            this.zzUz.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.zza(n3, iBinder, bundle, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        zzQW.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.zzUp, this.isConnected());
        zzb zzb2 = this.zzUp;
        this.zzUp = null;
        if (zzb2 == null || zzb2.zzlW() == null) {
            zzQW.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzlR();
        try {
            if (this.isConnected() || this.isConnecting()) {
                ((zzi)this.zznM()).disconnect();
            }
        }
        catch (RemoteException remoteException) {
            zzQW.zzb(remoteException, "Error while disconnecting the controller interface: %s", remoteException.getMessage());
        }
        finally {
            super.disconnect();
        }
    }

    @Override
    public Bundle zzlM() {
        if (this.zzUz != null) {
            Bundle bundle = this.zzUz;
            this.zzUz = null;
            return bundle;
        }
        return super.zzlM();
    }

    @Override
    protected String getStartServiceAction() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    @Override
    protected String getServiceDescriptor() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected zzi zzaw(IBinder iBinder) {
        return zzi.zza.zzax(iBinder);
    }

    @Override
    protected Bundle zzkR() {
        Bundle bundle = new Bundle();
        zzQW.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzUx, this.zzUy);
        this.zzUm.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzUo);
        this.zzUp = new zzb(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzUp.asBinder()));
        if (this.zzUx != null) {
            bundle.putString("last_application_id", this.zzUx);
            if (this.zzUy != null) {
                bundle.putString("last_session_id", this.zzUy);
            }
        }
        return bundle;
    }

    public void zza(String string2, String string3, zza.zzb<Status> zzb2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzf.zzbD(string2);
        this.zzlS();
        long l = this.zzUw.incrementAndGet();
        try {
            this.zzUA.put(l, zzb2);
            ((zzi)this.zznM()).zza(string2, string3, l);
        }
        catch (Throwable throwable) {
            this.zzUA.remove(l);
            throw throwable;
        }
    }

    public void zza(String string2, boolean bl, zza.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzi)this.zznM()).zzf(string2, bl);
    }

    public void zza(String string2, LaunchOptions launchOptions, zza.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzi)this.zznM()).zza(string2, launchOptions);
    }

    public void zzb(String string2, String string3, zza.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzi)this.zznM()).zzr(string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(zza.zzb<Cast.ApplicationConnectionResult> zzb2) {
        Object object = zzUD;
        synchronized (object) {
            if (this.zzUB != null) {
                this.zzUB.zzm(new zza(new Status(2002)));
            }
            this.zzUB = zzb2;
        }
    }

    public void zzd(zza.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zze(zzb2);
        ((zzi)this.zznM()).zzlY();
    }

    public void zza(String string2, zza.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zze(zzb2);
        ((zzi)this.zznM()).zzbG(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zze(zza.zzb<Status> zzb2) {
        Object object = zzUE;
        synchronized (object) {
            if (this.zzUC != null) {
                zzb2.zzm(new Status(2001));
                return;
            }
            this.zzUC = zzb2;
        }
    }

    public void zzlN() throws IllegalStateException, RemoteException {
        ((zzi)this.zznM()).zzlN();
    }

    public void zzd(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Volume cannot be " + d);
        }
        ((zzi)this.zznM()).zza(d, this.zzSh, this.zzSi);
    }

    public void zzR(boolean bl) throws IllegalStateException, RemoteException {
        ((zzi)this.zznM()).zza(bl, this.zzSh, this.zzSi);
    }

    public double zzlO() throws IllegalStateException {
        this.zzlS();
        return this.zzSh;
    }

    public boolean isMute() throws IllegalStateException {
        this.zzlS();
        return this.zzSi;
    }

    public int zzlP() throws IllegalStateException {
        this.zzlS();
        return this.zzUu;
    }

    public int zzlQ() throws IllegalStateException {
        this.zzlS();
        return this.zzUv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzf.zzbD(string2);
        this.zzbC(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzUn;
            synchronized (map) {
                this.zzUn.put(string2, messageReceivedCallback);
            }
            ((zzi)this.zznM()).zzbH(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbC(String string2) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzUn;
        synchronized (map) {
            messageReceivedCallback = this.zzUn.remove(string2);
        }
        if (messageReceivedCallback != null) {
            try {
                ((zzi)this.zznM()).zzbI(string2);
            }
            catch (IllegalStateException illegalStateException) {
                zzQW.zzb(illegalStateException, "Error unregistering namespace (%s): %s", string2, illegalStateException.getMessage());
            }
        }
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zzlS();
        return this.zzUl;
    }

    public String getApplicationStatus() throws IllegalStateException {
        this.zzlS();
        return this.zzUq;
    }

    @Override
    public void onConnectionFailed(ConnectionResult result) {
        super.onConnectionFailed(result);
        this.zzlR();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzlR() {
        zzQW.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzUn;
        synchronized (map) {
            this.zzUn.clear();
        }
    }

    private void zza(DeviceStatus deviceStatus) {
        boolean bl;
        ApplicationMetadata applicationMetadata = deviceStatus.getApplicationMetadata();
        if (!zzf.zza(applicationMetadata, this.zzUl)) {
            this.zzUl = applicationMetadata;
            this.zzQI.onApplicationMetadataChanged(this.zzUl);
        }
        boolean bl2 = false;
        double d = deviceStatus.zzlO();
        if (d != Double.NaN && Math.abs(d - this.zzSh) > 1.0E-7) {
            this.zzSh = d;
            bl2 = true;
        }
        if ((bl = deviceStatus.zzlX()) != this.zzSi) {
            this.zzSi = bl;
            bl2 = true;
        }
        zzQW.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzUs);
        if (this.zzQI != null && (bl2 || this.zzUs)) {
            this.zzQI.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = deviceStatus.zzlP();
        if (n != this.zzUu) {
            this.zzUu = n;
            bl3 = true;
        }
        zzQW.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzUs);
        if (this.zzQI != null && (bl3 || this.zzUs)) {
            this.zzQI.onActiveInputStateChanged(this.zzUu);
        }
        boolean bl4 = false;
        int n2 = deviceStatus.zzlQ();
        if (n2 != this.zzUv) {
            this.zzUv = n2;
            bl4 = true;
        }
        zzQW.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzUs);
        if (this.zzQI != null && (bl4 || this.zzUs)) {
            this.zzQI.onStandbyStateChanged(this.zzUv);
        }
        this.zzUs = false;
    }

    private void zza(ApplicationStatus applicationStatus) {
        boolean bl = false;
        String string2 = applicationStatus.zzlI();
        if (!zzf.zza(string2, this.zzUq)) {
            this.zzUq = string2;
            bl = true;
        }
        zzQW.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzUr);
        if (this.zzQI != null && (bl || this.zzUr)) {
            this.zzQI.onApplicationStatusChanged();
        }
        this.zzUr = false;
    }

    private void zzlS() throws IllegalStateException {
        if (!this.zzUt || this.zzUp == null || this.zzUp.isDisposed()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    @Override
    protected /* synthetic */ IInterface zzT(IBinder iBinder) {
        return this.zzaw(iBinder);
    }

    private static class zzb
    extends zzj.zza {
        private final AtomicReference<zze> zzUI;
        private final Handler mHandler;

        public zzb(zze zze2) {
            this.zzUI = new AtomicReference<zze>(zze2);
            this.mHandler = new Handler(zze2.getLooper());
        }

        public zze zzlW() {
            zze zze2 = this.zzUI.getAndSet(null);
            if (zze2 == null) {
                return null;
            }
            zze2.zzlL();
            return zze2;
        }

        public boolean isDisposed() {
            return this.zzUI.get() == null;
        }

        @Override
        public void zzaM(int n) {
            zze zze2 = this.zzlW();
            if (zze2 == null) {
                return;
            }
            zzQW.zzb("ICastDeviceControllerListener.onDisconnected: %d", n);
            if (n != 0) {
                zze2.zzbs(2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            zze zze2 = this.zzUI.get();
            if (zze2 == null) {
                return;
            }
            zze2.zzUl = applicationMetadata;
            zze2.zzUx = applicationMetadata.getApplicationId();
            zze2.zzUy = string3;
            Object object = zzUD;
            synchronized (object) {
                if (zze2.zzUB != null) {
                    zze2.zzUB.zzm(new zza(new Status(0), applicationMetadata, string2, string3, bl));
                    zze2.zzUB = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzaN(int n) {
            zze zze2 = this.zzUI.get();
            if (zze2 == null) {
                return;
            }
            Object object = zzUD;
            synchronized (object) {
                if (zze2.zzUB != null) {
                    zze2.zzUB.zzm(new zza(new Status(n)));
                    zze2.zzUB = null;
                }
            }
        }

        @Override
        public void zzaO(int n) {
            zze zze2 = this.zzUI.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void zzaP(int n) {
            zze zze2 = this.zzUI.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void onApplicationDisconnected(final int statusCode) {
            final zze zze2 = this.zzUI.get();
            if (zze2 == null) {
                return;
            }
            zze2.zzUx = null;
            zze2.zzUy = null;
            this.zza(zze2, statusCode);
            if (zze2.zzQI != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (zze2.zzQI != null) {
                            zze2.zzQI.onApplicationDisconnected(statusCode);
                        }
                    }
                });
            }
        }

        @Override
        public void zza(String string2, double d, boolean bl) {
            zzQW.zzb("Deprecated callback: \"onStatusreceived\"", new Object[0]);
        }

        @Override
        public void zzb(final DeviceStatus deviceStatus) {
            final zze zze2 = this.zzUI.get();
            if (zze2 == null) {
                return;
            }
            zzQW.zzb("onDeviceStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(deviceStatus);
                }
            });
        }

        @Override
        public void zzb(final ApplicationStatus applicationStatus) {
            final zze zze2 = this.zzUI.get();
            if (zze2 == null) {
                return;
            }
            zzQW.zzb("onApplicationStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(applicationStatus);
                }
            });
        }

        @Override
        public void zzq(final String string2, final String string3) {
            final zze zze2 = this.zzUI.get();
            if (zze2 == null) {
                return;
            }
            zzQW.zzb("Receive (type=text, ns=%s) %s", string2, string3);
            this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Cast.MessageReceivedCallback messageReceivedCallback;
                    Map map = zze2.zzUn;
                    synchronized (map) {
                        messageReceivedCallback = (Cast.MessageReceivedCallback)zze2.zzUn.get(string2);
                    }
                    if (messageReceivedCallback != null) {
                        messageReceivedCallback.onMessageReceived(zze2.zzUm, string2, string3);
                    } else {
                        zzQW.zzb("Discarded message for unknown namespace '%s'", string2);
                    }
                }
            });
        }

        @Override
        public void zzb(String string2, byte[] byArray) {
            zze zze2 = this.zzUI.get();
            if (zze2 == null) {
                return;
            }
            zzQW.zzb("IGNORING: Receive (type=binary, ns=%s) <%d bytes>", string2, byArray.length);
        }

        @Override
        public void zza(String string2, long l, int n) {
            zze zze2 = this.zzUI.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, n);
        }

        @Override
        public void zzd(String string2, long l) {
            zze zze2 = this.zzUI.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zza(zze zze2, long l, int n) {
            zza.zzb zzb2;
            Map map = zze2.zzUA;
            synchronized (map) {
                zzb2 = (zza.zzb)zze2.zzUA.remove(l);
            }
            if (zzb2 != null) {
                zzb2.zzm(new Status(n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(zze zze2, int n) {
            Object object = zzUE;
            synchronized (object) {
                if (zze2.zzUC != null) {
                    zze2.zzUC.zzm(new Status(n));
                    zze2.zzUC = null;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class zza
    implements Cast.ApplicationConnectionResult {
        private final Status zzOt;
        private final ApplicationMetadata zzUF;
        private final String zzUG;
        private final String zzFE;
        private final boolean zzUH;

        public zza(Status status, ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            this.zzOt = status;
            this.zzUF = applicationMetadata;
            this.zzUG = string2;
            this.zzFE = string3;
            this.zzUH = bl;
        }

        public zza(Status status) {
            this(status, null, null, null, false);
        }

        @Override
        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public ApplicationMetadata getApplicationMetadata() {
            return this.zzUF;
        }

        @Override
        public String getApplicationStatus() {
            return this.zzUG;
        }

        @Override
        public String getSessionId() {
            return this.zzFE;
        }

        @Override
        public boolean getWasLaunched() {
            return this.zzUH;
        }
    }
}

