/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVEditorHandler;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVReplayHandler
extends DAVEditorHandler {
    protected static final DAVElement EDITOR_REPORT = DAVElement.getElement("svn:", "editor-report");
    protected static final DAVElement OPEN_ROOT = DAVElement.getElement("svn:", "open-root");
    protected static final DAVElement APPLY_TEXT_DELTA = DAVElement.getElement("svn:", "apply-textdelta");
    protected static final DAVElement CLOSE_FILE = DAVElement.getElement("svn:", "close-file");
    protected static final DAVElement CLOSE_DIRECTORY = DAVElement.getElement("svn:", "close-directory");
    protected static final DAVElement CHANGE_FILE_PROPERTY = DAVElement.getElement("svn:", "change-file-prop");
    protected static final DAVElement CHANGE_DIR_PROPERTY = DAVElement.getElement("svn:", "change-dir-prop");
    protected static final String CHECKSUM_ATTR = "checksum";
    protected static final String DEL_ATTR = "del";

    public static StringBuffer generateReplayRequest(long highRevision, long lowRevision, boolean sendDeltas) {
        StringBuffer xmlBuffer = new StringBuffer();
        SVNXMLUtil.addXMLHeader(xmlBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "replay-report", SVN_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, xmlBuffer);
        SVNXMLUtil.openCDataTag("S", "revision", String.valueOf(highRevision), xmlBuffer);
        SVNXMLUtil.openCDataTag("S", "low-water-mark", String.valueOf(lowRevision), xmlBuffer);
        SVNXMLUtil.openCDataTag("S", "send-deltas", sendDeltas ? "1" : "0", xmlBuffer);
        SVNXMLUtil.addXMLFooter("S", "replay-report", xmlBuffer);
        return xmlBuffer;
    }

    public DAVReplayHandler(ISVNEditor editor, boolean fetchContent) {
        super(null, null, editor, null, fetchContent, false, null);
    }

    @Override
    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (element == TARGET_REVISION) {
            String rev = attrs.getValue("rev");
            if (rev == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing revision attr in target-revision element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            } else {
                try {
                    this.myEditor.targetRevision(Long.parseLong(rev));
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
                }
            }
        } else if (element == OPEN_ROOT) {
            String rev = attrs.getValue("rev");
            if (rev == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing revision attr in open-root element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            } else {
                try {
                    this.myEditor.openRoot(Long.parseLong(rev));
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
                }
                this.myPath = "";
                this.myIsDirectory = true;
            }
        } else if (element == DELETE_ENTRY) {
            String path = attrs.getValue("name");
            String rev = attrs.getValue("rev");
            if (path == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in delete-entry element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            } else if (rev == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing rev attr in delete-entry element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            } else {
                try {
                    this.myEditor.deleteEntry(path, Long.parseLong(rev));
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
                }
            }
        } else if (element == OPEN_DIRECTORY || element == ADD_DIRECTORY) {
            String path = attrs.getValue("name");
            String rev = attrs.getValue("rev");
            if (path == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in " + (element == OPEN_DIRECTORY ? "open-directory" : "add-directory") + " element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            } else {
                long revision = -1L;
                if (rev != null) {
                    try {
                        revision = Long.parseLong(rev);
                    }
                    catch (NumberFormatException nfe) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
                    }
                }
                if (element == OPEN_DIRECTORY) {
                    this.myEditor.openDir(path, revision);
                } else {
                    String copyFromPath = attrs.getValue("copyfrom-path");
                    String cfRevision = attrs.getValue("copyfrom-rev");
                    long copyFromRevision = -1L;
                    if (cfRevision != null) {
                        try {
                            copyFromRevision = Long.parseLong(cfRevision);
                        }
                        catch (NumberFormatException nfe) {
                            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
                        }
                    }
                    this.myEditor.addDir(path, copyFromPath, copyFromRevision);
                }
            }
            this.myPath = path;
            this.myIsDirectory = true;
        } else if (element == OPEN_FILE || element == ADD_FILE) {
            String path = attrs.getValue("name");
            if (path == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in " + (element == OPEN_FILE ? "open-file" : "add-file") + " element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            if (element == ADD_FILE) {
                String copyFromPath = attrs.getValue("copyfrom-path");
                String cfRevision = attrs.getValue("copyfrom-rev");
                long copyFromRevision = -1L;
                if (cfRevision != null) {
                    try {
                        copyFromRevision = Long.parseLong(cfRevision);
                    }
                    catch (NumberFormatException nfe) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
                    }
                }
                this.myEditor.addFile(path, copyFromPath, copyFromRevision);
            } else {
                String rev = attrs.getValue("rev");
                long revision = -1L;
                if (rev != null) {
                    try {
                        revision = Long.parseLong(rev);
                    }
                    catch (NumberFormatException nfe) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
                    }
                }
                this.myEditor.openFile(path, revision);
            }
            this.myIsDirectory = false;
            this.myPath = path;
        } else if (element == APPLY_TEXT_DELTA) {
            if (this.myIsDirectory) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Got apply-textdelta element without preceding add-file or open-file");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            String checksum = attrs.getValue(CHECKSUM_ATTR);
            try {
                this.myEditor.applyTextDelta(this.myPath, checksum);
                this.setDeltaProcessing(true);
            }
            catch (SVNException rev) {}
        } else if (element == CLOSE_FILE) {
            if (this.myIsDirectory) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Got close-file element without preceding add-file or open-file");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            } else {
                String checksum = attrs.getValue(CHECKSUM_ATTR);
                this.myEditor.closeFile(this.myPath, checksum);
                this.myIsDirectory = true;
            }
        } else if (element == CLOSE_DIRECTORY) {
            if (!this.myIsDirectory) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Got close-directory element without ever opening a directory");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            } else {
                this.myEditor.closeDir();
            }
        } else if (element == CHANGE_FILE_PROPERTY || element == CHANGE_DIR_PROPERTY) {
            String name = attrs.getValue("name");
            if (name == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in " + (element == CHANGE_FILE_PROPERTY ? "change-file-prop" : "change-dir-prop") + " element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            } else if (attrs.getValue(DEL_ATTR) != null) {
                if (element == CHANGE_FILE_PROPERTY) {
                    this.myEditor.changeFileProperty(this.myPath, name, null);
                } else {
                    this.myEditor.changeDirProperty(name, null);
                }
                this.myPropertyName = null;
            } else {
                this.myPropertyName = name;
            }
        }
    }

    @Override
    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == APPLY_TEXT_DELTA) {
            this.setDeltaProcessing(false);
        } else if (element == CHANGE_FILE_PROPERTY || element == CHANGE_DIR_PROPERTY) {
            if (cdata != null && !"".equals(cdata.toString()) && this.myPropertyName == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Got cdata content for a prop delete");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            if (this.myPropertyName != null) {
                SVNPropertyValue propertyValue = this.createPropertyValueFromBase64(null, this.myPropertyName, cdata);
                if (element == CHANGE_FILE_PROPERTY) {
                    this.myEditor.changeFileProperty(this.myPath, this.myPropertyName, propertyValue);
                } else {
                    this.myEditor.changeDirProperty(this.myPropertyName, propertyValue);
                }
            }
        }
    }
}

