/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching;

import bmsi.util.Diff;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.tokenizer.ITokenizer;

public final class DiffDriver {
    public static final Pattern DIFF_MERGEABLE_DELIMITER_PATTERN = Pattern.compile("[ :;,.()]+");

    private DiffDriver() {
    }

    public static Render render(String original, String revised, boolean optimize) {
        Render result = new Render();
        ITokenizer tokenizer = Core.getProject().getSourceTokenizer();
        if (tokenizer == null) {
            return result;
        }
        Object[] originalStrings = tokenizer.tokenizeVerbatimToStrings(original);
        Object[] revisedStrings = tokenizer.tokenizeVerbatimToStrings(revised);
        if (originalStrings == null || revisedStrings == null) {
            return result;
        }
        Diff diff = new Diff(originalStrings, revisedStrings);
        Diff.change script = diff.diff_2(false);
        assert (DiffDriver.validate(script, (String[])originalStrings, (String[])revisedStrings));
        StringBuilder rawText = new StringBuilder();
        for (int n = 0; n <= originalStrings.length; ++n) {
            int m;
            int start;
            Diff.change c = DiffDriver.search(n, script);
            if (c == null) {
                if (n >= originalStrings.length) continue;
                if (optimize) {
                    result.addRun(rawText.length(), ((String)originalStrings[n]).length(), Type.NOCHANGE);
                }
                rawText.append((String)originalStrings[n]);
                continue;
            }
            script = c.link;
            if (c.deleted > 0) {
                start = rawText.length();
                for (m = 0; m < c.deleted; ++m) {
                    rawText.append((String)originalStrings[n + m]);
                }
                n += c.deleted - 1;
                result.addRun(start, rawText.length() - start, Type.DELETE);
            }
            if (c.inserted <= 0) continue;
            start = rawText.length();
            for (m = 0; m < c.inserted; ++m) {
                rawText.append((String)revisedStrings[c.line1 + m]);
            }
            result.addRun(start, rawText.length() - start, Type.INSERT);
            if (c.deleted != 0 || n >= originalStrings.length) continue;
            if (optimize) {
                result.addRun(rawText.length(), ((String)originalStrings[n]).length(), Type.NOCHANGE);
            }
            rawText.append((String)originalStrings[n]);
        }
        result.text = rawText.toString();
        if (optimize) {
            Render optimized = DiffDriver.optimizeRender(result, 0);
            return optimized.formatting.size() < result.formatting.size() ? optimized : result;
        }
        return result;
    }

    private static Render optimizeRender(Render render, int level) {
        if (level > 3) {
            return render;
        }
        StringBuilder rawText = new StringBuilder();
        Render result = new Render();
        List<TextRun> fList = render.formatting;
        if (fList.size() < 5) {
            return render;
        }
        for (int i = 0; i < fList.size(); ++i) {
            TextRun r0 = fList.get(i);
            if (i < fList.size() - 4) {
                TextRun r1 = fList.get(i + 1);
                TextRun r2 = fList.get(i + 2);
                TextRun r3 = fList.get(i + 3);
                TextRun r4 = fList.get(i + 4);
                if (r0.type == Type.DELETE && r1.type == Type.INSERT && r2.type == Type.NOCHANGE && DIFF_MERGEABLE_DELIMITER_PATTERN.matcher(render.text.substring(r2.start, r2.start + r2.length)).matches() && r3.type == Type.DELETE && r4.type == Type.INSERT) {
                    StringBuilder buff = new StringBuilder();
                    buff.append(render.getRunText(r0));
                    buff.append(render.getRunText(r2));
                    buff.append(render.getRunText(r3));
                    result.addRun(rawText.length(), buff.length(), Type.DELETE);
                    rawText.append((CharSequence)buff);
                    buff.delete(0, buff.length());
                    buff.append(render.getRunText(r1));
                    buff.append(render.getRunText(r2));
                    buff.append(render.getRunText(r4));
                    result.addRun(rawText.length(), buff.length(), Type.INSERT);
                    rawText.append((CharSequence)buff);
                    i += 4;
                    continue;
                }
            }
            result.addRun(rawText.length(), r0.length, r0.type);
            rawText.append(render.getRunText(r0));
        }
        result.text = rawText.toString();
        Render optimized = DiffDriver.optimizeRender(result, level + 1);
        return optimized.formatting.size() < result.formatting.size() ? optimized : result;
    }

    private static Diff.change search(int i, Diff.change script) {
        if (script == null || script.line0 > i) {
            return null;
        }
        if (script.line0 == i) {
            return script;
        }
        return DiffDriver.search(i, script.link);
    }

    private static boolean validate(Diff.change script, String[] original, String[] revised) {
        Diff.change prev = null;
        Diff.change c = script;
        while (c != null) {
            if (prev != null && (c.line0 <= prev.line0 || c.line1 <= prev.line1)) {
                return false;
            }
            if (c.line0 < 0 || c.line0 > original.length) {
                return false;
            }
            prev = c;
            c = c.link;
        }
        return true;
    }

    public static class TextRun {
        public int start;
        public int length;
        public Type type;

        public TextRun(int start, int length, Type type) {
            assert (start >= 0);
            assert (length >= 1);
            assert (type != null);
            this.start = start;
            this.length = length;
            this.type = type;
        }

        public String toString() {
            return String.format("%s: %d +%d", new Object[]{this.type, this.start, this.length});
        }
    }

    public static class Render {
        public List<TextRun> formatting = new LinkedList<TextRun>();
        public String text;

        public void addRun(int start, int length, Type type) {
            this.formatting.add(new TextRun(start, length, type));
        }

        public String getRunText(TextRun run) {
            return this.text.substring(run.start, run.start + run.length);
        }
    }

    public static enum Type {
        INSERT,
        DELETE,
        NOCHANGE;

    }
}

