/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.CompressedIndexFileBuffer;
import htsjdk.samtools.IndexFileBuffer;
import htsjdk.samtools.MemoryMappedFileBuffer;
import htsjdk.samtools.RandomAccessFileBuffer;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.IOException;

class IndexFileBufferFactory {
    IndexFileBufferFactory() {
    }

    static IndexFileBuffer getBuffer(File file, boolean enableMemoryMapping) {
        boolean isCompressed;
        try {
            isCompressed = IOUtil.isBlockCompressed(file.toPath());
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
        return isCompressed ? new CompressedIndexFileBuffer(file) : (enableMemoryMapping ? new MemoryMappedFileBuffer(file) : new RandomAccessFileBuffer(file));
    }
}

