#!/usr/bin/python
# -*- coding: utf-8 -*-
#
#     Copyright (C) 2018 Jester
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program. If not, see <http://www.gnu.org/licenses/>.
#

from kodiswift import Plugin, xbmc

plugin = Plugin()

@plugin.route('/')
def show_tmos_list():
    items = [

  {'label': 'TMOS Episodes on YouTube',
   'icon': 'special://home/addons/plugin.video.tmos/icon.png',
   'path': 'plugin://plugin.video.youtube/channel/UCtO6jOECGV2FQHj4RGOXyDA/?page=1',
   'selected': True,
  },

  {'label': 'TMOS Live Stream (Mon. through Fri. 09:00am EST)',
   'icon': 'special://home/addons/plugin.video.tmos/icon.png',
   'path': 'plugin://plugin.video.youtube/play/?channel_id=UCtO6jOECGV2FQHj4RGOXyDA&live=1',
   'is_playable': True,
  },
  
  {'label': 'TMOS 24/7 Audio Stream',
   'icon': 'special://home/addons/plugin.video.tmos/icon.png',
   'path': 'http://playerservices.streamtheworld.com/api/livestream-redirect/TMOS.mp3',
   'is_playable': True,
  },
]
    return plugin.finish(items)

def log(text):
    plugin.log.info(text)

if __name__ == '__main__':
    plugin.run()
