16 April 2018

> **Important**: [Review the documentation](https://docs.projectcalico.org/v3.0/getting-started/kubernetes/upgrade/) carefully before attempting an upgrade.
> You must upgrade to {{site.prodname}} v2.6.5 or later before you can upgrade to {{site.prodname}} v3.0.5.
{: .alert .alert-danger}

#### Bug Fixes

- Add support for configuring container IP forwarding via the CNI configuration file. [cni-plugin #508](https://github.com/projectcalico/cni-plugin/pull/508) (@caseydavenport)
- When auto-detecting a node name, {{site.prodname}} will convert the hostname to lowercase. [calico #1880](https://github.com/projectcalico/calico/pull/1880) (@robbrockbank)
- Fix bug [typha #118](https://github.com/projectcalico/typha/issues/118) where {{site.nodecontainer}} and Typha race to create the cluster information resource, causing Typha to crash. [libcalico-go #845](https://github.com/projectcalico/libcalico-go/pull/845) (@robbrockbank)
- Improve confd behavior when using the Kubernetes API datastore with node-to-node mesh disabled. [libcalico-go #838](https://github.com/projectcalico/libcalico-go/pull/838) (@caseydavenport)
- Support '.' character in interface names [libcalico-go #832](https://github.com/projectcalico/libcalico-go/pull/832) (@codertux)
- Fix an interaction between failsafe inbound/outbound ports and do-not-track policy that resulted in failsafe ports being blocked if do-not-track policy was added. [felix #1775](https://github.com/projectcalico/felix/pull/1775) (@fasaxc)

#### Build changes

- Backport s390x build support [cni-plugin #502](https://github.com/projectcalico/cni-plugin/pull/502) (@fasaxc)
- Backport s390x build support [kube-controllers #241](https://github.com/projectcalico/kube-controllers/pull/241) (@fasaxc)
- Backport s390x build support [calico #1868](https://github.com/projectcalico/calico/pull/1868) (@fasaxc)
- Backport s390x build support [felix #1783](https://github.com/projectcalico/felix/pull/1783) (@fasaxc)
- Backport s390x build support [calicoctl #1839](https://github.com/projectcalico/calicoctl/pull/1839) (@fasaxc)
- Backport s390x build support [typha #137](https://github.com/projectcalico/typha/pull/137) (@fasaxc)

#### Limitations

- **Offers only Kubernetes, OpenShift, and host endpoint integrations**: the
  OpenStack, Mesos, DC/OS, rkt, and Docker orchestrators have not been tested
  and are not supported. ({{site.prodname}} still supports Docker and rkt containers.)
  We plan to resume support for the OpenStack, Mesos, DC/OS, and Docker
  orchestrators in a future release.

- **GoBGP not supported**: Setting the `CALICO_NETWORKING_BACKEND` environment
  variable to `gobgp` is not supported. See [Configuring {{site.nodecontainer}}](https://docs.projectcalico.org/v3.0/reference/node/configuration)
  for more information. We plan to resume support for GoBGP in a future release.

- **Route reflectors cannot be clustered**: We plan to resume support for
  this in a future release.
