15 Oct 2025

#### Bug fixes

- Reinstate support for VMs that are configured not to respond to ARP requests. [calico 11099](https://github.com/projectcalico/calico/pull/11099) (@nelljerram)
- Fix that IPAM allocation could leak handles when many workloads are scheduled to the same node at the same time, causing timeouts by "thundering herd". [calico 11096](https://github.com/projectcalico/calico/pull/11096) (@fasaxc)
- Fix slow IPAM release performance when releasing IPs from disabled or deleted pools (especially for bulk deletions like those done by IPAM GC). Consider disabled pools as potential IP owners and cache any loaded blocks for fast access. [calico 11095](https://github.com/projectcalico/calico/pull/11095) (@fasaxc)
- nftables: fix reprogramming of base chain rules after out-of-band flush. [calico 10939](https://github.com/projectcalico/calico/pull/10939) (@caseydavenport)
- Helm: fix role binding to use correct serviceaccount name when deployed in an alternative namespace. [calico 10908](https://github.com/projectcalico/calico/pull/10908) (@caseydavenport)

#### Other changes

- ebpf: calico-node -bpf policy dump prints the End of (Rule | Policy | Tier) in the default concise output [calico 11157](https://github.com/projectcalico/calico/pull/11157) (@tomastigera)
- ebpf: Added a new Felix configuration option `CgroupV2Path` to set a custom cgroupV2 mount path, improving compatibility with immutable OSes like Talos Linux. [calico 11131](https://github.com/projectcalico/calico/pull/11131) (@lucastigera)
- ebpf: BPFKubeProxyHealtzPort allows to change the kube-proxy healthz server port [calico 11054](https://github.com/projectcalico/calico/pull/11054) (@tomastigera)
- Make Calico's backing CRDs optional. Calico will no longer fail to start if a CRD is missing. [calico 11036](https://github.com/projectcalico/calico/pull/11036) (@caseydavenport)
- Add missing staged policy permissions to apiserver.yaml [calico 11032](https://github.com/projectcalico/calico/pull/11032) (@caseydavenport)
- OpenStack QoS handling has been improved to respond immediately to all kinds of QoS changes on the Neutron API.  In particular when rules are added, updated or deleted for a QoS policy that is already in use, and when a QoS policy is added, updated or deleted for a Neutron network that is already in use.  Calico's handling of these changes previously relied on a periodic resync, which could in practice take a long time; now those changes are handled immediately (within a few seconds). [calico 11006](https://github.com/projectcalico/calico/pull/11006) (@nelljerram)
- When the AssumeNeededOnEveryNode performance hint is set on a policy, the iptables dataplane now renders the policy rules to the filter table, even if the chain is not yet referenced; this reduces the work needed when a new workload arrives needing the policy. [calico 10999](https://github.com/projectcalico/calico/pull/10999) (@fasaxc)
- Improve Whisker UI display of enforced and pending policy traces. [calico 10938](https://github.com/projectcalico/calico/pull/10938) (@caseydavenport)
- Remove manual Windows Kubernetes service installation [calico 10916](https://github.com/projectcalico/calico/pull/10916) (@song-jiang)
