Calico Open Source 3.27 release notes
=====================================

Learn about the new features, bug fixes, and other updates in this release of Calico.

New features and enhancements
---------------------------------------------------------------------------------------------------------------

### HPC-based Windows install and upgrade

We've added support for Operator-based install and upgrade for Windows nodes using HPC (HostProcess/Privileged containers)/ Calico can now bootstrap Windows worker nodes just like Linux worker nodes. Platform engineers can scale Windows worker nodes with an auto-scaling node pool without bootstrapping each node manually, and upgrade Calico deployments without manually upgrading nodes one at a time.

For more information, see [the Calico for Windows Operator guide](https://docs.tigera.io/calico/3.27/getting-started/kubernetes/windows-calico/operator).

### Support for Azure CNI with overlay networking for AKS

We've add supported for Azure CNI with overlay networking for AKS clusters. This option augments support for the Azure CNI with no overlay where a VNet IP address is assigned to every pod, which can lead to IP address exhaustion.

To review Azure CNI options, see [Microsoft Azure Kubernetes Service (AKS)](https://docs.tigera.io/calico/3.27/getting-started/kubernetes/managed-public-cloud/aks).

### Calico with VPP data plane is generally available

The VPP data plane has been validated in Calico and is ready for general use.

For more information, see [Get started with VPP networking](https://docs.tigera.io/calico/3.27/getting-started/kubernetes/vpp/getting-started).

### Improved Felix performance for extremely large clusters

This release adds improvements to how Felix processes active policy rules for clusters with extremely high numbers of endpoints and policy rules. Previously, calculating selector-based rules in these circumstances could take a long time or end in failure. Now Felix can perform these calculations quickly while reducing CPU usage by orders of magnitude.

For more information, see [Selector performance in EntityRules](https://docs.tigera.io/calico/3.27/reference/resources/globalnetworkpolicy#selector-performance-in-entityrules).

### Enhancements

*   Use upstream hcsshim package instead of fork and update it to latest stable version (v0.11.4). [calico #8192](https://github.com/projectcalico/calico/pull/8192) (@coutinhop)
*   Enhance BGPFilter to filter route advertisement to BGP peers based on route's interface. Calico nodes stop advertising tunnel routes to iBGP peers as the routes are programmed by Felix. If you are doing iBGP peering with external peers this should not affect since the workload's routes are still advertised. Felix expect either .cali or .calico suffix for tunnel names like Wireguard. [calico #8175](https://github.com/projectcalico/calico/pull/8175) (@mazdakn)
*   We no longer provide Calico packages for OpenStack on Ubuntu Bionic or older, or test ourselves on Bionic, as it has become difficult to build a working Felix package for Bionic, due to glibc and libpcap library API version issues, and Bionic is now more than 5 years old and beyond its Canonical LTS period. Our current recommendation is to use Calico with OpenStack Yoga on Ubuntu Focal or later. [calico #8157](https://github.com/projectcalico/calico/pull/8157) (@nelljerram)
*   Enhance BGPFilter to filter route advertisement to BGP peers based on route's origin. [calico #8149](https://github.com/projectcalico/calico/pull/8149) (@mazdakn)
*   Update Typha Deployment tolerations to helm charts so that it can be scheduled on any node. [calico #7979](https://github.com/projectcalico/calico/pull/7979) (@ffilippopoulos)
*   kube controllers run as a non-root user in s390x builds by default [calico #7955](https://github.com/projectcalico/calico/pull/7955) (@liudalibj)
*   calico-node -bpf dump policy now suppresses printing assembly by default. You need to use --asm flag \[or -a\] to see the assembly as well. [calico #7954](https://github.com/projectcalico/calico/pull/7954) (@StevenTigera)
*   Add a timeout to Typha's TLS handshake. [calico #7909](https://github.com/projectcalico/calico/pull/7909) (@rodrigorfk)
*   Add pre-deletion hook to helm chart to facilitate `helm uninstall` [calico #7859](https://github.com/projectcalico/calico/pull/7859) (@caseydavenport)
*   Don't write AS number to node if running with CALICO\_NETWORKING\_BACKEND=none. [calico #7821](https://github.com/projectcalico/calico/pull/7821) (@tobiasgiese)
*   Add pod security standard annotation to the tigera-operator namespace for Kubernetes 1.25+ [calico #7732](https://github.com/projectcalico/calico/pull/7732) (@si458)
*   allows reference to existing secrets for imagePullSecrets without passing the secret itself to helm. this enables management of secrets by an external system like sealedsecrets and prevents the secret data from being stored in helm. It works by allowing use of the installation's imagePullSecret field directly, whereas previously only the toplevel imagePullSecrets field was used. [calico #7657](https://github.com/projectcalico/calico/pull/7657) (@ozdanborne)
*   eBPF: Allow user to specify a regexp of interfaces that we want to turn GRO off at. [calico #7633](https://github.com/projectcalico/calico/pull/7633) (@StevenTigera)
*   Calico's integration code for OpenStack has been updated for OpenStack Yoga. [calico #7625](https://github.com/projectcalico/calico/pull/7625) (@nelljerram)
*   Add support for OpenStack on Ubuntu Jammy [calico #7622](https://github.com/projectcalico/calico/pull/7622) (@danudey)
*   BPF mode: add felix configuration parameter to allow NOTRACK to be disabled for certain external interfaces interfaces. Useful for workaround conflicts with non-Calico networked containers etc. [calico #7595](https://github.com/projectcalico/calico/pull/7595) (@StevenTigera)
*   Expose the configuration for the CSI plugin in the operator helm chart [calico #7480](https://github.com/projectcalico/calico/pull/7480) (@nimimeht)

Technology preview features
---------------------------------------------------------------------------------------------------------

### IPv6 support for eBPF

Calico now supports IPv6 in the eBPF data plane.

For more information, see [Enable the eBPF data plane](https://docs.tigera.io/calico/3.27/operations/ebpf/enabling-ebpf).

Bug fixes
---------------------------------------------------

*   Prevent IPAM garbage collection from freezing when under high load [calico #8154](https://github.com/projectcalico/calico/pull/8154) (@JuoCode)
*   Correct policy for OpenStack sec group with no remote\_ip\_prefix [calico #8026](https://github.com/projectcalico/calico/pull/8026) (@nelljerram)
*   Fixed AWS ec2 detection not working with imdsv2 on Calico for Windows. [calico #7970](https://github.com/projectcalico/calico/pull/7970) (@davidgiga1993)
*   Fix panic when running 'calicoctl get nodes' when ASNumber was not present in the default BGPConfiguration. [calico #7858](https://github.com/projectcalico/calico/pull/7858) (@coutinhop)
*   Fix a few instances where KUBECONFIG was not respected [calico #7796](https://github.com/projectcalico/calico/pull/7796) (@skmatti)
*   Fix helm chart rendering multiple image pull secrets incorrectly [calico #7752](https://github.com/projectcalico/calico/pull/7752) (@oxr463)
*   Fix YAML injection vulnerabilities due to unsafe templating [calico #7642](https://github.com/projectcalico/calico/pull/7642) (@skmatti)
*   Fix 'error while loading shared libraries: libresolv.so.2: cannot open shared object file' on csi-node-driver-registrar. [calico #7586](https://github.com/projectcalico/calico/pull/7586) (@coutinhop)
*   Fix a divide-by-zero panic in Typha if it received a SIGTERM when it had no active connections. Since Typha exits in either case, the impact was limited to a scary panic log. [calico #7585](https://github.com/projectcalico/calico/pull/7585) (@fasaxc)
*   Fix a divide-by-zero panic in Typha if it received a SIGTERM when it had no active connections. Since Typha exits in either case, the impact was limited to a scary panic log. [calico #7575](https://github.com/projectcalico/calico/pull/7575) (@fasaxc)
*   When running Calico in policy-only mode, do not write the IP annotations to the node. [calico #7550](https://github.com/projectcalico/calico/pull/7550) (@skmatti)
*   eBPF: fixed host access to self and a service that redirects to self without CTLB [calico #8189](https://github.com/projectcalico/calico/pull/8189) (@tomastigera)
*   Fix incorrect conversion to 16-bit offset in the BPF assembler. Fail if the value would wrap. [calico #8176](https://github.com/projectcalico/calico/pull/8176) (@fasaxc)
*   eBPF: icmp errors must be always treated as related, not only after a CT miss. [calico #8153](https://github.com/projectcalico/calico/pull/8153) (@tomastigera)
*   eBPF: Config option added for host networked NAT. Change in the configs related to connect time load balancing. [calico #8139](https://github.com/projectcalico/calico/pull/8139) (@sridhartigera)
*   BPF mode: fix that netlink IP sets were programmed even in BPF mode until the first policy/endpoint deletion event. [calico #8101](https://github.com/projectcalico/calico/pull/8101) (@fasaxc)
*   eBPF: fixes felix panic upon restart in debug mode when there are existing policy counters [calico #7797](https://github.com/projectcalico/calico/pull/7797) (@tomastigera)
*   eBPF: fix applyOnforward=false in global policies [calico #7707](https://github.com/projectcalico/calico/pull/7707) (@tomastigera)
*   eBPF: handles IPv4 packets with IP options. XDP only does so in kernels 5.18+ it drops them in older kernels. [calico #7701](https://github.com/projectcalico/calico/pull/7701) (@tomastigera)
*   eBPF - only report errors setting /proc/sys/net/../accept\_local etc. if the device is present [calico #7631](https://github.com/projectcalico/calico/pull/7631) (@tomastigera)

