09 Jan 2023

#### eBPF Dataplane Stability: Connect Time Load Balancing (CTLB)

In certain scenarios, Calico would not update rapidly changing pods and IPs properly. We have added
some large changes to the eBPF dataplane in order to ensure that connect time load balancing works
in larger, rapidly changing environments.

Pull Requests:
 - ebpf: ipv4 and ipv6 code separated to different object files so the v6 code gets never loaded outside tests. [calico #7093](https://github.com/projectcalico/calico/pull/7093) (@tomastigera)
 - ebpf: CTLB resolves service when ipv4 is masked as ipv6. Commonly happens with grpc. [calico #7087](https://github.com/projectcalico/calico/pull/7087) (@tomastigera)
 - ebpf: we can apply the CTLB-turned-off workaround just to UDP [calico #6783](https://github.com/projectcalico/calico/pull/6783) (@tomastigera)
 - ebpf: host can accesses services without CTLB - gated feature [calico #6527](https://github.com/projectcalico/calico/pull/6527) (@tomastigera)

#### Bug fixes

##### General
 - Fix incorrect cleanup in the service policy index after having both ingress and egress rules that reference the same service, resulting in missed IP set updates after one rule was deactivated. [calico #7148](https://github.com/projectcalico/calico/pull/7148) (@fasaxc)
 - Fix panic in calico-node when invalid spoofed IP range provided on a pod. [calico #7076](https://github.com/projectcalico/calico/pull/7076) (@caseydavenport)
 - fixed felix docs for bpf config options [calico #7065](https://github.com/projectcalico/calico/pull/7065) (@tomastigera)
 - Fix missing nsswitch files in Typha causing localhost lookup fails [calico #6971](https://github.com/projectcalico/calico/pull/6971) (@wdoekes)
 - Fix that Calico would try to use the IPV6 VXLAN or Wireguard tunnel devices for its BGP connections. [calico #6929](https://github.com/projectcalico/calico/pull/6929) (@coutinhop)
 - Fix that Calico would try to use the VXLAN tunnel device for its BGP connections. [calico #6902](https://github.com/projectcalico/calico/pull/6902) (@caseydavenport)
 - Add missing Auto option for IptablesBackend FelixConfiguration field [calico #6871](https://github.com/projectcalico/calico/pull/6871) (@huiyizzz)
 - Fix an issue that caused annotations and labels to be overwritten during a calicoctl patch command [calico #6791](https://github.com/projectcalico/calico/pull/6791) (@mgleung)
 - Fixed SyncLabels validation for Kubernetes datastore. [calico #6786](https://github.com/projectcalico/calico/pull/6786) (@huiyizzz)
 - Fix issues with OCP installs using the wrong operator manifest. [calico #6724](https://github.com/projectcalico/calico/pull/6724) (@mgleung)
 - Fix bug in IPv6 router ID calculation on IPv6 single-stack clusters that resulted in invalid router IDs being calculated. Note that this change will result in new router IDs being used for some IPv6 single-stack nodes. [calico #6674](https://github.com/projectcalico/calico/pull/6674) (@ramanujadasu)
 - Fix that `calicoctl ipam release` could only release IPAM handles when running in etcd mode. [calico #6650](https://github.com/projectcalico/calico/pull/6650) (@fasaxc)
 - Fix issue in L3RouteResolver CIDRTrie which could result in crashes when the IPv6 trie had a node with a /63 prefix. [calico #6532](https://github.com/projectcalico/calico/pull/6532) (@coutinhop)
 - Fix nil error logged from kube-controllers health reporter [calico #6513](https://github.com/projectcalico/calico/pull/6513) (@caseydavenport)
 - Fix that kube-controllers health checks didn't include a timeout on HTTP calls [calico #6513](https://github.com/projectcalico/calico/pull/6513) (@caseydavenport)
 - Set IPIPMode and VXLANMode to the default "Never" if they are empty strings in IPPools. [calico #6498](https://github.com/projectcalico/calico/pull/6498) (@coutinhop)
 - Fix that single-IP entries on BGPConfiguration LoadBalancerIPs were not advertised according to external traffic policy. [calico #6282](https://github.com/projectcalico/calico/pull/6282) (@mtryfoss)
 - fix: ErrorActionPreference must continue for kubectl commands Issue #6127 [calico #6257](https://github.com/projectcalico/calico/pull/6257) (@chrisjohnson00)

##### eBPF
 - ebpf: fix error setting accept_local - device may get stuck dirty [calico #7071](https://github.com/projectcalico/calico/pull/7071) (@tomastigera)
 - ebpf: no src fixup on host iface for traffic returning from pod to the nodeport tunnel [calico #7039](https://github.com/projectcalico/calico/pull/7039) (@tomastigera)
 - ebpf: XDP (notrack) policy debug output is removed/cleaned up when XDP program is removed (fix) [calico #6994](https://github.com/projectcalico/calico/pull/6994) (@tomastigera)
 - ebpf: fixes ifstate leak when devices go down [calico #6946](https://github.com/projectcalico/calico/pull/6946) (@tomastigera)

##### Windows
 - Fixed issue when Calico Windows hostprocess installation would fail to clean up a previous manual install of Calico Windows. [calico #6952](https://github.com/projectcalico/calico/pull/6952) (@coutinhop)
 - Fix issues with the windows node names in GCE [calico #6470](https://github.com/projectcalico/calico/pull/6470) (@lmm)

##### Wireguard
 - Limit rate of logging 'Wireguard is not supported' to fix log spam issues. [calico #6534](https://github.com/projectcalico/calico/pull/6534) (@coutinhop)

#### Other changes

##### General
 - Felix now supports overriding the timeouts of its internal readiness/liveness watchdog.  This is useful for dealing with issues "in prod" without needing a new release.  The timeouts have also been tuned to reduce false positives. [calico #7061](https://github.com/projectcalico/calico/pull/7061) (@fasaxc)
 - Typha now shares snapshots between clients that connect at roughly the same time. This dramatically reduces load when many clients connect at once. [calico #7047](https://github.com/projectcalico/calico/pull/7047) (@fasaxc)
 - By default, skip bridge interface created by `docker network create` command in IP auto-detection [calico #7045](https://github.com/projectcalico/calico/pull/7045) (@masap)
 - The Typha protocol now supports compression.  This is enabled automatically if client and server both support it. [calico #7043](https://github.com/projectcalico/calico/pull/7043) (@fasaxc)
 - Add ignorable interfaces via the BGPConfiguration API [calico #7006](https://github.com/projectcalico/calico/pull/7006) (@huiyizzz)
 - Typha now supports graceful shut down, disconnecting calico-node pods at a configured rate instead of all at once. [calico #6973](https://github.com/projectcalico/calico/pull/6973) (@fasaxc)
 - Update installation documentation for AWS to include information regarding and links for CSI driver installation [calico #6967](https://github.com/projectcalico/calico/pull/6967) (@Josh-Tigera)
 - Update golang from 1.18.7 to 1.18.8 to avoid CVEs. [calico #6961](https://github.com/projectcalico/calico/pull/6961) (@Behnam-Shobiri)
 - By default, skip 'podman' interface in IP auto-detection [calico #6950](https://github.com/projectcalico/calico/pull/6950) (@OrvilleQ)
 - By default, skip 'nodelocaldns' interface in IP auto-detection [calico #6942](https://github.com/projectcalico/calico/pull/6942) (@cyclinder)
 - ebpf: faster program loading for workload endpoint - unused programs not loaded. [calico #6933](https://github.com/projectcalico/calico/pull/6933) (@tomastigera)
 - Remove problematic terminology from the codebase. [calico #6912](https://github.com/projectcalico/calico/pull/6912) (@fasaxc)
 - Update Istio support to include Istio v1.15.2 [calico #6890](https://github.com/projectcalico/calico/pull/6890) (@frozenprocess)
 - Add generalized TTL security mechanism (GTSM) via BGPPeer API [calico #6862](https://github.com/projectcalico/calico/pull/6862) (@Josh-Tigera)
 - Retain OpenSSL FIPS dependent files in calico-node image. [calico #6852](https://github.com/projectcalico/calico/pull/6852) (@hjiawei)
 - Disable VXLAN checksum offload by default for all kernels.  If this was fixed, it has since been regressed. [calico #6842](https://github.com/projectcalico/calico/pull/6842) (@fasaxc)
 - Improve formatting of logged-out health reports from components such as Felix. [calico #6833](https://github.com/projectcalico/calico/pull/6833) (@fasaxc)
 - Update golang to 1.18.7 to avoid new CVEs. [calico #6824](https://github.com/projectcalico/calico/pull/6824) (@Behnam-Shobiri)
 - Updated documentation list of images to pull for deploying from private registry (now includes node-driver-registrar) [calico #6812](https://github.com/projectcalico/calico/pull/6812) (@Josh-Tigera)
 - Match full interface names in IP auto-detection default exclude list. [calico #6760](https://github.com/projectcalico/calico/pull/6760) (@neoaggelos)
 - Update multiple golang dependencies. [calico #6719](https://github.com/projectcalico/calico/pull/6719) (@Behnam-Shobiri)
 - Update the go version used to build the binaries from 1.18.5 to 1.18.6 [calico #6717](https://github.com/projectcalico/calico/pull/6717) (@Behnam-Shobiri)
 - Calico now uses a faster JSON parsing library; this reduces CPU load and improves start-up latency. [calico #6705](https://github.com/projectcalico/calico/pull/6705) (@fasaxc)
 - Reduce parsing overhead when parsing key/value pairs from Typha. [calico #6703](https://github.com/projectcalico/calico/pull/6703) (@fasaxc)
 - Many of Typha's Prometheus metrics are now split by syncer (client) type, represented by a label "syncer" on the metrics. This prevents cross-talk where the syncers would all share the same metrics and the last writer to the metric would "win". [calico #6675](https://github.com/projectcalico/calico/pull/6675) (@fasaxc)
 - The vxlanEnabled attribute from FelixConfiguration is now ignored for IPv6 VXLAN pools, allowing VXLAN to have IPv4 enabled independently from IPv6. [calico #6671](https://github.com/projectcalico/calico/pull/6671) (@muff1nman)
 - Typha now uses a B-tree for its internal cache, which allows it to export a Prometheus metric, typha_snapshot_size, that gives the total size of its current snapshot of the Calico datastore. [calico #6666](https://github.com/projectcalico/calico/pull/6666) (@fasaxc)
 - Use exponential backoff for kube-controllers health check timeout, retry sooner if failed. [calico #6610](https://github.com/projectcalico/calico/pull/6610) (@caseydavenport)
 - Bump K8S_VERSION and KUBECTL_VERSION to v1.24.3 in metadata.mk [calico #6606](https://github.com/projectcalico/calico/pull/6606) (@coutinhop)
 - Update Installation CRD to include new CSI changes introduced by recent operator API changes. [calico #6596](https://github.com/projectcalico/calico/pull/6596) (@Josh-Tigera)
 - Helm: imagePullSecrets now also applied to tigera-operator serviceaccount [calico #6591](https://github.com/projectcalico/calico/pull/6591) (@tamcore)
 - Retry kube-controllers initialization on failure [calico #6566](https://github.com/projectcalico/calico/pull/6566) (@tmjd)
 - Update the base images to alpine 3.16 for the flexvolume and CSI driver [calico #6559](https://github.com/projectcalico/calico/pull/6559) (@mgleung)
 - Windows quickstart install script creates calico service account token secret if missing [calico #6464](https://github.com/projectcalico/calico/pull/6464) (@lmm)
 - Updating the dependencies - to avoid indirect vulnerabilities (CVE) detection from scanners. [calico #6452](https://github.com/projectcalico/calico/pull/6452) (@Behnam-Shobiri)
 - added FeatureGates to Felix [calico #6381](https://github.com/projectcalico/calico/pull/6381) (@tomastigera)
 - eBPF: Add BPF counters to XDP programs, and also load XDP programs using Libbpf instead of iproute2. [calico #6371](https://github.com/projectcalico/calico/pull/6371) (@mazdakn)
 - The arm64 image of calico-kube-controllers now runs as non-root by default (similar to the amd64 image). [calico #6346](https://github.com/projectcalico/calico/pull/6346) (@ialidzhikov)

##### eBPF
 - ebpf: Include enPxxxxxx in the default BPFDataIfacePattern [calico #7077](https://github.com/projectcalico/calico/pull/7077) (@TrevorTaoARM)
 - ebpf: cleanup previously attached programs when BPFDataIfacePattern changes. [calico #7008](https://github.com/projectcalico/calico/pull/7008) (@tomastigera)
 - ebpf : BPFDisableLinuxConntrack added to FelixConfiguration resource. [calico #6641](https://github.com/projectcalico/calico/pull/6641) (@mazdakn)
 - ebpf: New felix config bpfL3IfacePattern allows to specify non calico L3 devices such as wireguard, vxlan. [calico #6612](https://github.com/projectcalico/calico/pull/6612) (@sridhartigera)

##### Windows
 - Update Windows NSSM version [calico #6861](https://github.com/projectcalico/calico/pull/6861) (@song-jiang)
 - windows: ensure calico-managed kubelet starts after the calico network has been initialized [calico #6656](https://github.com/projectcalico/calico/pull/6656) (@vitaliy-leschenko)

##### OpenStack
 - Calico for OpenStack: remove iptables programming by the DHCP agent that is no longer needed, and that was increasing the need for Felix to resync Calico's iptables programming. Existing users will see issues - i.e. a VM failing to learn its IP address at boot time - if their VM OS is old enough to have unfixed DHCP client software.  In that case the remedy is to update the VM OS.  For example, in Tigera's own testing, we updated from CirrOS 0.3.4 to CirrOS 0.6.0. [calico #6857](https://github.com/projectcalico/calico/pull/6857) (@tj90241)
 - Calico for OpenStack: prime the project (aka tenant) data cache on Neutron server startup [calico #6839](https://github.com/projectcalico/calico/pull/6839) (@tj90241)
 - Allow Calico to set MTU in OpenStack [calico #6725](https://github.com/projectcalico/calico/pull/6725) (@nelljerram)

