---
title: Typha overview
description: Use the Calico Typha daemon to increase scale and reduce impact on the datastore.
canonical_url: '/reference/typha/index'
---

The Typha daemon sits between the datastore (such as the Kubernetes API server) and many instances of Felix. Typha's main purpose is to increase scale by reducing each node's impact on the datastore.  Services such as [Felix](https://github.com/projectcalico/felix){:target="_blank"} and [confd](https://github.com/projectcalico/confd){:target="_blank"} connect to Typha instead of connecting directly to the datastore as Typha maintains a single datastore connection on behalf of all its clients. It caches the datastore state and deduplicates events so that they can be fanned out to many listeners.

> **Note**: If you are using the Kubernetes API Datastore, we recommend using Typha. Although Typha can be used with etcd, etcd v3 is already optimized to handle many clients so using it is redundant and not recommended. Operator installations always install Typha.
{: .alert .alert-info}

### Advantages

- Since one Typha instance can support hundreds of Felix instances, it reduces the load on the datastore by a large factor.
- Since Typha can filter out updates that are not relevant to Felix, it also reduces Felix's CPU usage. In a high-scale (100+ node) Kubernetes cluster, this is essential because the number of updates generated by the API server scales with the number of nodes.
