19 Jun 2020

#### Encryption using Wireguard is generally available

Calico v3.14 introduced tech-preview support for encryption using Wireguard. In v3.15, we’re excited to announce that this feature is promoted to GA.
To give it a spin, head on over to [the encryption how-to guide](https://docs.projectcalico.org/v3.15/security/encrypt-cluster-pod-traffic).

#### Datastore migration support

Calico supports two methods of data storage - directly via etcd, or via the Kubernetes API server. Calico v3.15 introduces a procedure for migrating Calico data from an etcd data store to the Kubernetes API for users who wish to do so. Using the Kubernetes API for data storage is operationally simpler, and allows users to leverage the rich Kubernetes RBAC model.

Read more in the [datastore migration guide](https://docs.projectcalico.org/v3.15/maintenance/datastore-migration).

#### OpenStack Ussuri support

In v3.15, Calico's OpenStack integration code has been updated to run under Python 3 and specifically with the Ussuri OpenStack release.

For more detail please see our [OpenStack docs](https://docs.projectcalico.org/v3.15/getting-started/openstack/requirements).

#### Bug fixes

 - Felix FV tests now run with Go's race detector enabled and a couple of low-impact data races have been fixed. [felix #2371](https://github.com/projectcalico/felix/pull/2371) (@fasaxc)
 - Fix config inheritance so that the BPF kernel version check takes precedence  over environment variables. [felix #2337](https://github.com/projectcalico/felix/pull/2337) (@fasaxc)
 - In BPF mode, fix spurious "Failed to run bpftool" logs. [felix #2313](https://github.com/projectcalico/felix/pull/2313) (@fasaxc)
 - Fixed capitalization of WireGuard `interfaceIPv4Address` (was `interfaceIpv4Address`) [libcalico-go #1260](https://github.com/projectcalico/libcalico-go/pull/1260) (@caseydavenport)
 - Fix race condition during block affinity deletion [libcalico-go #1244](https://github.com/projectcalico/libcalico-go/pull/1244) (@caseydavenport)

#### Other changes

 - By default, exclude cni.* from node IP auto detection [node #509](https://github.com/projectcalico/node/pull/509) (@kubealex)
 - Added conditional check for FELIX_HEALTHHOST env variable [node #487](https://github.com/projectcalico/node/pull/487) (@bartek-lopatka)
 - The Typha port is now included in the failsafe port lists by default. [felix #2382](https://github.com/projectcalico/felix/pull/2382) (@mgleung)
 - Felix can now run in active/passive modes. [felix #2368](https://github.com/projectcalico/felix/pull/2368) (@caseydavenport)
 - In BPF mode, support configuration of LBSourceIPRange to allow access to the cluster only from certain source IP ranges. [felix #2353](https://github.com/projectcalico/felix/pull/2353) (@sridhartigera)
 - In BPF mode, Calico now supports Kubernetes EndpointSlices as a more efficient alternative to Endpoints.  Controlled by the Felix configuration parameter `BPFKubeProxyEndpointSlicesEnabled`. [felix #2331](https://github.com/projectcalico/felix/pull/2331) (@tomastigera)
 - In BPF mode, support policy based on ICMP type and code fields [felix #2282](https://github.com/projectcalico/felix/pull/2282) (@sridhartigera)
 - For NetworkPolicy and GlobalNetworkPolicy, the use of floating point values for the `spec.Order` field is now deprecated, and will be removed entirely in a future release. Please update your policies to use integer values for ordering. [libcalico-go #1237](https://github.com/projectcalico/libcalico-go/pull/1237) (@caseydavenport)
 - Update included CustomResourceDefinitions to use the apiextensions/v1 API group and version, and include schemas for basic validation. [libcalico-go #1237](https://github.com/projectcalico/libcalico-go/pull/1237) (@caseydavenport)
 - Improve scaling characteristics when using host-local IPAM - perform fewer List API calls. [libcalico-go #1231](https://github.com/projectcalico/libcalico-go/pull/1231) (@caseydavenport)
 - Network policy now has the global() namespace selector which selects host endpoints or global network sets [libcalico-go #1229](https://github.com/projectcalico/libcalico-go/pull/1229) (@lmm)
 - Program blackhole routes for full rejectcidrs to avoid route loops [confd #322](https://github.com/projectcalico/confd/pull/322) (@matthewdupre)
 - install-cni.sh now also fails if `calico -v` doesn't work after copying the calico binary [cni-plugin #889](https://github.com/projectcalico/cni-plugin/pull/889) (@sbueringer)
 - Upstream CNI plugins updated to v0.8.6 [cni-plugin #887](https://github.com/projectcalico/cni-plugin/pull/887) (@lmm)
 - Typha no longer uses Get requests to determine the number of nodes in the cluster, using watches instead. [typha #366](https://github.com/projectcalico/typha/pull/366) (@caseydavenport)
 - The quickstart guide now uses the Tigera operator to install Calico. [calico #3622](https://github.com/projectcalico/calico/pull/3622) (@caseydavenport)
 - Update manifests to use apiextensions/v1 CRDs, including schema [calico #3579](https://github.com/projectcalico/calico/pull/3579) (@caseydavenport)

#### Known issues

 - Blackhole route for service CIDR can prevent host from accessing service cluster IPs [calico #3689](https://github.com/projectcalico/calico/issues/3689) (@neiljerram)
