// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func TestExemplarSlice(t *testing.T) {
	es := NewExemplarSlice()
	assert.Equal(t, 0, es.Len())
	es = newExemplarSlice(&[]otlpmetrics.Exemplar{})
	assert.Equal(t, 0, es.Len())

	emptyVal := NewExemplar()
	testVal := generateTestExemplar()
	for i := 0; i < 7; i++ {
		el := es.AppendEmpty()
		assert.Equal(t, emptyVal, es.At(i))
		fillTestExemplar(el)
		assert.Equal(t, testVal, es.At(i))
	}
	assert.Equal(t, 7, es.Len())
}

func TestExemplarSlice_CopyTo(t *testing.T) {
	dest := NewExemplarSlice()
	// Test CopyTo to empty
	NewExemplarSlice().CopyTo(dest)
	assert.Equal(t, NewExemplarSlice(), dest)

	// Test CopyTo larger slice
	generateTestExemplarSlice().CopyTo(dest)
	assert.Equal(t, generateTestExemplarSlice(), dest)

	// Test CopyTo same size slice
	generateTestExemplarSlice().CopyTo(dest)
	assert.Equal(t, generateTestExemplarSlice(), dest)
}

func TestExemplarSlice_EnsureCapacity(t *testing.T) {
	es := generateTestExemplarSlice()

	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	assert.Equal(t, es.Len(), cap(*es.orig))
	assert.Equal(t, generateTestExemplarSlice(), es)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	es.EnsureCapacity(ensureLargeLen)
	assert.Less(t, generateTestExemplarSlice().Len(), ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	assert.Equal(t, generateTestExemplarSlice(), es)
}

func TestExemplarSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestExemplarSlice()
	dest := NewExemplarSlice()
	src := generateTestExemplarSlice()
	src.MoveAndAppendTo(dest)
	assert.Equal(t, generateTestExemplarSlice(), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.Equal(t, generateTestExemplarSlice(), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestExemplarSlice().MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestExemplarSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewExemplarSlice()
	emptySlice.RemoveIf(func(el Exemplar) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestExemplarSlice()
	pos := 0
	filtered.RemoveIf(func(el Exemplar) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func generateTestExemplarSlice() ExemplarSlice {
	es := NewExemplarSlice()
	fillTestExemplarSlice(es)
	return es
}

func fillTestExemplarSlice(es ExemplarSlice) {
	*es.orig = make([]otlpmetrics.Exemplar, 7)
	for i := 0; i < 7; i++ {
		(*es.orig)[i] = otlpmetrics.Exemplar{}
		fillTestExemplar(newExemplar(&(*es.orig)[i]))
	}
}
