// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package ptrace

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestStatus_MoveTo(t *testing.T) {
	ms := generateTestStatus()
	dest := NewStatus()
	ms.MoveTo(dest)
	assert.Equal(t, NewStatus(), ms)
	assert.Equal(t, generateTestStatus(), dest)
}

func TestStatus_CopyTo(t *testing.T) {
	ms := NewStatus()
	orig := NewStatus()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestStatus()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestStatus_Code(t *testing.T) {
	ms := NewStatus()
	assert.Equal(t, StatusCode(0), ms.Code())
	testValCode := StatusCode(1)
	ms.SetCode(testValCode)
	assert.Equal(t, testValCode, ms.Code())
}

func TestStatus_Message(t *testing.T) {
	ms := NewStatus()
	assert.Equal(t, "", ms.Message())
	ms.SetMessage("cancelled")
	assert.Equal(t, "cancelled", ms.Message())
}

func generateTestStatus() Status {
	tv := NewStatus()
	fillTestStatus(tv)
	return tv
}

func fillTestStatus(tv Status) {
	tv.orig.Code = 1
	tv.orig.Message = "cancelled"
}
