// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "model/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "go run model/internal/cmd/pdatagen/main.go".

package pcommon

import "go.opentelemetry.io/collector/pdata/internal"

// ImmutableByteSlice represents a []byte slice that cannot be mutated.
// The instance of ImmutableByteSlice can be assigned to multiple objects since it's immutable.
type ImmutableByteSlice internal.ImmutableByteSlice

func (ms ImmutableByteSlice) getOrig() []byte {
	return internal.GetOrigImmutableByteSlice(internal.ImmutableByteSlice(ms))
}

// NewImmutableByteSlice creates a new ImmutableByteSlice by copying the provided []byte slice.
func NewImmutableByteSlice(orig []byte) ImmutableByteSlice {
	if len(orig) == 0 {
		return ImmutableByteSlice(internal.NewImmutableByteSlice(nil))
	}
	copyOrig := make([]byte, len(orig))
	copy(copyOrig, orig)
	return ImmutableByteSlice(internal.NewImmutableByteSlice(copyOrig))
}

// AsRaw returns a copy of the []byte slice.
func (ms ImmutableByteSlice) AsRaw() []byte {
	orig := ms.getOrig()
	if len(orig) == 0 {
		return nil
	}
	copyOrig := make([]byte, len(orig))
	copy(copyOrig, orig)
	return copyOrig
}

// Len returns length of the []byte slice value.
func (ms ImmutableByteSlice) Len() int {
	return len(ms.getOrig())
}

// At returns an item from particular index.
func (ms ImmutableByteSlice) At(i int) byte {
	return ms.getOrig()[i]
}

// ImmutableFloat64Slice represents a []float64 slice that cannot be mutated.
// The instance of ImmutableFloat64Slice can be assigned to multiple objects since it's immutable.
type ImmutableFloat64Slice internal.ImmutableFloat64Slice

func (ms ImmutableFloat64Slice) getOrig() []float64 {
	return internal.GetOrigImmutableFloat64Slice(internal.ImmutableFloat64Slice(ms))
}

// NewImmutableFloat64Slice creates a new ImmutableFloat64Slice by copying the provided []float64 slice.
func NewImmutableFloat64Slice(orig []float64) ImmutableFloat64Slice {
	if len(orig) == 0 {
		return ImmutableFloat64Slice(internal.NewImmutableFloat64Slice(nil))
	}
	copyOrig := make([]float64, len(orig))
	copy(copyOrig, orig)
	return ImmutableFloat64Slice(internal.NewImmutableFloat64Slice(copyOrig))
}

// AsRaw returns a copy of the []float64 slice.
func (ms ImmutableFloat64Slice) AsRaw() []float64 {
	orig := ms.getOrig()
	if len(orig) == 0 {
		return nil
	}
	copyOrig := make([]float64, len(orig))
	copy(copyOrig, orig)
	return copyOrig
}

// Len returns length of the []float64 slice value.
func (ms ImmutableFloat64Slice) Len() int {
	return len(ms.getOrig())
}

// At returns an item from particular index.
func (ms ImmutableFloat64Slice) At(i int) float64 {
	return ms.getOrig()[i]
}

// ImmutableUInt64Slice represents a []uint64 slice that cannot be mutated.
// The instance of ImmutableUInt64Slice can be assigned to multiple objects since it's immutable.
type ImmutableUInt64Slice internal.ImmutableUInt64Slice

func (ms ImmutableUInt64Slice) getOrig() []uint64 {
	return internal.GetOrigImmutableUInt64Slice(internal.ImmutableUInt64Slice(ms))
}

// NewImmutableUInt64Slice creates a new ImmutableUInt64Slice by copying the provided []uint64 slice.
func NewImmutableUInt64Slice(orig []uint64) ImmutableUInt64Slice {
	if len(orig) == 0 {
		return ImmutableUInt64Slice(internal.NewImmutableUInt64Slice(nil))
	}
	copyOrig := make([]uint64, len(orig))
	copy(copyOrig, orig)
	return ImmutableUInt64Slice(internal.NewImmutableUInt64Slice(copyOrig))
}

// AsRaw returns a copy of the []uint64 slice.
func (ms ImmutableUInt64Slice) AsRaw() []uint64 {
	orig := ms.getOrig()
	if len(orig) == 0 {
		return nil
	}
	copyOrig := make([]uint64, len(orig))
	copy(copyOrig, orig)
	return copyOrig
}

// Len returns length of the []uint64 slice value.
func (ms ImmutableUInt64Slice) Len() int {
	return len(ms.getOrig())
}

// At returns an item from particular index.
func (ms ImmutableUInt64Slice) At(i int) uint64 {
	return ms.getOrig()[i]
}
