// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "model/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "go run model/internal/cmd/pdatagen/main.go".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
)

func TestInstrumentationScope_MoveTo(t *testing.T) {
	ms := generateTestInstrumentationScope()
	dest := NewInstrumentationScope()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewInstrumentationScope(), ms)
	assert.EqualValues(t, generateTestInstrumentationScope(), dest)
}

func TestInstrumentationScope_CopyTo(t *testing.T) {
	ms := NewInstrumentationScope()
	orig := NewInstrumentationScope()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestInstrumentationScope()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestInstrumentationScope_Name(t *testing.T) {
	ms := NewInstrumentationScope()
	assert.EqualValues(t, "", ms.Name())
	testValName := "test_name"
	ms.SetName(testValName)
	assert.EqualValues(t, testValName, ms.Name())
}

func TestInstrumentationScope_Version(t *testing.T) {
	ms := NewInstrumentationScope()
	assert.EqualValues(t, "", ms.Version())
	testValVersion := "test_version"
	ms.SetVersion(testValVersion)
	assert.EqualValues(t, testValVersion, ms.Version())
}

func TestInstrumentationScope_Attributes(t *testing.T) {
	ms := NewInstrumentationScope()
	assert.EqualValues(t, NewMap(), ms.Attributes())
	fillTestMap(ms.Attributes())
	testValAttributes := generateTestMap()
	assert.EqualValues(t, testValAttributes, ms.Attributes())
}

func TestInstrumentationScope_DroppedAttributesCount(t *testing.T) {
	ms := NewInstrumentationScope()
	assert.EqualValues(t, uint32(0), ms.DroppedAttributesCount())
	testValDroppedAttributesCount := uint32(17)
	ms.SetDroppedAttributesCount(testValDroppedAttributesCount)
	assert.EqualValues(t, testValDroppedAttributesCount, ms.DroppedAttributesCount())
}

func TestSlice(t *testing.T) {
	es := NewSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newSlice(&[]otlpcommon.AnyValue{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newValue(&otlpcommon.AnyValue{})
	testVal := generateTestValue()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestValue(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestSlice_CopyTo(t *testing.T) {
	dest := NewSlice()
	// Test CopyTo to empty
	NewSlice().CopyTo(dest)
	assert.EqualValues(t, NewSlice(), dest)

	// Test CopyTo larger slice
	generateTestSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestSlice(), dest)

	// Test CopyTo same size slice
	generateTestSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestSlice(), dest)
}

func TestSlice_EnsureCapacity(t *testing.T) {
	es := generateTestSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpcommon.AnyValue]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpcommon.AnyValue]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
}

func TestSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestSlice()
	dest := NewSlice()
	src := generateTestSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewSlice()
	emptySlice.RemoveIf(func(el Value) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestSlice()
	pos := 0
	filtered.RemoveIf(func(el Value) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func generateTestInstrumentationScope() InstrumentationScope {
	tv := NewInstrumentationScope()
	fillTestInstrumentationScope(tv)
	return tv
}

func fillTestInstrumentationScope(tv InstrumentationScope) {
	tv.SetName("test_name")
	tv.SetVersion("test_version")
	fillTestMap(tv.Attributes())
	tv.SetDroppedAttributesCount(uint32(17))
}

func generateTestSlice() Slice {
	tv := NewSlice()
	fillTestSlice(tv)
	return tv
}

func fillTestSlice(tv Slice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestValue(tv.AppendEmpty())
	}
}
