// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "model/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "go run model/internal/cmd/pdatagen/main.go".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func TestResourceMetricsSlice(t *testing.T) {
	es := NewResourceMetricsSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newResourceMetricsSlice(&[]*otlpmetrics.ResourceMetrics{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newResourceMetrics(&otlpmetrics.ResourceMetrics{})
	testVal := generateTestResourceMetrics()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestResourceMetrics(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestResourceMetricsSlice_CopyTo(t *testing.T) {
	dest := NewResourceMetricsSlice()
	// Test CopyTo to empty
	NewResourceMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, NewResourceMetricsSlice(), dest)

	// Test CopyTo larger slice
	generateTestResourceMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)

	// Test CopyTo same size slice
	generateTestResourceMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)
}

func TestResourceMetricsSlice_EnsureCapacity(t *testing.T) {
	es := generateTestResourceMetricsSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.ResourceMetrics]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.ResourceMetrics]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.ResourceMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	foundEs = make(map[*otlpmetrics.ResourceMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
}

func TestResourceMetricsSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestResourceMetricsSlice()
	dest := NewResourceMetricsSlice()
	src := generateTestResourceMetricsSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestResourceMetricsSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestResourceMetricsSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewResourceMetricsSlice()
	emptySlice.RemoveIf(func(el ResourceMetrics) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestResourceMetricsSlice()
	pos := 0
	filtered.RemoveIf(func(el ResourceMetrics) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestResourceMetrics_MoveTo(t *testing.T) {
	ms := generateTestResourceMetrics()
	dest := NewResourceMetrics()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewResourceMetrics(), ms)
	assert.EqualValues(t, generateTestResourceMetrics(), dest)
}

func TestResourceMetrics_CopyTo(t *testing.T) {
	ms := NewResourceMetrics()
	orig := NewResourceMetrics()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestResourceMetrics()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestResourceMetrics_Resource(t *testing.T) {
	ms := NewResourceMetrics()
	fillTestResource(ms.Resource())
	assert.EqualValues(t, generateTestResource(), ms.Resource())
}

func TestResourceMetrics_SchemaUrl(t *testing.T) {
	ms := NewResourceMetrics()
	assert.EqualValues(t, "", ms.SchemaUrl())
	testValSchemaUrl := "https://opentelemetry.io/schemas/1.5.0"
	ms.SetSchemaUrl(testValSchemaUrl)
	assert.EqualValues(t, testValSchemaUrl, ms.SchemaUrl())
}

func TestResourceMetrics_ScopeMetrics(t *testing.T) {
	ms := NewResourceMetrics()
	assert.EqualValues(t, NewScopeMetricsSlice(), ms.ScopeMetrics())
	fillTestScopeMetricsSlice(ms.ScopeMetrics())
	testValScopeMetrics := generateTestScopeMetricsSlice()
	assert.EqualValues(t, testValScopeMetrics, ms.ScopeMetrics())
}

func TestScopeMetricsSlice(t *testing.T) {
	es := NewScopeMetricsSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newScopeMetricsSlice(&[]*otlpmetrics.ScopeMetrics{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newScopeMetrics(&otlpmetrics.ScopeMetrics{})
	testVal := generateTestScopeMetrics()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestScopeMetrics(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestScopeMetricsSlice_CopyTo(t *testing.T) {
	dest := NewScopeMetricsSlice()
	// Test CopyTo to empty
	NewScopeMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, NewScopeMetricsSlice(), dest)

	// Test CopyTo larger slice
	generateTestScopeMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestScopeMetricsSlice(), dest)

	// Test CopyTo same size slice
	generateTestScopeMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestScopeMetricsSlice(), dest)
}

func TestScopeMetricsSlice_EnsureCapacity(t *testing.T) {
	es := generateTestScopeMetricsSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.ScopeMetrics]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.ScopeMetrics]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.ScopeMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	foundEs = make(map[*otlpmetrics.ScopeMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
}

func TestScopeMetricsSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestScopeMetricsSlice()
	dest := NewScopeMetricsSlice()
	src := generateTestScopeMetricsSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestScopeMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestScopeMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestScopeMetricsSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestScopeMetricsSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewScopeMetricsSlice()
	emptySlice.RemoveIf(func(el ScopeMetrics) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestScopeMetricsSlice()
	pos := 0
	filtered.RemoveIf(func(el ScopeMetrics) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestScopeMetrics_MoveTo(t *testing.T) {
	ms := generateTestScopeMetrics()
	dest := NewScopeMetrics()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewScopeMetrics(), ms)
	assert.EqualValues(t, generateTestScopeMetrics(), dest)
}

func TestScopeMetrics_CopyTo(t *testing.T) {
	ms := NewScopeMetrics()
	orig := NewScopeMetrics()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestScopeMetrics()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestScopeMetrics_Scope(t *testing.T) {
	ms := NewScopeMetrics()
	fillTestInstrumentationScope(ms.Scope())
	assert.EqualValues(t, generateTestInstrumentationScope(), ms.Scope())
}

func TestScopeMetrics_SchemaUrl(t *testing.T) {
	ms := NewScopeMetrics()
	assert.EqualValues(t, "", ms.SchemaUrl())
	testValSchemaUrl := "https://opentelemetry.io/schemas/1.5.0"
	ms.SetSchemaUrl(testValSchemaUrl)
	assert.EqualValues(t, testValSchemaUrl, ms.SchemaUrl())
}

func TestScopeMetrics_Metrics(t *testing.T) {
	ms := NewScopeMetrics()
	assert.EqualValues(t, NewMetricSlice(), ms.Metrics())
	fillTestMetricSlice(ms.Metrics())
	testValMetrics := generateTestMetricSlice()
	assert.EqualValues(t, testValMetrics, ms.Metrics())
}

func TestMetricSlice(t *testing.T) {
	es := NewMetricSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newMetricSlice(&[]*otlpmetrics.Metric{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newMetric(&otlpmetrics.Metric{})
	testVal := generateTestMetric()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestMetric(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestMetricSlice_CopyTo(t *testing.T) {
	dest := NewMetricSlice()
	// Test CopyTo to empty
	NewMetricSlice().CopyTo(dest)
	assert.EqualValues(t, NewMetricSlice(), dest)

	// Test CopyTo larger slice
	generateTestMetricSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)

	// Test CopyTo same size slice
	generateTestMetricSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)
}

func TestMetricSlice_EnsureCapacity(t *testing.T) {
	es := generateTestMetricSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.Metric]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.Metric]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.Metric]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	foundEs = make(map[*otlpmetrics.Metric]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
}

func TestMetricSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestMetricSlice()
	dest := NewMetricSlice()
	src := generateTestMetricSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestMetricSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestMetricSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewMetricSlice()
	emptySlice.RemoveIf(func(el Metric) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestMetricSlice()
	pos := 0
	filtered.RemoveIf(func(el Metric) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestMetric_MoveTo(t *testing.T) {
	ms := generateTestMetric()
	dest := NewMetric()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewMetric(), ms)
	assert.EqualValues(t, generateTestMetric(), dest)
}

func TestMetric_CopyTo(t *testing.T) {
	ms := NewMetric()
	orig := NewMetric()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestMetric()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestMetric_Name(t *testing.T) {
	ms := NewMetric()
	assert.EqualValues(t, "", ms.Name())
	testValName := "test_name"
	ms.SetName(testValName)
	assert.EqualValues(t, testValName, ms.Name())
}

func TestMetric_Description(t *testing.T) {
	ms := NewMetric()
	assert.EqualValues(t, "", ms.Description())
	testValDescription := "test_description"
	ms.SetDescription(testValDescription)
	assert.EqualValues(t, testValDescription, ms.Description())
}

func TestMetric_Unit(t *testing.T) {
	ms := NewMetric()
	assert.EqualValues(t, "", ms.Unit())
	testValUnit := "1"
	ms.SetUnit(testValUnit)
	assert.EqualValues(t, testValUnit, ms.Unit())
}

func TestMetricDataType(t *testing.T) {
	tv := NewMetric()
	assert.Equal(t, MetricDataTypeNone, tv.DataType())
	assert.Equal(t, "", MetricDataType(1000).String())
	assert.Equal(t, Gauge{}, tv.Gauge())
	assert.Equal(t, Sum{}, tv.Sum())
	assert.Equal(t, Histogram{}, tv.Histogram())
	assert.Equal(t, ExponentialHistogram{}, tv.ExponentialHistogram())
	assert.Equal(t, Summary{}, tv.Summary())
	tv.SetDataType(MetricDataTypeGauge)
	fillTestGauge(tv.Gauge())
	assert.Equal(t, MetricDataTypeGauge, tv.DataType())
	tv.SetDataType(MetricDataTypeSum)
	fillTestSum(tv.Sum())
	assert.Equal(t, MetricDataTypeSum, tv.DataType())
	tv.SetDataType(MetricDataTypeHistogram)
	fillTestHistogram(tv.Histogram())
	assert.Equal(t, MetricDataTypeHistogram, tv.DataType())
	tv.SetDataType(MetricDataTypeExponentialHistogram)
	fillTestExponentialHistogram(tv.ExponentialHistogram())
	assert.Equal(t, MetricDataTypeExponentialHistogram, tv.DataType())
	tv.SetDataType(MetricDataTypeSummary)
	fillTestSummary(tv.Summary())
	assert.Equal(t, MetricDataTypeSummary, tv.DataType())
}

func TestMetric_Gauge(t *testing.T) {
	ms := NewMetric()
	ms.SetDataType(MetricDataTypeGauge)
	fillTestGauge(ms.Gauge())
	assert.EqualValues(t, generateTestGauge(), ms.Gauge())
}

func TestMetric_CopyTo_Gauge(t *testing.T) {
	ms := NewMetric()
	ms.SetDataType(MetricDataTypeGauge)
	fillTestGauge(ms.Gauge())
	dest := NewMetric()
	ms.CopyTo(dest)
	assert.EqualValues(t, ms, dest)
}

func TestMetric_Sum(t *testing.T) {
	ms := NewMetric()
	ms.SetDataType(MetricDataTypeSum)
	fillTestSum(ms.Sum())
	assert.EqualValues(t, generateTestSum(), ms.Sum())
}

func TestMetric_CopyTo_Sum(t *testing.T) {
	ms := NewMetric()
	ms.SetDataType(MetricDataTypeSum)
	fillTestSum(ms.Sum())
	dest := NewMetric()
	ms.CopyTo(dest)
	assert.EqualValues(t, ms, dest)
}

func TestMetric_Histogram(t *testing.T) {
	ms := NewMetric()
	ms.SetDataType(MetricDataTypeHistogram)
	fillTestHistogram(ms.Histogram())
	assert.EqualValues(t, generateTestHistogram(), ms.Histogram())
}

func TestMetric_CopyTo_Histogram(t *testing.T) {
	ms := NewMetric()
	ms.SetDataType(MetricDataTypeHistogram)
	fillTestHistogram(ms.Histogram())
	dest := NewMetric()
	ms.CopyTo(dest)
	assert.EqualValues(t, ms, dest)
}

func TestMetric_ExponentialHistogram(t *testing.T) {
	ms := NewMetric()
	ms.SetDataType(MetricDataTypeExponentialHistogram)
	fillTestExponentialHistogram(ms.ExponentialHistogram())
	assert.EqualValues(t, generateTestExponentialHistogram(), ms.ExponentialHistogram())
}

func TestMetric_CopyTo_ExponentialHistogram(t *testing.T) {
	ms := NewMetric()
	ms.SetDataType(MetricDataTypeExponentialHistogram)
	fillTestExponentialHistogram(ms.ExponentialHistogram())
	dest := NewMetric()
	ms.CopyTo(dest)
	assert.EqualValues(t, ms, dest)
}

func TestMetric_Summary(t *testing.T) {
	ms := NewMetric()
	ms.SetDataType(MetricDataTypeSummary)
	fillTestSummary(ms.Summary())
	assert.EqualValues(t, generateTestSummary(), ms.Summary())
}

func TestMetric_CopyTo_Summary(t *testing.T) {
	ms := NewMetric()
	ms.SetDataType(MetricDataTypeSummary)
	fillTestSummary(ms.Summary())
	dest := NewMetric()
	ms.CopyTo(dest)
	assert.EqualValues(t, ms, dest)
}

func TestGauge_MoveTo(t *testing.T) {
	ms := generateTestGauge()
	dest := NewGauge()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewGauge(), ms)
	assert.EqualValues(t, generateTestGauge(), dest)
}

func TestGauge_CopyTo(t *testing.T) {
	ms := NewGauge()
	orig := NewGauge()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestGauge()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestGauge_DataPoints(t *testing.T) {
	ms := NewGauge()
	assert.EqualValues(t, NewNumberDataPointSlice(), ms.DataPoints())
	fillTestNumberDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestNumberDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestSum_MoveTo(t *testing.T) {
	ms := generateTestSum()
	dest := NewSum()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewSum(), ms)
	assert.EqualValues(t, generateTestSum(), dest)
}

func TestSum_CopyTo(t *testing.T) {
	ms := NewSum()
	orig := NewSum()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestSum()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestSum_AggregationTemporality(t *testing.T) {
	ms := NewSum()
	assert.EqualValues(t, MetricAggregationTemporalityUnspecified, ms.AggregationTemporality())
	testValAggregationTemporality := MetricAggregationTemporalityCumulative
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.EqualValues(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestSum_IsMonotonic(t *testing.T) {
	ms := NewSum()
	assert.EqualValues(t, false, ms.IsMonotonic())
	testValIsMonotonic := true
	ms.SetIsMonotonic(testValIsMonotonic)
	assert.EqualValues(t, testValIsMonotonic, ms.IsMonotonic())
}

func TestSum_DataPoints(t *testing.T) {
	ms := NewSum()
	assert.EqualValues(t, NewNumberDataPointSlice(), ms.DataPoints())
	fillTestNumberDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestNumberDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestHistogram_MoveTo(t *testing.T) {
	ms := generateTestHistogram()
	dest := NewHistogram()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewHistogram(), ms)
	assert.EqualValues(t, generateTestHistogram(), dest)
}

func TestHistogram_CopyTo(t *testing.T) {
	ms := NewHistogram()
	orig := NewHistogram()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestHistogram()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestHistogram_AggregationTemporality(t *testing.T) {
	ms := NewHistogram()
	assert.EqualValues(t, MetricAggregationTemporalityUnspecified, ms.AggregationTemporality())
	testValAggregationTemporality := MetricAggregationTemporalityCumulative
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.EqualValues(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestHistogram_DataPoints(t *testing.T) {
	ms := NewHistogram()
	assert.EqualValues(t, NewHistogramDataPointSlice(), ms.DataPoints())
	fillTestHistogramDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestHistogramDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestExponentialHistogram_MoveTo(t *testing.T) {
	ms := generateTestExponentialHistogram()
	dest := NewExponentialHistogram()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewExponentialHistogram(), ms)
	assert.EqualValues(t, generateTestExponentialHistogram(), dest)
}

func TestExponentialHistogram_CopyTo(t *testing.T) {
	ms := NewExponentialHistogram()
	orig := NewExponentialHistogram()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestExponentialHistogram()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestExponentialHistogram_AggregationTemporality(t *testing.T) {
	ms := NewExponentialHistogram()
	assert.EqualValues(t, MetricAggregationTemporalityUnspecified, ms.AggregationTemporality())
	testValAggregationTemporality := MetricAggregationTemporalityCumulative
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.EqualValues(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestExponentialHistogram_DataPoints(t *testing.T) {
	ms := NewExponentialHistogram()
	assert.EqualValues(t, NewExponentialHistogramDataPointSlice(), ms.DataPoints())
	fillTestExponentialHistogramDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestExponentialHistogramDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestSummary_MoveTo(t *testing.T) {
	ms := generateTestSummary()
	dest := NewSummary()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewSummary(), ms)
	assert.EqualValues(t, generateTestSummary(), dest)
}

func TestSummary_CopyTo(t *testing.T) {
	ms := NewSummary()
	orig := NewSummary()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestSummary()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestSummary_DataPoints(t *testing.T) {
	ms := NewSummary()
	assert.EqualValues(t, NewSummaryDataPointSlice(), ms.DataPoints())
	fillTestSummaryDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestSummaryDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestNumberDataPointSlice(t *testing.T) {
	es := NewNumberDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newNumberDataPointSlice(&[]*otlpmetrics.NumberDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newNumberDataPoint(&otlpmetrics.NumberDataPoint{})
	testVal := generateTestNumberDataPoint()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestNumberDataPoint(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestNumberDataPointSlice_CopyTo(t *testing.T) {
	dest := NewNumberDataPointSlice()
	// Test CopyTo to empty
	NewNumberDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewNumberDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestNumberDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestNumberDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestNumberDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestNumberDataPointSlice(), dest)
}

func TestNumberDataPointSlice_EnsureCapacity(t *testing.T) {
	es := generateTestNumberDataPointSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.NumberDataPoint]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.NumberDataPoint]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.NumberDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	foundEs = make(map[*otlpmetrics.NumberDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
}

func TestNumberDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestNumberDataPointSlice()
	dest := NewNumberDataPointSlice()
	src := generateTestNumberDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestNumberDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestNumberDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestNumberDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestNumberDataPointSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewNumberDataPointSlice()
	emptySlice.RemoveIf(func(el NumberDataPoint) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestNumberDataPointSlice()
	pos := 0
	filtered.RemoveIf(func(el NumberDataPoint) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestNumberDataPoint_MoveTo(t *testing.T) {
	ms := generateTestNumberDataPoint()
	dest := NewNumberDataPoint()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewNumberDataPoint(), ms)
	assert.EqualValues(t, generateTestNumberDataPoint(), dest)
}

func TestNumberDataPoint_CopyTo(t *testing.T) {
	ms := NewNumberDataPoint()
	orig := NewNumberDataPoint()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestNumberDataPoint()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestNumberDataPoint_Attributes(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.EqualValues(t, NewMap(), ms.Attributes())
	fillTestMap(ms.Attributes())
	testValAttributes := generateTestMap()
	assert.EqualValues(t, testValAttributes, ms.Attributes())
}

func TestNumberDataPoint_StartTimestamp(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.EqualValues(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestNumberDataPoint_Timestamp(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestNumberDataPointValueType(t *testing.T) {
	tv := NewNumberDataPoint()
	assert.Equal(t, NumberDataPointValueTypeNone, tv.ValueType())
	assert.Equal(t, "", NumberDataPointValueType(1000).String())
	tv.SetDoubleVal(float64(17.13))
	assert.Equal(t, NumberDataPointValueTypeDouble, tv.ValueType())
	tv.SetIntVal(int64(17))
	assert.Equal(t, NumberDataPointValueTypeInt, tv.ValueType())
}

func TestNumberDataPoint_DoubleVal(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.EqualValues(t, float64(0.0), ms.DoubleVal())
	testValDoubleVal := float64(17.13)
	ms.SetDoubleVal(testValDoubleVal)
	assert.EqualValues(t, testValDoubleVal, ms.DoubleVal())
}

func TestNumberDataPoint_IntVal(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.EqualValues(t, int64(0), ms.IntVal())
	testValIntVal := int64(17)
	ms.SetIntVal(testValIntVal)
	assert.EqualValues(t, testValIntVal, ms.IntVal())
}

func TestNumberDataPoint_Exemplars(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.EqualValues(t, NewExemplarSlice(), ms.Exemplars())
	fillTestExemplarSlice(ms.Exemplars())
	testValExemplars := generateTestExemplarSlice()
	assert.EqualValues(t, testValExemplars, ms.Exemplars())
}

func TestNumberDataPoint_FlagsStruct(t *testing.T) {
	ms := NewNumberDataPoint()
	fillTestMetricDataPointFlagsStruct(ms.FlagsStruct())
	assert.EqualValues(t, generateTestMetricDataPointFlagsStruct(), ms.FlagsStruct())
}

func TestHistogramDataPointSlice(t *testing.T) {
	es := NewHistogramDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newHistogramDataPointSlice(&[]*otlpmetrics.HistogramDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newHistogramDataPoint(&otlpmetrics.HistogramDataPoint{})
	testVal := generateTestHistogramDataPoint()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestHistogramDataPoint(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestHistogramDataPointSlice_CopyTo(t *testing.T) {
	dest := NewHistogramDataPointSlice()
	// Test CopyTo to empty
	NewHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewHistogramDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestHistogramDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestHistogramDataPointSlice(), dest)
}

func TestHistogramDataPointSlice_EnsureCapacity(t *testing.T) {
	es := generateTestHistogramDataPointSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.HistogramDataPoint]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.HistogramDataPoint]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.HistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	foundEs = make(map[*otlpmetrics.HistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
}

func TestHistogramDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestHistogramDataPointSlice()
	dest := NewHistogramDataPointSlice()
	src := generateTestHistogramDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestHistogramDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestHistogramDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestHistogramDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestHistogramDataPointSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewHistogramDataPointSlice()
	emptySlice.RemoveIf(func(el HistogramDataPoint) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestHistogramDataPointSlice()
	pos := 0
	filtered.RemoveIf(func(el HistogramDataPoint) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestHistogramDataPoint_MoveTo(t *testing.T) {
	ms := generateTestHistogramDataPoint()
	dest := NewHistogramDataPoint()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewHistogramDataPoint(), ms)
	assert.EqualValues(t, generateTestHistogramDataPoint(), dest)
}

func TestHistogramDataPoint_CopyTo(t *testing.T) {
	ms := NewHistogramDataPoint()
	orig := NewHistogramDataPoint()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestHistogramDataPoint()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestHistogramDataPoint_Attributes(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, NewMap(), ms.Attributes())
	fillTestMap(ms.Attributes())
	testValAttributes := generateTestMap()
	assert.EqualValues(t, testValAttributes, ms.Attributes())
}

func TestHistogramDataPoint_StartTimestamp(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.EqualValues(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestHistogramDataPoint_Timestamp(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestHistogramDataPoint_Count(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, uint64(0), ms.Count())
	testValCount := uint64(17)
	ms.SetCount(testValCount)
	assert.EqualValues(t, testValCount, ms.Count())
}

func TestHistogramDataPoint_Sum(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, float64(0.0), ms.Sum())
	testValSum := float64(17.13)
	ms.SetSum(testValSum)
	assert.EqualValues(t, testValSum, ms.Sum())
}

func TestHistogramDataPoint_BucketCounts(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, ImmutableUInt64Slice{}, ms.BucketCounts())
	testValBucketCounts := NewImmutableUInt64Slice([]uint64{1, 2, 3})
	ms.SetBucketCounts(testValBucketCounts)
	assert.EqualValues(t, testValBucketCounts, ms.BucketCounts())
}

func TestHistogramDataPoint_ExplicitBounds(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, ImmutableFloat64Slice{}, ms.ExplicitBounds())
	testValExplicitBounds := NewImmutableFloat64Slice([]float64{1, 2, 3})
	ms.SetExplicitBounds(testValExplicitBounds)
	assert.EqualValues(t, testValExplicitBounds, ms.ExplicitBounds())
}

func TestHistogramDataPoint_Exemplars(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, NewExemplarSlice(), ms.Exemplars())
	fillTestExemplarSlice(ms.Exemplars())
	testValExemplars := generateTestExemplarSlice()
	assert.EqualValues(t, testValExemplars, ms.Exemplars())
}

func TestHistogramDataPoint_FlagsStruct(t *testing.T) {
	ms := NewHistogramDataPoint()
	fillTestMetricDataPointFlagsStruct(ms.FlagsStruct())
	assert.EqualValues(t, generateTestMetricDataPointFlagsStruct(), ms.FlagsStruct())
}

func TestHistogramDataPoint_Min(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, float64(0.0), ms.Min())
	testValMin := float64(9.23)
	ms.SetMin(testValMin)
	assert.EqualValues(t, testValMin, ms.Min())
}

func TestHistogramDataPoint_Max(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, float64(0.0), ms.Max())
	testValMax := float64(182.55)
	ms.SetMax(testValMax)
	assert.EqualValues(t, testValMax, ms.Max())
}

func TestExponentialHistogramDataPointSlice(t *testing.T) {
	es := NewExponentialHistogramDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newExponentialHistogramDataPointSlice(&[]*otlpmetrics.ExponentialHistogramDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newExponentialHistogramDataPoint(&otlpmetrics.ExponentialHistogramDataPoint{})
	testVal := generateTestExponentialHistogramDataPoint()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestExponentialHistogramDataPoint(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestExponentialHistogramDataPointSlice_CopyTo(t *testing.T) {
	dest := NewExponentialHistogramDataPointSlice()
	// Test CopyTo to empty
	NewExponentialHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewExponentialHistogramDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestExponentialHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestExponentialHistogramDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestExponentialHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestExponentialHistogramDataPointSlice(), dest)
}

func TestExponentialHistogramDataPointSlice_EnsureCapacity(t *testing.T) {
	es := generateTestExponentialHistogramDataPointSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.ExponentialHistogramDataPoint]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.ExponentialHistogramDataPoint]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.ExponentialHistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	foundEs = make(map[*otlpmetrics.ExponentialHistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
}

func TestExponentialHistogramDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestExponentialHistogramDataPointSlice()
	dest := NewExponentialHistogramDataPointSlice()
	src := generateTestExponentialHistogramDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestExponentialHistogramDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestExponentialHistogramDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestExponentialHistogramDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestExponentialHistogramDataPointSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewExponentialHistogramDataPointSlice()
	emptySlice.RemoveIf(func(el ExponentialHistogramDataPoint) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestExponentialHistogramDataPointSlice()
	pos := 0
	filtered.RemoveIf(func(el ExponentialHistogramDataPoint) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestExponentialHistogramDataPoint_MoveTo(t *testing.T) {
	ms := generateTestExponentialHistogramDataPoint()
	dest := NewExponentialHistogramDataPoint()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewExponentialHistogramDataPoint(), ms)
	assert.EqualValues(t, generateTestExponentialHistogramDataPoint(), dest)
}

func TestExponentialHistogramDataPoint_CopyTo(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	orig := NewExponentialHistogramDataPoint()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestExponentialHistogramDataPoint()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestExponentialHistogramDataPoint_Attributes(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.EqualValues(t, NewMap(), ms.Attributes())
	fillTestMap(ms.Attributes())
	testValAttributes := generateTestMap()
	assert.EqualValues(t, testValAttributes, ms.Attributes())
}

func TestExponentialHistogramDataPoint_StartTimestamp(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.EqualValues(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestExponentialHistogramDataPoint_Timestamp(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestExponentialHistogramDataPoint_Count(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.EqualValues(t, uint64(0), ms.Count())
	testValCount := uint64(17)
	ms.SetCount(testValCount)
	assert.EqualValues(t, testValCount, ms.Count())
}

func TestExponentialHistogramDataPoint_Sum(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.EqualValues(t, float64(0.0), ms.Sum())
	testValSum := float64(17.13)
	ms.SetSum(testValSum)
	assert.EqualValues(t, testValSum, ms.Sum())
}

func TestExponentialHistogramDataPoint_Scale(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.EqualValues(t, int32(0), ms.Scale())
	testValScale := int32(4)
	ms.SetScale(testValScale)
	assert.EqualValues(t, testValScale, ms.Scale())
}

func TestExponentialHistogramDataPoint_ZeroCount(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.EqualValues(t, uint64(0), ms.ZeroCount())
	testValZeroCount := uint64(201)
	ms.SetZeroCount(testValZeroCount)
	assert.EqualValues(t, testValZeroCount, ms.ZeroCount())
}

func TestExponentialHistogramDataPoint_Positive(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	fillTestBuckets(ms.Positive())
	assert.EqualValues(t, generateTestBuckets(), ms.Positive())
}

func TestExponentialHistogramDataPoint_Negative(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	fillTestBuckets(ms.Negative())
	assert.EqualValues(t, generateTestBuckets(), ms.Negative())
}

func TestExponentialHistogramDataPoint_Exemplars(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.EqualValues(t, NewExemplarSlice(), ms.Exemplars())
	fillTestExemplarSlice(ms.Exemplars())
	testValExemplars := generateTestExemplarSlice()
	assert.EqualValues(t, testValExemplars, ms.Exemplars())
}

func TestExponentialHistogramDataPoint_FlagsStruct(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	fillTestMetricDataPointFlagsStruct(ms.FlagsStruct())
	assert.EqualValues(t, generateTestMetricDataPointFlagsStruct(), ms.FlagsStruct())
}

func TestExponentialHistogramDataPoint_Min(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.EqualValues(t, float64(0.0), ms.Min())
	testValMin := float64(9.23)
	ms.SetMin(testValMin)
	assert.EqualValues(t, testValMin, ms.Min())
}

func TestExponentialHistogramDataPoint_Max(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.EqualValues(t, float64(0.0), ms.Max())
	testValMax := float64(182.55)
	ms.SetMax(testValMax)
	assert.EqualValues(t, testValMax, ms.Max())
}

func TestBuckets_MoveTo(t *testing.T) {
	ms := generateTestBuckets()
	dest := NewBuckets()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewBuckets(), ms)
	assert.EqualValues(t, generateTestBuckets(), dest)
}

func TestBuckets_CopyTo(t *testing.T) {
	ms := NewBuckets()
	orig := NewBuckets()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestBuckets()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestBuckets_Offset(t *testing.T) {
	ms := NewBuckets()
	assert.EqualValues(t, int32(0), ms.Offset())
	testValOffset := int32(909)
	ms.SetOffset(testValOffset)
	assert.EqualValues(t, testValOffset, ms.Offset())
}

func TestBuckets_BucketCounts(t *testing.T) {
	ms := NewBuckets()
	assert.EqualValues(t, ImmutableUInt64Slice{}, ms.BucketCounts())
	testValBucketCounts := NewImmutableUInt64Slice([]uint64{1, 2, 3})
	ms.SetBucketCounts(testValBucketCounts)
	assert.EqualValues(t, testValBucketCounts, ms.BucketCounts())
}

func TestSummaryDataPointSlice(t *testing.T) {
	es := NewSummaryDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newSummaryDataPointSlice(&[]*otlpmetrics.SummaryDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newSummaryDataPoint(&otlpmetrics.SummaryDataPoint{})
	testVal := generateTestSummaryDataPoint()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestSummaryDataPoint(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestSummaryDataPointSlice_CopyTo(t *testing.T) {
	dest := NewSummaryDataPointSlice()
	// Test CopyTo to empty
	NewSummaryDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewSummaryDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestSummaryDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestSummaryDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestSummaryDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestSummaryDataPointSlice(), dest)
}

func TestSummaryDataPointSlice_EnsureCapacity(t *testing.T) {
	es := generateTestSummaryDataPointSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.SummaryDataPoint]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.SummaryDataPoint]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.SummaryDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	foundEs = make(map[*otlpmetrics.SummaryDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
}

func TestSummaryDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestSummaryDataPointSlice()
	dest := NewSummaryDataPointSlice()
	src := generateTestSummaryDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestSummaryDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestSummaryDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestSummaryDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestSummaryDataPointSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewSummaryDataPointSlice()
	emptySlice.RemoveIf(func(el SummaryDataPoint) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestSummaryDataPointSlice()
	pos := 0
	filtered.RemoveIf(func(el SummaryDataPoint) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestSummaryDataPoint_MoveTo(t *testing.T) {
	ms := generateTestSummaryDataPoint()
	dest := NewSummaryDataPoint()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewSummaryDataPoint(), ms)
	assert.EqualValues(t, generateTestSummaryDataPoint(), dest)
}

func TestSummaryDataPoint_CopyTo(t *testing.T) {
	ms := NewSummaryDataPoint()
	orig := NewSummaryDataPoint()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestSummaryDataPoint()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestSummaryDataPoint_Attributes(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, NewMap(), ms.Attributes())
	fillTestMap(ms.Attributes())
	testValAttributes := generateTestMap()
	assert.EqualValues(t, testValAttributes, ms.Attributes())
}

func TestSummaryDataPoint_StartTimestamp(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.EqualValues(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestSummaryDataPoint_Timestamp(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestSummaryDataPoint_Count(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, uint64(0), ms.Count())
	testValCount := uint64(17)
	ms.SetCount(testValCount)
	assert.EqualValues(t, testValCount, ms.Count())
}

func TestSummaryDataPoint_Sum(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, float64(0.0), ms.Sum())
	testValSum := float64(17.13)
	ms.SetSum(testValSum)
	assert.EqualValues(t, testValSum, ms.Sum())
}

func TestSummaryDataPoint_QuantileValues(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, NewValueAtQuantileSlice(), ms.QuantileValues())
	fillTestValueAtQuantileSlice(ms.QuantileValues())
	testValQuantileValues := generateTestValueAtQuantileSlice()
	assert.EqualValues(t, testValQuantileValues, ms.QuantileValues())
}

func TestSummaryDataPoint_FlagsStruct(t *testing.T) {
	ms := NewSummaryDataPoint()
	fillTestMetricDataPointFlagsStruct(ms.FlagsStruct())
	assert.EqualValues(t, generateTestMetricDataPointFlagsStruct(), ms.FlagsStruct())
}

func TestValueAtQuantileSlice(t *testing.T) {
	es := NewValueAtQuantileSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newValueAtQuantileSlice(&[]*otlpmetrics.SummaryDataPoint_ValueAtQuantile{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newValueAtQuantile(&otlpmetrics.SummaryDataPoint_ValueAtQuantile{})
	testVal := generateTestValueAtQuantile()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestValueAtQuantile(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestValueAtQuantileSlice_CopyTo(t *testing.T) {
	dest := NewValueAtQuantileSlice()
	// Test CopyTo to empty
	NewValueAtQuantileSlice().CopyTo(dest)
	assert.EqualValues(t, NewValueAtQuantileSlice(), dest)

	// Test CopyTo larger slice
	generateTestValueAtQuantileSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)

	// Test CopyTo same size slice
	generateTestValueAtQuantileSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)
}

func TestValueAtQuantileSlice_EnsureCapacity(t *testing.T) {
	es := generateTestValueAtQuantileSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.SummaryDataPoint_ValueAtQuantile]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.SummaryDataPoint_ValueAtQuantile]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.SummaryDataPoint_ValueAtQuantile]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	foundEs = make(map[*otlpmetrics.SummaryDataPoint_ValueAtQuantile]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
}

func TestValueAtQuantileSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestValueAtQuantileSlice()
	dest := NewValueAtQuantileSlice()
	src := generateTestValueAtQuantileSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestValueAtQuantileSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestValueAtQuantileSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewValueAtQuantileSlice()
	emptySlice.RemoveIf(func(el ValueAtQuantile) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestValueAtQuantileSlice()
	pos := 0
	filtered.RemoveIf(func(el ValueAtQuantile) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestValueAtQuantile_MoveTo(t *testing.T) {
	ms := generateTestValueAtQuantile()
	dest := NewValueAtQuantile()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewValueAtQuantile(), ms)
	assert.EqualValues(t, generateTestValueAtQuantile(), dest)
}

func TestValueAtQuantile_CopyTo(t *testing.T) {
	ms := NewValueAtQuantile()
	orig := NewValueAtQuantile()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestValueAtQuantile()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestValueAtQuantile_Quantile(t *testing.T) {
	ms := NewValueAtQuantile()
	assert.EqualValues(t, float64(0.0), ms.Quantile())
	testValQuantile := float64(17.13)
	ms.SetQuantile(testValQuantile)
	assert.EqualValues(t, testValQuantile, ms.Quantile())
}

func TestValueAtQuantile_Value(t *testing.T) {
	ms := NewValueAtQuantile()
	assert.EqualValues(t, float64(0.0), ms.Value())
	testValValue := float64(17.13)
	ms.SetValue(testValValue)
	assert.EqualValues(t, testValValue, ms.Value())
}

func TestExemplarSlice(t *testing.T) {
	es := NewExemplarSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newExemplarSlice(&[]otlpmetrics.Exemplar{})
	assert.EqualValues(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newExemplar(&otlpmetrics.Exemplar{})
	testVal := generateTestExemplar()
	assert.EqualValues(t, 7, cap(*es.orig))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.EqualValues(t, emptyVal, el)
		fillTestExemplar(el)
		assert.EqualValues(t, testVal, el)
	}
}

func TestExemplarSlice_CopyTo(t *testing.T) {
	dest := NewExemplarSlice()
	// Test CopyTo to empty
	NewExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, NewExemplarSlice(), dest)

	// Test CopyTo larger slice
	generateTestExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestExemplarSlice(), dest)

	// Test CopyTo same size slice
	generateTestExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestExemplarSlice(), dest)
}

func TestExemplarSlice_EnsureCapacity(t *testing.T) {
	es := generateTestExemplarSlice()
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.Exemplar]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.Exemplar]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
}

func TestExemplarSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestExemplarSlice()
	dest := NewExemplarSlice()
	src := generateTestExemplarSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestExemplarSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestExemplarSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestExemplarSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestExemplarSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewExemplarSlice()
	emptySlice.RemoveIf(func(el Exemplar) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestExemplarSlice()
	pos := 0
	filtered.RemoveIf(func(el Exemplar) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestExemplar_MoveTo(t *testing.T) {
	ms := generateTestExemplar()
	dest := NewExemplar()
	ms.MoveTo(dest)
	assert.EqualValues(t, NewExemplar(), ms)
	assert.EqualValues(t, generateTestExemplar(), dest)
}

func TestExemplar_CopyTo(t *testing.T) {
	ms := NewExemplar()
	orig := NewExemplar()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
	orig = generateTestExemplar()
	orig.CopyTo(ms)
	assert.EqualValues(t, orig, ms)
}

func TestExemplar_Timestamp(t *testing.T) {
	ms := NewExemplar()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestExemplarValueType(t *testing.T) {
	tv := NewExemplar()
	assert.Equal(t, ExemplarValueTypeNone, tv.ValueType())
	assert.Equal(t, "", ExemplarValueType(1000).String())
	tv.SetDoubleVal(float64(17.13))
	assert.Equal(t, ExemplarValueTypeDouble, tv.ValueType())
	tv.SetIntVal(int64(17))
	assert.Equal(t, ExemplarValueTypeInt, tv.ValueType())
}

func TestExemplar_DoubleVal(t *testing.T) {
	ms := NewExemplar()
	assert.EqualValues(t, float64(0.0), ms.DoubleVal())
	testValDoubleVal := float64(17.13)
	ms.SetDoubleVal(testValDoubleVal)
	assert.EqualValues(t, testValDoubleVal, ms.DoubleVal())
}

func TestExemplar_IntVal(t *testing.T) {
	ms := NewExemplar()
	assert.EqualValues(t, int64(0), ms.IntVal())
	testValIntVal := int64(17)
	ms.SetIntVal(testValIntVal)
	assert.EqualValues(t, testValIntVal, ms.IntVal())
}

func TestExemplar_FilteredAttributes(t *testing.T) {
	ms := NewExemplar()
	assert.EqualValues(t, NewMap(), ms.FilteredAttributes())
	fillTestMap(ms.FilteredAttributes())
	testValFilteredAttributes := generateTestMap()
	assert.EqualValues(t, testValFilteredAttributes, ms.FilteredAttributes())
}

func TestExemplar_TraceID(t *testing.T) {
	ms := NewExemplar()
	assert.EqualValues(t, NewTraceID([16]byte{}), ms.TraceID())
	testValTraceID := NewTraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1})
	ms.SetTraceID(testValTraceID)
	assert.EqualValues(t, testValTraceID, ms.TraceID())
}

func TestExemplar_SpanID(t *testing.T) {
	ms := NewExemplar()
	assert.EqualValues(t, NewSpanID([8]byte{}), ms.SpanID())
	testValSpanID := NewSpanID([8]byte{1, 2, 3, 4, 5, 6, 7, 8})
	ms.SetSpanID(testValSpanID)
	assert.EqualValues(t, testValSpanID, ms.SpanID())
}

func generateTestResourceMetricsSlice() ResourceMetricsSlice {
	tv := NewResourceMetricsSlice()
	fillTestResourceMetricsSlice(tv)
	return tv
}

func fillTestResourceMetricsSlice(tv ResourceMetricsSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestResourceMetrics(tv.AppendEmpty())
	}
}

func generateTestResourceMetrics() ResourceMetrics {
	tv := NewResourceMetrics()
	fillTestResourceMetrics(tv)
	return tv
}

func fillTestResourceMetrics(tv ResourceMetrics) {
	fillTestResource(tv.Resource())
	tv.SetSchemaUrl("https://opentelemetry.io/schemas/1.5.0")
	fillTestScopeMetricsSlice(tv.ScopeMetrics())
}

func generateTestScopeMetricsSlice() ScopeMetricsSlice {
	tv := NewScopeMetricsSlice()
	fillTestScopeMetricsSlice(tv)
	return tv
}

func fillTestScopeMetricsSlice(tv ScopeMetricsSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestScopeMetrics(tv.AppendEmpty())
	}
}

func generateTestScopeMetrics() ScopeMetrics {
	tv := NewScopeMetrics()
	fillTestScopeMetrics(tv)
	return tv
}

func fillTestScopeMetrics(tv ScopeMetrics) {
	fillTestInstrumentationScope(tv.Scope())
	tv.SetSchemaUrl("https://opentelemetry.io/schemas/1.5.0")
	fillTestMetricSlice(tv.Metrics())
}

func generateTestMetricSlice() MetricSlice {
	tv := NewMetricSlice()
	fillTestMetricSlice(tv)
	return tv
}

func fillTestMetricSlice(tv MetricSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestMetric(tv.AppendEmpty())
	}
}

func generateTestMetric() Metric {
	tv := NewMetric()
	fillTestMetric(tv)
	return tv
}

func fillTestMetric(tv Metric) {
	tv.SetName("test_name")
	tv.SetDescription("test_description")
	tv.SetUnit("1")
	tv.SetDataType(MetricDataTypeSum)
	fillTestSum(tv.Sum())
}

func generateTestGauge() Gauge {
	tv := NewGauge()
	fillTestGauge(tv)
	return tv
}

func fillTestGauge(tv Gauge) {
	fillTestNumberDataPointSlice(tv.DataPoints())
}

func generateTestSum() Sum {
	tv := NewSum()
	fillTestSum(tv)
	return tv
}

func fillTestSum(tv Sum) {
	tv.SetAggregationTemporality(MetricAggregationTemporalityCumulative)
	tv.SetIsMonotonic(true)
	fillTestNumberDataPointSlice(tv.DataPoints())
}

func generateTestHistogram() Histogram {
	tv := NewHistogram()
	fillTestHistogram(tv)
	return tv
}

func fillTestHistogram(tv Histogram) {
	tv.SetAggregationTemporality(MetricAggregationTemporalityCumulative)
	fillTestHistogramDataPointSlice(tv.DataPoints())
}

func generateTestExponentialHistogram() ExponentialHistogram {
	tv := NewExponentialHistogram()
	fillTestExponentialHistogram(tv)
	return tv
}

func fillTestExponentialHistogram(tv ExponentialHistogram) {
	tv.SetAggregationTemporality(MetricAggregationTemporalityCumulative)
	fillTestExponentialHistogramDataPointSlice(tv.DataPoints())
}

func generateTestSummary() Summary {
	tv := NewSummary()
	fillTestSummary(tv)
	return tv
}

func fillTestSummary(tv Summary) {
	fillTestSummaryDataPointSlice(tv.DataPoints())
}

func generateTestNumberDataPointSlice() NumberDataPointSlice {
	tv := NewNumberDataPointSlice()
	fillTestNumberDataPointSlice(tv)
	return tv
}

func fillTestNumberDataPointSlice(tv NumberDataPointSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestNumberDataPoint(tv.AppendEmpty())
	}
}

func generateTestNumberDataPoint() NumberDataPoint {
	tv := NewNumberDataPoint()
	fillTestNumberDataPoint(tv)
	return tv
}

func fillTestNumberDataPoint(tv NumberDataPoint) {
	fillTestMap(tv.Attributes())
	tv.SetStartTimestamp(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetDoubleVal(float64(17.13))
	fillTestExemplarSlice(tv.Exemplars())
	fillTestMetricDataPointFlagsStruct(tv.FlagsStruct())
}

func generateTestHistogramDataPointSlice() HistogramDataPointSlice {
	tv := NewHistogramDataPointSlice()
	fillTestHistogramDataPointSlice(tv)
	return tv
}

func fillTestHistogramDataPointSlice(tv HistogramDataPointSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestHistogramDataPoint(tv.AppendEmpty())
	}
}

func generateTestHistogramDataPoint() HistogramDataPoint {
	tv := NewHistogramDataPoint()
	fillTestHistogramDataPoint(tv)
	return tv
}

func fillTestHistogramDataPoint(tv HistogramDataPoint) {
	fillTestMap(tv.Attributes())
	tv.SetStartTimestamp(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetCount(uint64(17))
	tv.SetSum(float64(17.13))
	tv.SetBucketCounts(NewImmutableUInt64Slice([]uint64{1, 2, 3}))
	tv.SetExplicitBounds(NewImmutableFloat64Slice([]float64{1, 2, 3}))
	fillTestExemplarSlice(tv.Exemplars())
	fillTestMetricDataPointFlagsStruct(tv.FlagsStruct())
	tv.SetMin(float64(9.23))
	tv.SetMax(float64(182.55))
}

func generateTestExponentialHistogramDataPointSlice() ExponentialHistogramDataPointSlice {
	tv := NewExponentialHistogramDataPointSlice()
	fillTestExponentialHistogramDataPointSlice(tv)
	return tv
}

func fillTestExponentialHistogramDataPointSlice(tv ExponentialHistogramDataPointSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestExponentialHistogramDataPoint(tv.AppendEmpty())
	}
}

func generateTestExponentialHistogramDataPoint() ExponentialHistogramDataPoint {
	tv := NewExponentialHistogramDataPoint()
	fillTestExponentialHistogramDataPoint(tv)
	return tv
}

func fillTestExponentialHistogramDataPoint(tv ExponentialHistogramDataPoint) {
	fillTestMap(tv.Attributes())
	tv.SetStartTimestamp(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetCount(uint64(17))
	tv.SetSum(float64(17.13))
	tv.SetScale(int32(4))
	tv.SetZeroCount(uint64(201))
	fillTestBuckets(tv.Positive())
	fillTestBuckets(tv.Negative())
	fillTestExemplarSlice(tv.Exemplars())
	fillTestMetricDataPointFlagsStruct(tv.FlagsStruct())
	tv.SetMin(float64(9.23))
	tv.SetMax(float64(182.55))
}

func generateTestBuckets() Buckets {
	tv := NewBuckets()
	fillTestBuckets(tv)
	return tv
}

func fillTestBuckets(tv Buckets) {
	tv.SetOffset(int32(909))
	tv.SetBucketCounts(NewImmutableUInt64Slice([]uint64{1, 2, 3}))
}

func generateTestSummaryDataPointSlice() SummaryDataPointSlice {
	tv := NewSummaryDataPointSlice()
	fillTestSummaryDataPointSlice(tv)
	return tv
}

func fillTestSummaryDataPointSlice(tv SummaryDataPointSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestSummaryDataPoint(tv.AppendEmpty())
	}
}

func generateTestSummaryDataPoint() SummaryDataPoint {
	tv := NewSummaryDataPoint()
	fillTestSummaryDataPoint(tv)
	return tv
}

func fillTestSummaryDataPoint(tv SummaryDataPoint) {
	fillTestMap(tv.Attributes())
	tv.SetStartTimestamp(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetCount(uint64(17))
	tv.SetSum(float64(17.13))
	fillTestValueAtQuantileSlice(tv.QuantileValues())
	fillTestMetricDataPointFlagsStruct(tv.FlagsStruct())
}

func generateTestValueAtQuantileSlice() ValueAtQuantileSlice {
	tv := NewValueAtQuantileSlice()
	fillTestValueAtQuantileSlice(tv)
	return tv
}

func fillTestValueAtQuantileSlice(tv ValueAtQuantileSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestValueAtQuantile(tv.AppendEmpty())
	}
}

func generateTestValueAtQuantile() ValueAtQuantile {
	tv := NewValueAtQuantile()
	fillTestValueAtQuantile(tv)
	return tv
}

func fillTestValueAtQuantile(tv ValueAtQuantile) {
	tv.SetQuantile(float64(17.13))
	tv.SetValue(float64(17.13))
}

func generateTestExemplarSlice() ExemplarSlice {
	tv := NewExemplarSlice()
	fillTestExemplarSlice(tv)
	return tv
}

func fillTestExemplarSlice(tv ExemplarSlice) {
	l := 7
	tv.EnsureCapacity(l)
	for i := 0; i < l; i++ {
		fillTestExemplar(tv.AppendEmpty())
	}
}

func generateTestExemplar() Exemplar {
	tv := NewExemplar()
	fillTestExemplar(tv)
	return tv
}

func fillTestExemplar(tv Exemplar) {
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetIntVal(int64(17))
	fillTestMap(tv.FilteredAttributes())
	tv.SetTraceID(NewTraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1}))
	tv.SetSpanID(NewSpanID([8]byte{1, 2, 3, 4, 5, 6, 7, 8}))
}
