// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: opentelemetry/proto/trace/v1/trace.proto

/*
	Package v1 is a generated protocol buffer package.

	It is generated from these files:
		opentelemetry/proto/trace/v1/trace.proto

	It has these top-level messages:
		ResourceSpans
		InstrumentationLibrarySpans
		Span
		Status
*/
package v1

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import opentelemetry_proto_common_v1 "go.opentelemetry.io/collector/internal/data/opentelemetry-proto-gen/common/v1"
import opentelemetry_proto_resource_v1 "go.opentelemetry.io/collector/internal/data/opentelemetry-proto-gen/resource/v1"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// SpanKind is the type of span. Can be used to specify additional relationships between spans
// in addition to a parent/child relationship.
type Span_SpanKind int32

const (
	// Unspecified. Do NOT use as default.
	// Implementations MAY assume SpanKind to be INTERNAL when receiving UNSPECIFIED.
	Span_SPAN_KIND_UNSPECIFIED Span_SpanKind = 0
	// Indicates that the span represents an internal operation within an application,
	// as opposed to an operations happening at the boundaries. Default value.
	Span_INTERNAL Span_SpanKind = 1
	// Indicates that the span covers server-side handling of an RPC or other
	// remote network request.
	Span_SERVER Span_SpanKind = 2
	// Indicates that the span describes a request to some remote service.
	Span_CLIENT Span_SpanKind = 3
	// Indicates that the span describes a producer sending a message to a broker.
	// Unlike CLIENT and SERVER, there is often no direct critical path latency relationship
	// between producer and consumer spans. A PRODUCER span ends when the message was accepted
	// by the broker while the logical processing of the message might span a much longer time.
	Span_PRODUCER Span_SpanKind = 4
	// Indicates that the span describes consumer receiving a message from a broker.
	// Like the PRODUCER kind, there is often no direct critical path latency relationship
	// between producer and consumer spans.
	Span_CONSUMER Span_SpanKind = 5
)

var Span_SpanKind_name = map[int32]string{
	0: "SPAN_KIND_UNSPECIFIED",
	1: "INTERNAL",
	2: "SERVER",
	3: "CLIENT",
	4: "PRODUCER",
	5: "CONSUMER",
}
var Span_SpanKind_value = map[string]int32{
	"SPAN_KIND_UNSPECIFIED": 0,
	"INTERNAL":              1,
	"SERVER":                2,
	"CLIENT":                3,
	"PRODUCER":              4,
	"CONSUMER":              5,
}

func (x Span_SpanKind) String() string {
	return proto.EnumName(Span_SpanKind_name, int32(x))
}
func (Span_SpanKind) EnumDescriptor() ([]byte, []int) { return fileDescriptorTrace, []int{2, 0} }

// StatusCode mirrors the codes defined at
// https://github.com/open-telemetry/opentelemetry-specification/blob/master/specification/api-tracing.md#statuscanonicalcode
type Status_StatusCode int32

const (
	Status_Ok                 Status_StatusCode = 0
	Status_Cancelled          Status_StatusCode = 1
	Status_UnknownError       Status_StatusCode = 2
	Status_InvalidArgument    Status_StatusCode = 3
	Status_DeadlineExceeded   Status_StatusCode = 4
	Status_NotFound           Status_StatusCode = 5
	Status_AlreadyExists      Status_StatusCode = 6
	Status_PermissionDenied   Status_StatusCode = 7
	Status_ResourceExhausted  Status_StatusCode = 8
	Status_FailedPrecondition Status_StatusCode = 9
	Status_Aborted            Status_StatusCode = 10
	Status_OutOfRange         Status_StatusCode = 11
	Status_Unimplemented      Status_StatusCode = 12
	Status_InternalError      Status_StatusCode = 13
	Status_Unavailable        Status_StatusCode = 14
	Status_DataLoss           Status_StatusCode = 15
	Status_Unauthenticated    Status_StatusCode = 16
)

var Status_StatusCode_name = map[int32]string{
	0:  "Ok",
	1:  "Cancelled",
	2:  "UnknownError",
	3:  "InvalidArgument",
	4:  "DeadlineExceeded",
	5:  "NotFound",
	6:  "AlreadyExists",
	7:  "PermissionDenied",
	8:  "ResourceExhausted",
	9:  "FailedPrecondition",
	10: "Aborted",
	11: "OutOfRange",
	12: "Unimplemented",
	13: "InternalError",
	14: "Unavailable",
	15: "DataLoss",
	16: "Unauthenticated",
}
var Status_StatusCode_value = map[string]int32{
	"Ok":                 0,
	"Cancelled":          1,
	"UnknownError":       2,
	"InvalidArgument":    3,
	"DeadlineExceeded":   4,
	"NotFound":           5,
	"AlreadyExists":      6,
	"PermissionDenied":   7,
	"ResourceExhausted":  8,
	"FailedPrecondition": 9,
	"Aborted":            10,
	"OutOfRange":         11,
	"Unimplemented":      12,
	"InternalError":      13,
	"Unavailable":        14,
	"DataLoss":           15,
	"Unauthenticated":    16,
}

func (x Status_StatusCode) String() string {
	return proto.EnumName(Status_StatusCode_name, int32(x))
}
func (Status_StatusCode) EnumDescriptor() ([]byte, []int) { return fileDescriptorTrace, []int{3, 0} }

// A collection of InstrumentationLibrarySpans from a Resource.
type ResourceSpans struct {
	// The resource for the spans in this message.
	// If this field is not set then no resource info is known.
	Resource *opentelemetry_proto_resource_v1.Resource `protobuf:"bytes,1,opt,name=resource" json:"resource,omitempty"`
	// A list of InstrumentationLibrarySpans that originate from a resource.
	InstrumentationLibrarySpans []*InstrumentationLibrarySpans `protobuf:"bytes,2,rep,name=instrumentation_library_spans,json=instrumentationLibrarySpans" json:"instrumentation_library_spans,omitempty"`
}

func (m *ResourceSpans) Reset()                    { *m = ResourceSpans{} }
func (m *ResourceSpans) String() string            { return proto.CompactTextString(m) }
func (*ResourceSpans) ProtoMessage()               {}
func (*ResourceSpans) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{0} }

func (m *ResourceSpans) GetResource() *opentelemetry_proto_resource_v1.Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *ResourceSpans) GetInstrumentationLibrarySpans() []*InstrumentationLibrarySpans {
	if m != nil {
		return m.InstrumentationLibrarySpans
	}
	return nil
}

// A collection of Spans produced by an InstrumentationLibrary.
type InstrumentationLibrarySpans struct {
	// The instrumentation library information for the spans in this message.
	// If this field is not set then no library info is known.
	InstrumentationLibrary *opentelemetry_proto_common_v1.InstrumentationLibrary `protobuf:"bytes,1,opt,name=instrumentation_library,json=instrumentationLibrary" json:"instrumentation_library,omitempty"`
	// A list of Spans that originate from an instrumentation library.
	Spans []*Span `protobuf:"bytes,2,rep,name=spans" json:"spans,omitempty"`
}

func (m *InstrumentationLibrarySpans) Reset()                    { *m = InstrumentationLibrarySpans{} }
func (m *InstrumentationLibrarySpans) String() string            { return proto.CompactTextString(m) }
func (*InstrumentationLibrarySpans) ProtoMessage()               {}
func (*InstrumentationLibrarySpans) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{1} }

func (m *InstrumentationLibrarySpans) GetInstrumentationLibrary() *opentelemetry_proto_common_v1.InstrumentationLibrary {
	if m != nil {
		return m.InstrumentationLibrary
	}
	return nil
}

func (m *InstrumentationLibrarySpans) GetSpans() []*Span {
	if m != nil {
		return m.Spans
	}
	return nil
}

// Span represents a single operation within a trace. Spans can be
// nested to form a trace tree. Spans may also be linked to other spans
// from the same or different trace and form graphs. Often, a trace
// contains a root span that describes the end-to-end latency, and one
// or more subspans for its sub-operations. A trace can also contain
// multiple root spans, or none at all. Spans do not need to be
// contiguous - there may be gaps or overlaps between spans in a trace.
//
// The next available field id is 17.
type Span struct {
	// A unique identifier for a trace. All spans from the same trace share
	// the same `trace_id`. The ID is a 16-byte array. An ID with all zeroes
	// is considered invalid.
	//
	// This field is semantically required. Receiver should generate new
	// random trace_id if empty or invalid trace_id was received.
	//
	// This field is required.
	TraceId []byte `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// A unique identifier for a span within a trace, assigned when the span
	// is created. The ID is an 8-byte array. An ID with all zeroes is considered
	// invalid.
	//
	// This field is semantically required. Receiver should generate new
	// random span_id if empty or invalid span_id was received.
	//
	// This field is required.
	SpanId []byte `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// trace_state conveys information about request position in multiple distributed tracing graphs.
	// It is a trace_state in w3c-trace-context format: https://www.w3.org/TR/trace-context/#tracestate-header
	// See also https://github.com/w3c/distributed-tracing for more details about this field.
	TraceState string `protobuf:"bytes,3,opt,name=trace_state,json=traceState,proto3" json:"trace_state,omitempty"`
	// The `span_id` of this span's parent span. If this is a root span, then this
	// field must be empty. The ID is an 8-byte array.
	ParentSpanId []byte `protobuf:"bytes,4,opt,name=parent_span_id,json=parentSpanId,proto3" json:"parent_span_id,omitempty"`
	// A description of the span's operation.
	//
	// For example, the name can be a qualified method name or a file name
	// and a line number where the operation is called. A best practice is to use
	// the same display name at the same call point in an application.
	// This makes it easier to correlate spans in different traces.
	//
	// This field is semantically required to be set to non-empty string.
	// When null or empty string received - receiver may use string "name"
	// as a replacement. There might be smarted algorithms implemented by
	// receiver to fix the empty span name.
	//
	// This field is required.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// Distinguishes between spans generated in a particular context. For example,
	// two spans with the same name may be distinguished using `CLIENT` (caller)
	// and `SERVER` (callee) to identify queueing latency associated with the span.
	Kind Span_SpanKind `protobuf:"varint,6,opt,name=kind,proto3,enum=opentelemetry.proto.trace.v1.Span_SpanKind" json:"kind,omitempty"`
	// start_time_unix_nano is the start time of the span. On the client side, this is the time
	// kept by the local machine where the span execution starts. On the server side, this
	// is the time when the server's application handler starts running.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// This field is semantically required and it is expected that end_time >= start_time.
	StartTimeUnixNano uint64 `protobuf:"fixed64,7,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// end_time_unix_nano is the end time of the span. On the client side, this is the time
	// kept by the local machine where the span execution ends. On the server side, this
	// is the time when the server application handler stops running.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// This field is semantically required and it is expected that end_time >= start_time.
	EndTimeUnixNano uint64 `protobuf:"fixed64,8,opt,name=end_time_unix_nano,json=endTimeUnixNano,proto3" json:"end_time_unix_nano,omitempty"`
	// attributes is a collection of key/value pairs. The value can be a string,
	// an integer, a double or the Boolean values `true` or `false`. Note, global attributes
	// like server name can be set using the resource API. Examples of attributes:
	//
	//     "/http/user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36"
	//     "/http/server_latency": 300
	//     "abc.com/myattribute": true
	//     "abc.com/score": 10.239
	Attributes []*opentelemetry_proto_common_v1.AttributeKeyValue `protobuf:"bytes,9,rep,name=attributes" json:"attributes,omitempty"`
	// dropped_attributes_count is the number of attributes that were discarded. Attributes
	// can be discarded because their keys are too long or because there are too many
	// attributes. If this value is 0, then no attributes were dropped.
	DroppedAttributesCount uint32 `protobuf:"varint,10,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
	// events is a collection of Event items.
	Events []*Span_Event `protobuf:"bytes,11,rep,name=events" json:"events,omitempty"`
	// dropped_events_count is the number of dropped events. If the value is 0, then no
	// events were dropped.
	DroppedEventsCount uint32 `protobuf:"varint,12,opt,name=dropped_events_count,json=droppedEventsCount,proto3" json:"dropped_events_count,omitempty"`
	// links is a collection of Links, which are references from this span to a span
	// in the same or different trace.
	Links []*Span_Link `protobuf:"bytes,13,rep,name=links" json:"links,omitempty"`
	// dropped_links_count is the number of dropped links after the maximum size was
	// enforced. If this value is 0, then no links were dropped.
	DroppedLinksCount uint32 `protobuf:"varint,14,opt,name=dropped_links_count,json=droppedLinksCount,proto3" json:"dropped_links_count,omitempty"`
	// An optional final status for this span. Semantically when Status
	// wasn't set it is means span ended without errors and assume
	// Status.Ok (code = 0).
	Status *Status `protobuf:"bytes,15,opt,name=status" json:"status,omitempty"`
}

func (m *Span) Reset()                    { *m = Span{} }
func (m *Span) String() string            { return proto.CompactTextString(m) }
func (*Span) ProtoMessage()               {}
func (*Span) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{2} }

func (m *Span) GetTraceId() []byte {
	if m != nil {
		return m.TraceId
	}
	return nil
}

func (m *Span) GetSpanId() []byte {
	if m != nil {
		return m.SpanId
	}
	return nil
}

func (m *Span) GetTraceState() string {
	if m != nil {
		return m.TraceState
	}
	return ""
}

func (m *Span) GetParentSpanId() []byte {
	if m != nil {
		return m.ParentSpanId
	}
	return nil
}

func (m *Span) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Span) GetKind() Span_SpanKind {
	if m != nil {
		return m.Kind
	}
	return Span_SPAN_KIND_UNSPECIFIED
}

func (m *Span) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *Span) GetEndTimeUnixNano() uint64 {
	if m != nil {
		return m.EndTimeUnixNano
	}
	return 0
}

func (m *Span) GetAttributes() []*opentelemetry_proto_common_v1.AttributeKeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Span) GetDroppedAttributesCount() uint32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

func (m *Span) GetEvents() []*Span_Event {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *Span) GetDroppedEventsCount() uint32 {
	if m != nil {
		return m.DroppedEventsCount
	}
	return 0
}

func (m *Span) GetLinks() []*Span_Link {
	if m != nil {
		return m.Links
	}
	return nil
}

func (m *Span) GetDroppedLinksCount() uint32 {
	if m != nil {
		return m.DroppedLinksCount
	}
	return 0
}

func (m *Span) GetStatus() *Status {
	if m != nil {
		return m.Status
	}
	return nil
}

// Event is a time-stamped annotation of the span, consisting of user-supplied
// text description and key-value pairs.
type Span_Event struct {
	// time_unix_nano is the time the event occurred.
	TimeUnixNano uint64 `protobuf:"fixed64,1,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// name of the event.
	// This field is semantically required to be set to non-empty string.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// attributes is a collection of attribute key/value pairs on the event.
	Attributes []*opentelemetry_proto_common_v1.AttributeKeyValue `protobuf:"bytes,3,rep,name=attributes" json:"attributes,omitempty"`
	// dropped_attributes_count is the number of dropped attributes. If the value is 0,
	// then no attributes were dropped.
	DroppedAttributesCount uint32 `protobuf:"varint,4,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
}

func (m *Span_Event) Reset()                    { *m = Span_Event{} }
func (m *Span_Event) String() string            { return proto.CompactTextString(m) }
func (*Span_Event) ProtoMessage()               {}
func (*Span_Event) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{2, 0} }

func (m *Span_Event) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *Span_Event) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Span_Event) GetAttributes() []*opentelemetry_proto_common_v1.AttributeKeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Span_Event) GetDroppedAttributesCount() uint32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

// A pointer from the current span to another span in the same trace or in a
// different trace. For example, this can be used in batching operations,
// where a single batch handler processes multiple requests from different
// traces or when the handler receives a request from a different project.
type Span_Link struct {
	// A unique identifier of a trace that this linked span is part of. The ID is a
	// 16-byte array.
	TraceId []byte `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// A unique identifier for the linked span. The ID is an 8-byte array.
	SpanId []byte `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// The trace_state associated with the link.
	TraceState string `protobuf:"bytes,3,opt,name=trace_state,json=traceState,proto3" json:"trace_state,omitempty"`
	// attributes is a collection of attribute key/value pairs on the link.
	Attributes []*opentelemetry_proto_common_v1.AttributeKeyValue `protobuf:"bytes,4,rep,name=attributes" json:"attributes,omitempty"`
	// dropped_attributes_count is the number of dropped attributes. If the value is 0,
	// then no attributes were dropped.
	DroppedAttributesCount uint32 `protobuf:"varint,5,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
}

func (m *Span_Link) Reset()                    { *m = Span_Link{} }
func (m *Span_Link) String() string            { return proto.CompactTextString(m) }
func (*Span_Link) ProtoMessage()               {}
func (*Span_Link) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{2, 1} }

func (m *Span_Link) GetTraceId() []byte {
	if m != nil {
		return m.TraceId
	}
	return nil
}

func (m *Span_Link) GetSpanId() []byte {
	if m != nil {
		return m.SpanId
	}
	return nil
}

func (m *Span_Link) GetTraceState() string {
	if m != nil {
		return m.TraceState
	}
	return ""
}

func (m *Span_Link) GetAttributes() []*opentelemetry_proto_common_v1.AttributeKeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Span_Link) GetDroppedAttributesCount() uint32 {
	if m != nil {
		return m.DroppedAttributesCount
	}
	return 0
}

// The Status type defines a logical error model that is suitable for different
// programming environments, including REST APIs and RPC APIs.
type Status struct {
	// The status code. This is optional field. It is safe to assume 0 (OK)
	// when not set.
	Code Status_StatusCode `protobuf:"varint,1,opt,name=code,proto3,enum=opentelemetry.proto.trace.v1.Status_StatusCode" json:"code,omitempty"`
	// A developer-facing human readable error message.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *Status) Reset()                    { *m = Status{} }
func (m *Status) String() string            { return proto.CompactTextString(m) }
func (*Status) ProtoMessage()               {}
func (*Status) Descriptor() ([]byte, []int) { return fileDescriptorTrace, []int{3} }

func (m *Status) GetCode() Status_StatusCode {
	if m != nil {
		return m.Code
	}
	return Status_Ok
}

func (m *Status) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func init() {
	proto.RegisterType((*ResourceSpans)(nil), "opentelemetry.proto.trace.v1.ResourceSpans")
	proto.RegisterType((*InstrumentationLibrarySpans)(nil), "opentelemetry.proto.trace.v1.InstrumentationLibrarySpans")
	proto.RegisterType((*Span)(nil), "opentelemetry.proto.trace.v1.Span")
	proto.RegisterType((*Span_Event)(nil), "opentelemetry.proto.trace.v1.Span.Event")
	proto.RegisterType((*Span_Link)(nil), "opentelemetry.proto.trace.v1.Span.Link")
	proto.RegisterType((*Status)(nil), "opentelemetry.proto.trace.v1.Status")
	proto.RegisterEnum("opentelemetry.proto.trace.v1.Span_SpanKind", Span_SpanKind_name, Span_SpanKind_value)
	proto.RegisterEnum("opentelemetry.proto.trace.v1.Status_StatusCode", Status_StatusCode_name, Status_StatusCode_value)
}
func (m *ResourceSpans) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceSpans) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Resource != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Resource.Size()))
		n1, err := m.Resource.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.InstrumentationLibrarySpans) > 0 {
		for _, msg := range m.InstrumentationLibrarySpans {
			dAtA[i] = 0x12
			i++
			i = encodeVarintTrace(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *InstrumentationLibrarySpans) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstrumentationLibrarySpans) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.InstrumentationLibrary != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.InstrumentationLibrary.Size()))
		n2, err := m.InstrumentationLibrary.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.Spans) > 0 {
		for _, msg := range m.Spans {
			dAtA[i] = 0x12
			i++
			i = encodeVarintTrace(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Span) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TraceId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.TraceId)))
		i += copy(dAtA[i:], m.TraceId)
	}
	if len(m.SpanId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.SpanId)))
		i += copy(dAtA[i:], m.SpanId)
	}
	if len(m.TraceState) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.TraceState)))
		i += copy(dAtA[i:], m.TraceState)
	}
	if len(m.ParentSpanId) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.ParentSpanId)))
		i += copy(dAtA[i:], m.ParentSpanId)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Kind != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Kind))
	}
	if m.StartTimeUnixNano != 0 {
		dAtA[i] = 0x39
		i++
		i = encodeFixed64Trace(dAtA, i, uint64(m.StartTimeUnixNano))
	}
	if m.EndTimeUnixNano != 0 {
		dAtA[i] = 0x41
		i++
		i = encodeFixed64Trace(dAtA, i, uint64(m.EndTimeUnixNano))
	}
	if len(m.Attributes) > 0 {
		for _, msg := range m.Attributes {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintTrace(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DroppedAttributesCount != 0 {
		dAtA[i] = 0x50
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.DroppedAttributesCount))
	}
	if len(m.Events) > 0 {
		for _, msg := range m.Events {
			dAtA[i] = 0x5a
			i++
			i = encodeVarintTrace(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DroppedEventsCount != 0 {
		dAtA[i] = 0x60
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.DroppedEventsCount))
	}
	if len(m.Links) > 0 {
		for _, msg := range m.Links {
			dAtA[i] = 0x6a
			i++
			i = encodeVarintTrace(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DroppedLinksCount != 0 {
		dAtA[i] = 0x70
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.DroppedLinksCount))
	}
	if m.Status != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Status.Size()))
		n3, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}

func (m *Span_Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span_Event) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TimeUnixNano != 0 {
		dAtA[i] = 0x9
		i++
		i = encodeFixed64Trace(dAtA, i, uint64(m.TimeUnixNano))
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Attributes) > 0 {
		for _, msg := range m.Attributes {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintTrace(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DroppedAttributesCount != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.DroppedAttributesCount))
	}
	return i, nil
}

func (m *Span_Link) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span_Link) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TraceId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.TraceId)))
		i += copy(dAtA[i:], m.TraceId)
	}
	if len(m.SpanId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.SpanId)))
		i += copy(dAtA[i:], m.SpanId)
	}
	if len(m.TraceState) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.TraceState)))
		i += copy(dAtA[i:], m.TraceState)
	}
	if len(m.Attributes) > 0 {
		for _, msg := range m.Attributes {
			dAtA[i] = 0x22
			i++
			i = encodeVarintTrace(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DroppedAttributesCount != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.DroppedAttributesCount))
	}
	return i, nil
}

func (m *Status) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Status) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Code != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTrace(dAtA, i, uint64(m.Code))
	}
	if len(m.Message) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTrace(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	return i, nil
}

func encodeFixed64Trace(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Trace(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintTrace(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *ResourceSpans) Size() (n int) {
	var l int
	_ = l
	if m.Resource != nil {
		l = m.Resource.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if len(m.InstrumentationLibrarySpans) > 0 {
		for _, e := range m.InstrumentationLibrarySpans {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	return n
}

func (m *InstrumentationLibrarySpans) Size() (n int) {
	var l int
	_ = l
	if m.InstrumentationLibrary != nil {
		l = m.InstrumentationLibrary.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	if len(m.Spans) > 0 {
		for _, e := range m.Spans {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	return n
}

func (m *Span) Size() (n int) {
	var l int
	_ = l
	l = len(m.TraceId)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	l = len(m.SpanId)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	l = len(m.TraceState)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	l = len(m.ParentSpanId)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	if m.Kind != 0 {
		n += 1 + sovTrace(uint64(m.Kind))
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.EndTimeUnixNano != 0 {
		n += 9
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	if m.DroppedAttributesCount != 0 {
		n += 1 + sovTrace(uint64(m.DroppedAttributesCount))
	}
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	if m.DroppedEventsCount != 0 {
		n += 1 + sovTrace(uint64(m.DroppedEventsCount))
	}
	if len(m.Links) > 0 {
		for _, e := range m.Links {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	if m.DroppedLinksCount != 0 {
		n += 1 + sovTrace(uint64(m.DroppedLinksCount))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovTrace(uint64(l))
	}
	return n
}

func (m *Span_Event) Size() (n int) {
	var l int
	_ = l
	if m.TimeUnixNano != 0 {
		n += 9
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	if m.DroppedAttributesCount != 0 {
		n += 1 + sovTrace(uint64(m.DroppedAttributesCount))
	}
	return n
}

func (m *Span_Link) Size() (n int) {
	var l int
	_ = l
	l = len(m.TraceId)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	l = len(m.SpanId)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	l = len(m.TraceState)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovTrace(uint64(l))
		}
	}
	if m.DroppedAttributesCount != 0 {
		n += 1 + sovTrace(uint64(m.DroppedAttributesCount))
	}
	return n
}

func (m *Status) Size() (n int) {
	var l int
	_ = l
	if m.Code != 0 {
		n += 1 + sovTrace(uint64(m.Code))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovTrace(uint64(l))
	}
	return n
}

func sovTrace(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTrace(x uint64) (n int) {
	return sovTrace(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ResourceSpans) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceSpans: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceSpans: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resource == nil {
				m.Resource = &opentelemetry_proto_resource_v1.Resource{}
			}
			if err := m.Resource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstrumentationLibrarySpans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InstrumentationLibrarySpans = append(m.InstrumentationLibrarySpans, &InstrumentationLibrarySpans{})
			if err := m.InstrumentationLibrarySpans[len(m.InstrumentationLibrarySpans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstrumentationLibrarySpans) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstrumentationLibrarySpans: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstrumentationLibrarySpans: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstrumentationLibrary", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InstrumentationLibrary == nil {
				m.InstrumentationLibrary = &opentelemetry_proto_common_v1.InstrumentationLibrary{}
			}
			if err := m.InstrumentationLibrary.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Spans = append(m.Spans, &Span{})
			if err := m.Spans[len(m.Spans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Span) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Span: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Span: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceId = append(m.TraceId[:0], dAtA[iNdEx:postIndex]...)
			if m.TraceId == nil {
				m.TraceId = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanId = append(m.SpanId[:0], dAtA[iNdEx:postIndex]...)
			if m.SpanId == nil {
				m.SpanId = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceState", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceState = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentSpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentSpanId = append(m.ParentSpanId[:0], dAtA[iNdEx:postIndex]...)
			if m.ParentSpanId == nil {
				m.ParentSpanId = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			m.Kind = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Kind |= (Span_SpanKind(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.StartTimeUnixNano = uint64(dAtA[iNdEx-8])
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-7]) << 8
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-6]) << 16
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-5]) << 24
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-4]) << 32
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-3]) << 40
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-2]) << 48
			m.StartTimeUnixNano |= uint64(dAtA[iNdEx-1]) << 56
		case 8:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTimeUnixNano", wireType)
			}
			m.EndTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.EndTimeUnixNano = uint64(dAtA[iNdEx-8])
			m.EndTimeUnixNano |= uint64(dAtA[iNdEx-7]) << 8
			m.EndTimeUnixNano |= uint64(dAtA[iNdEx-6]) << 16
			m.EndTimeUnixNano |= uint64(dAtA[iNdEx-5]) << 24
			m.EndTimeUnixNano |= uint64(dAtA[iNdEx-4]) << 32
			m.EndTimeUnixNano |= uint64(dAtA[iNdEx-3]) << 40
			m.EndTimeUnixNano |= uint64(dAtA[iNdEx-2]) << 48
			m.EndTimeUnixNano |= uint64(dAtA[iNdEx-1]) << 56
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, &opentelemetry_proto_common_v1.AttributeKeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			m.DroppedAttributesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedAttributesCount |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, &Span_Event{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedEventsCount", wireType)
			}
			m.DroppedEventsCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedEventsCount |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Links", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Links = append(m.Links, &Span_Link{})
			if err := m.Links[len(m.Links)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedLinksCount", wireType)
			}
			m.DroppedLinksCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedLinksCount |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &Status{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Span_Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.TimeUnixNano = uint64(dAtA[iNdEx-8])
			m.TimeUnixNano |= uint64(dAtA[iNdEx-7]) << 8
			m.TimeUnixNano |= uint64(dAtA[iNdEx-6]) << 16
			m.TimeUnixNano |= uint64(dAtA[iNdEx-5]) << 24
			m.TimeUnixNano |= uint64(dAtA[iNdEx-4]) << 32
			m.TimeUnixNano |= uint64(dAtA[iNdEx-3]) << 40
			m.TimeUnixNano |= uint64(dAtA[iNdEx-2]) << 48
			m.TimeUnixNano |= uint64(dAtA[iNdEx-1]) << 56
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, &opentelemetry_proto_common_v1.AttributeKeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			m.DroppedAttributesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedAttributesCount |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Span_Link) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Link: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Link: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceId = append(m.TraceId[:0], dAtA[iNdEx:postIndex]...)
			if m.TraceId == nil {
				m.TraceId = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanId = append(m.SpanId[:0], dAtA[iNdEx:postIndex]...)
			if m.SpanId == nil {
				m.SpanId = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceState", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceState = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, &opentelemetry_proto_common_v1.AttributeKeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			m.DroppedAttributesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DroppedAttributesCount |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Status) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Status: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Status: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= (Status_StatusCode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTrace
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTrace(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTrace
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTrace(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTrace
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTrace
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthTrace
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTrace
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTrace(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTrace = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTrace   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("opentelemetry/proto/trace/v1/trace.proto", fileDescriptorTrace) }

var fileDescriptorTrace = []byte{
	// 1038 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0x4d, 0x6f, 0x1b, 0x37,
	0x13, 0xf6, 0xea, 0xdb, 0xa3, 0x0f, 0xaf, 0x19, 0xc7, 0xd9, 0x38, 0xef, 0xeb, 0x08, 0x42, 0x80,
	0xaa, 0x0d, 0x22, 0xc5, 0x2e, 0x0a, 0xa4, 0x40, 0x8b, 0x56, 0x91, 0xd6, 0x80, 0x60, 0x55, 0x16,
	0x56, 0x56, 0x0e, 0xbd, 0x08, 0xb4, 0xc8, 0x2a, 0x84, 0x57, 0xa4, 0xc0, 0xe5, 0xaa, 0xf6, 0xa1,
	0xb7, 0x5e, 0x0b, 0xf4, 0x5f, 0xf4, 0x57, 0xf4, 0xdc, 0x5e, 0x0a, 0xf4, 0xd2, 0x7b, 0xe1, 0x1e,
	0xfa, 0x37, 0x0a, 0x72, 0x77, 0x1d, 0xcb, 0xb0, 0x65, 0x5f, 0x7c, 0x91, 0xc8, 0x99, 0xe7, 0x99,
	0x67, 0x86, 0x33, 0x04, 0x17, 0xea, 0x62, 0x4e, 0xb9, 0xa2, 0x3e, 0x9d, 0x51, 0x25, 0xcf, 0x9b,
	0x73, 0x29, 0x94, 0x68, 0x2a, 0x89, 0x27, 0xb4, 0xb9, 0xd8, 0x8b, 0x16, 0x0d, 0x63, 0x44, 0xff,
	0x5b, 0x42, 0x46, 0xc6, 0x46, 0x04, 0x58, 0xec, 0xed, 0x7c, 0x72, 0x53, 0x9c, 0x89, 0x98, 0xcd,
	0x04, 0xd7, 0x81, 0xa2, 0x55, 0x44, 0xda, 0x69, 0xdc, 0x84, 0x95, 0x34, 0x10, 0xa1, 0x8c, 0x64,
	0x93, 0x75, 0x84, 0xaf, 0xfd, 0x65, 0x41, 0xd9, 0x8b, 0x4d, 0xc3, 0x39, 0xe6, 0x01, 0x72, 0xa1,
	0x90, 0x60, 0x1c, 0xab, 0x6a, 0xd5, 0x8b, 0xfb, 0x1f, 0x37, 0x6e, 0x4a, 0xef, 0x32, 0xd0, 0x62,
	0xaf, 0x91, 0x44, 0xf0, 0x2e, 0xa9, 0xe8, 0x07, 0xf8, 0x3f, 0xe3, 0x81, 0x92, 0xe1, 0x8c, 0x72,
	0x85, 0x15, 0x13, 0x7c, 0xec, 0xb3, 0x13, 0x89, 0xe5, 0xf9, 0x38, 0xd0, 0x3a, 0x4e, 0xaa, 0x9a,
	0xae, 0x17, 0xf7, 0x3f, 0x6f, 0xac, 0x2a, 0xbd, 0xd1, 0x5d, 0x0e, 0xd1, 0x8b, 0x22, 0x98, 0x44,
	0xbd, 0x67, 0xec, 0x76, 0x67, 0xed, 0x37, 0x0b, 0x9e, 0xad, 0x20, 0x23, 0x0e, 0x4f, 0x6e, 0x49,
	0x2f, 0x2e, 0xfa, 0xb3, 0x1b, 0x13, 0x8b, 0xcf, 0xfa, 0xd6, 0xcc, 0xbc, 0xed, 0x9b, 0x93, 0x42,
	0x6f, 0x20, 0x7b, 0xb5, 0xec, 0xda, 0xea, 0xb2, 0x75, 0x8e, 0x5e, 0x44, 0xa8, 0xfd, 0x08, 0x90,
	0xd1, 0x7b, 0xf4, 0x14, 0x0a, 0x06, 0x30, 0x66, 0xc4, 0xe4, 0x58, 0xf2, 0xf2, 0x66, 0xdf, 0x25,
	0xe8, 0x09, 0xe4, 0x35, 0x58, 0x7b, 0x52, 0xc6, 0x93, 0xd3, 0xdb, 0x2e, 0x41, 0xcf, 0xa1, 0x18,
	0x71, 0x02, 0x85, 0x15, 0x75, 0xd2, 0x55, 0xab, 0xbe, 0xee, 0x81, 0x31, 0x0d, 0xb5, 0x05, 0xbd,
	0x80, 0xca, 0x1c, 0x4b, 0xca, 0xd5, 0x38, 0x09, 0x90, 0x31, 0x01, 0x4a, 0x91, 0x75, 0x18, 0x85,
	0x41, 0x90, 0xe1, 0x78, 0x46, 0x9d, 0xac, 0xe1, 0x9b, 0x35, 0xfa, 0x0a, 0x32, 0xa7, 0x8c, 0x13,
	0x27, 0x57, 0xb5, 0xea, 0x95, 0xfd, 0x97, 0x77, 0x17, 0x64, 0x7e, 0x0e, 0x19, 0x27, 0x9e, 0x21,
	0xa2, 0x26, 0x6c, 0x05, 0x0a, 0x4b, 0x35, 0x56, 0x6c, 0x46, 0xc7, 0x21, 0x67, 0x67, 0x63, 0x8e,
	0xb9, 0x70, 0xf2, 0x55, 0xab, 0x9e, 0xf3, 0x36, 0x8d, 0xef, 0x98, 0xcd, 0xe8, 0x88, 0xb3, 0xb3,
	0x3e, 0xe6, 0x02, 0xbd, 0x04, 0x44, 0x39, 0xb9, 0x0e, 0x2f, 0x18, 0xf8, 0x06, 0xe5, 0x64, 0x09,
	0x3c, 0x00, 0xc0, 0x4a, 0x49, 0x76, 0x12, 0x2a, 0x1a, 0x38, 0xeb, 0xe6, 0xd4, 0x5f, 0xdf, 0xd1,
	0xd3, 0x56, 0x42, 0x38, 0xa4, 0xe7, 0xef, 0xb0, 0x1f, 0x52, 0xef, 0x4a, 0x0c, 0xf4, 0x06, 0x1c,
	0x22, 0xc5, 0x7c, 0x4e, 0xc9, 0xf8, 0x83, 0x75, 0x3c, 0x11, 0x21, 0x57, 0x0e, 0x54, 0xad, 0x7a,
	0xd9, 0xdb, 0x8e, 0xfd, 0x97, 0x71, 0x82, 0xb6, 0xf6, 0xa2, 0xaf, 0x21, 0x47, 0x17, 0x94, 0xab,
	0xc0, 0x29, 0x9a, 0x3c, 0xea, 0xf7, 0x38, 0x2c, 0x57, 0x13, 0xbc, 0x98, 0x87, 0x5e, 0xc3, 0x56,
	0xa2, 0x1d, 0x59, 0x62, 0xdd, 0x92, 0xd1, 0x45, 0xb1, 0xcf, 0x70, 0x62, 0xcd, 0x2f, 0x21, 0xeb,
	0x33, 0x7e, 0x1a, 0x38, 0x65, 0x23, 0xf9, 0xd1, 0x3d, 0x24, 0x7b, 0x8c, 0x9f, 0x7a, 0x11, 0x0b,
	0x35, 0xe0, 0x51, 0x22, 0x68, 0x0c, 0xb1, 0x5e, 0xc5, 0xe8, 0x6d, 0xc6, 0x2e, 0x4d, 0x88, 0xe5,
	0xbe, 0x80, 0x9c, 0x1e, 0xb1, 0x30, 0x70, 0x36, 0xcc, 0xf5, 0x79, 0x71, 0x87, 0x9e, 0xc1, 0x7a,
	0x31, 0x67, 0xe7, 0x0f, 0x0b, 0xb2, 0x26, 0x79, 0x3d, 0x8f, 0xd7, 0xfa, 0x6b, 0x99, 0xfe, 0x96,
	0xd4, 0xd5, 0xe6, 0x26, 0xf3, 0x98, 0xba, 0x32, 0x8f, 0xcb, 0x0d, 0x4f, 0x3f, 0x70, 0xc3, 0x33,
	0xab, 0x1a, 0xbe, 0xf3, 0xaf, 0x05, 0x19, 0x7d, 0x38, 0x0f, 0x73, 0x67, 0x97, 0x2b, 0xcd, 0x3c,
	0x70, 0xa5, 0xd9, 0x55, 0x95, 0xd6, 0xa6, 0x50, 0x48, 0xae, 0x35, 0x7a, 0x0a, 0x8f, 0x87, 0x83,
	0x56, 0x7f, 0x7c, 0xd8, 0xed, 0x77, 0xc6, 0xa3, 0xfe, 0x70, 0xe0, 0xb6, 0xbb, 0x07, 0x5d, 0xb7,
	0x63, 0xaf, 0xa1, 0x12, 0x14, 0xba, 0xfd, 0x63, 0xd7, 0xeb, 0xb7, 0x7a, 0xb6, 0x85, 0x00, 0x72,
	0x43, 0xd7, 0x7b, 0xe7, 0x7a, 0x76, 0x4a, 0xaf, 0xdb, 0xbd, 0xae, 0xdb, 0x3f, 0xb6, 0xd3, 0x1a,
	0x35, 0xf0, 0x8e, 0x3a, 0xa3, 0xb6, 0xeb, 0xd9, 0x19, 0xbd, 0x6b, 0x1f, 0xf5, 0x87, 0xa3, 0x6f,
	0x5c, 0xcf, 0xce, 0xd6, 0x7e, 0x49, 0x43, 0x2e, 0x9a, 0x1a, 0xd4, 0x86, 0xcc, 0x44, 0x90, 0xe8,
	0x75, 0xaa, 0xec, 0x37, 0xef, 0x33, 0x69, 0xf1, 0x5f, 0x5b, 0x10, 0xea, 0x19, 0x32, 0x72, 0x20,
	0x3f, 0xa3, 0x41, 0x80, 0xa7, 0xc9, 0x14, 0x25, 0xdb, 0xda, 0xaf, 0x29, 0x80, 0x0f, 0x70, 0x94,
	0x83, 0xd4, 0xd1, 0xa9, 0xbd, 0x86, 0xca, 0xb0, 0xde, 0xc6, 0x7c, 0x42, 0x7d, 0x9f, 0x12, 0xdb,
	0x42, 0x36, 0x94, 0x46, 0xfc, 0x94, 0x8b, 0xef, 0xb9, 0x2b, 0xa5, 0x90, 0x76, 0x0a, 0x3d, 0x82,
	0x8d, 0x2e, 0x5f, 0x60, 0x9f, 0x91, 0x96, 0x9c, 0x9a, 0x17, 0xc0, 0x4e, 0xa3, 0x2d, 0xb0, 0x3b,
	0x14, 0x13, 0x9f, 0x71, 0xea, 0x9e, 0x4d, 0x28, 0x25, 0x94, 0x44, 0xa5, 0xf5, 0x85, 0x3a, 0x10,
	0x21, 0x27, 0x76, 0x16, 0x6d, 0x42, 0xb9, 0xe5, 0x4b, 0x8a, 0xc9, 0xb9, 0x7b, 0xc6, 0x02, 0x15,
	0xd8, 0x39, 0x4d, 0x1b, 0x50, 0x39, 0x63, 0x41, 0xc0, 0x04, 0xef, 0x50, 0xce, 0x28, 0xb1, 0xf3,
	0xe8, 0x31, 0x6c, 0x26, 0x2f, 0xad, 0x7b, 0xf6, 0x1e, 0x87, 0x81, 0xa2, 0xc4, 0x2e, 0xa0, 0x6d,
	0x40, 0x07, 0x98, 0xf9, 0x94, 0x0c, 0x24, 0x9d, 0x08, 0x4e, 0x98, 0x7e, 0x78, 0xec, 0x75, 0x54,
	0x84, 0x7c, 0xeb, 0x44, 0x48, 0x0d, 0x02, 0x54, 0x01, 0x38, 0x0a, 0xd5, 0xd1, 0x77, 0x1e, 0xe6,
	0x53, 0x6a, 0x17, 0xb5, 0xe8, 0x88, 0xb3, 0xd9, 0x5c, 0x1f, 0x1b, 0xd7, 0x90, 0x92, 0x36, 0x75,
	0xb9, 0xa2, 0x92, 0x63, 0x3f, 0xaa, 0xa9, 0x8c, 0x36, 0xa0, 0x38, 0xe2, 0x78, 0x81, 0x99, 0x8f,
	0x4f, 0x7c, 0x6a, 0x57, 0x74, 0xe6, 0x1d, 0xac, 0x70, 0x4f, 0x04, 0x81, 0xbd, 0xa1, 0x4b, 0x1e,
	0x71, 0x1c, 0xaa, 0xf7, 0x94, 0x2b, 0x36, 0xc1, 0x3a, 0x8c, 0xfd, 0xf6, 0x27, 0xeb, 0xf7, 0x8b,
	0x5d, 0xeb, 0xcf, 0x8b, 0x5d, 0xeb, 0xef, 0x8b, 0x5d, 0xeb, 0xe7, 0x7f, 0x76, 0xd7, 0xe0, 0x39,
	0x13, 0x2b, 0xbb, 0xf4, 0x16, 0x8e, 0xf5, 0x6a, 0xa0, 0x8d, 0x03, 0xeb, 0xdb, 0xde, 0xf4, 0x3a,
	0x9c, 0xe9, 0x0f, 0x1e, 0xdf, 0xa7, 0x13, 0x25, 0x64, 0x93, 0xc5, 0x49, 0x36, 0x09, 0x56, 0xb8,
	0xb9, 0x04, 0x7c, 0x65, 0xe2, 0xbe, 0x9a, 0x52, 0x7e, 0xf9, 0xa1, 0x75, 0x92, 0x33, 0xb6, 0x4f,
	0xff, 0x0b, 0x00, 0x00, 0xff, 0xff, 0x90, 0xd9, 0x1a, 0x89, 0x8f, 0x09, 0x00, 0x00,
}
