// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "go run cmd/pdatagen/main.go".

package pdata

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpmetrics "go.opentelemetry.io/collector/internal/data/protogen/metrics/v1"
)

func TestResourceMetricsSlice(t *testing.T) {
	es := NewResourceMetricsSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newResourceMetricsSlice(&[]*otlpmetrics.ResourceMetrics{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewResourceMetrics()
	testVal := generateTestResourceMetrics()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestResourceMetrics(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestResourceMetricsSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestResourceMetricsSlice()
	dest := NewResourceMetricsSlice()
	src := generateTestResourceMetricsSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestResourceMetricsSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestResourceMetricsSlice_CopyTo(t *testing.T) {
	dest := NewResourceMetricsSlice()
	// Test CopyTo to empty
	NewResourceMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, NewResourceMetricsSlice(), dest)

	// Test CopyTo larger slice
	generateTestResourceMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)

	// Test CopyTo same size slice
	generateTestResourceMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestResourceMetricsSlice(), dest)
}

func TestResourceMetricsSlice_Resize(t *testing.T) {
	es := generateTestResourceMetricsSlice()
	emptyVal := NewResourceMetrics()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.ResourceMetrics]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.ResourceMetrics]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.ResourceMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.ResourceMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestResourceMetricsSlice_Append(t *testing.T) {
	es := generateTestResourceMetricsSlice()

	emptyVal := NewResourceMetrics()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewResourceMetrics()
	fillTestResourceMetrics(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestResourceMetrics_CopyTo(t *testing.T) {
	ms := NewResourceMetrics()
	generateTestResourceMetrics().CopyTo(ms)
	assert.EqualValues(t, generateTestResourceMetrics(), ms)
}

func TestResourceMetrics_Resource(t *testing.T) {
	ms := NewResourceMetrics()
	fillTestResource(ms.Resource())
	assert.EqualValues(t, generateTestResource(), ms.Resource())
}

func TestResourceMetrics_InstrumentationLibraryMetrics(t *testing.T) {
	ms := NewResourceMetrics()
	assert.EqualValues(t, NewInstrumentationLibraryMetricsSlice(), ms.InstrumentationLibraryMetrics())
	fillTestInstrumentationLibraryMetricsSlice(ms.InstrumentationLibraryMetrics())
	testValInstrumentationLibraryMetrics := generateTestInstrumentationLibraryMetricsSlice()
	assert.EqualValues(t, testValInstrumentationLibraryMetrics, ms.InstrumentationLibraryMetrics())
}

func TestInstrumentationLibraryMetricsSlice(t *testing.T) {
	es := NewInstrumentationLibraryMetricsSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newInstrumentationLibraryMetricsSlice(&[]*otlpmetrics.InstrumentationLibraryMetrics{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewInstrumentationLibraryMetrics()
	testVal := generateTestInstrumentationLibraryMetrics()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestInstrumentationLibraryMetrics(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestInstrumentationLibraryMetricsSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestInstrumentationLibraryMetricsSlice()
	dest := NewInstrumentationLibraryMetricsSlice()
	src := generateTestInstrumentationLibraryMetricsSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestInstrumentationLibraryMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestInstrumentationLibraryMetricsSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestInstrumentationLibraryMetricsSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestInstrumentationLibraryMetricsSlice_CopyTo(t *testing.T) {
	dest := NewInstrumentationLibraryMetricsSlice()
	// Test CopyTo to empty
	NewInstrumentationLibraryMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, NewInstrumentationLibraryMetricsSlice(), dest)

	// Test CopyTo larger slice
	generateTestInstrumentationLibraryMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestInstrumentationLibraryMetricsSlice(), dest)

	// Test CopyTo same size slice
	generateTestInstrumentationLibraryMetricsSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestInstrumentationLibraryMetricsSlice(), dest)
}

func TestInstrumentationLibraryMetricsSlice_Resize(t *testing.T) {
	es := generateTestInstrumentationLibraryMetricsSlice()
	emptyVal := NewInstrumentationLibraryMetrics()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.InstrumentationLibraryMetrics]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.InstrumentationLibraryMetrics]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.InstrumentationLibraryMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.InstrumentationLibraryMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestInstrumentationLibraryMetricsSlice_Append(t *testing.T) {
	es := generateTestInstrumentationLibraryMetricsSlice()

	emptyVal := NewInstrumentationLibraryMetrics()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewInstrumentationLibraryMetrics()
	fillTestInstrumentationLibraryMetrics(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestInstrumentationLibraryMetrics_CopyTo(t *testing.T) {
	ms := NewInstrumentationLibraryMetrics()
	generateTestInstrumentationLibraryMetrics().CopyTo(ms)
	assert.EqualValues(t, generateTestInstrumentationLibraryMetrics(), ms)
}

func TestInstrumentationLibraryMetrics_InstrumentationLibrary(t *testing.T) {
	ms := NewInstrumentationLibraryMetrics()
	fillTestInstrumentationLibrary(ms.InstrumentationLibrary())
	assert.EqualValues(t, generateTestInstrumentationLibrary(), ms.InstrumentationLibrary())
}

func TestInstrumentationLibraryMetrics_Metrics(t *testing.T) {
	ms := NewInstrumentationLibraryMetrics()
	assert.EqualValues(t, NewMetricSlice(), ms.Metrics())
	fillTestMetricSlice(ms.Metrics())
	testValMetrics := generateTestMetricSlice()
	assert.EqualValues(t, testValMetrics, ms.Metrics())
}

func TestMetricSlice(t *testing.T) {
	es := NewMetricSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newMetricSlice(&[]*otlpmetrics.Metric{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewMetric()
	testVal := generateTestMetric()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestMetric(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestMetricSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestMetricSlice()
	dest := NewMetricSlice()
	src := generateTestMetricSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestMetricSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestMetricSlice_CopyTo(t *testing.T) {
	dest := NewMetricSlice()
	// Test CopyTo to empty
	NewMetricSlice().CopyTo(dest)
	assert.EqualValues(t, NewMetricSlice(), dest)

	// Test CopyTo larger slice
	generateTestMetricSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)

	// Test CopyTo same size slice
	generateTestMetricSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestMetricSlice(), dest)
}

func TestMetricSlice_Resize(t *testing.T) {
	es := generateTestMetricSlice()
	emptyVal := NewMetric()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.Metric]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.Metric]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.Metric]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.Metric]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestMetricSlice_Append(t *testing.T) {
	es := generateTestMetricSlice()

	emptyVal := NewMetric()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewMetric()
	fillTestMetric(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestMetric_CopyTo(t *testing.T) {
	ms := NewMetric()
	generateTestMetric().CopyTo(ms)
	assert.EqualValues(t, generateTestMetric(), ms)
}

func TestMetric_Name(t *testing.T) {
	ms := NewMetric()
	assert.EqualValues(t, "", ms.Name())
	testValName := "test_name"
	ms.SetName(testValName)
	assert.EqualValues(t, testValName, ms.Name())
}

func TestMetric_Description(t *testing.T) {
	ms := NewMetric()
	assert.EqualValues(t, "", ms.Description())
	testValDescription := "test_description"
	ms.SetDescription(testValDescription)
	assert.EqualValues(t, testValDescription, ms.Description())
}

func TestMetric_Unit(t *testing.T) {
	ms := NewMetric()
	assert.EqualValues(t, "", ms.Unit())
	testValUnit := "1"
	ms.SetUnit(testValUnit)
	assert.EqualValues(t, testValUnit, ms.Unit())
}

func TestIntGauge_CopyTo(t *testing.T) {
	ms := NewIntGauge()
	generateTestIntGauge().CopyTo(ms)
	assert.EqualValues(t, generateTestIntGauge(), ms)
}

func TestIntGauge_DataPoints(t *testing.T) {
	ms := NewIntGauge()
	assert.EqualValues(t, NewIntDataPointSlice(), ms.DataPoints())
	fillTestIntDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestIntDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestDoubleGauge_CopyTo(t *testing.T) {
	ms := NewDoubleGauge()
	generateTestDoubleGauge().CopyTo(ms)
	assert.EqualValues(t, generateTestDoubleGauge(), ms)
}

func TestDoubleGauge_DataPoints(t *testing.T) {
	ms := NewDoubleGauge()
	assert.EqualValues(t, NewDoubleDataPointSlice(), ms.DataPoints())
	fillTestDoubleDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestDoubleDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestIntSum_CopyTo(t *testing.T) {
	ms := NewIntSum()
	generateTestIntSum().CopyTo(ms)
	assert.EqualValues(t, generateTestIntSum(), ms)
}

func TestIntSum_AggregationTemporality(t *testing.T) {
	ms := NewIntSum()
	assert.EqualValues(t, AggregationTemporalityUnspecified, ms.AggregationTemporality())
	testValAggregationTemporality := AggregationTemporalityCumulative
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.EqualValues(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestIntSum_IsMonotonic(t *testing.T) {
	ms := NewIntSum()
	assert.EqualValues(t, false, ms.IsMonotonic())
	testValIsMonotonic := true
	ms.SetIsMonotonic(testValIsMonotonic)
	assert.EqualValues(t, testValIsMonotonic, ms.IsMonotonic())
}

func TestIntSum_DataPoints(t *testing.T) {
	ms := NewIntSum()
	assert.EqualValues(t, NewIntDataPointSlice(), ms.DataPoints())
	fillTestIntDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestIntDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestDoubleSum_CopyTo(t *testing.T) {
	ms := NewDoubleSum()
	generateTestDoubleSum().CopyTo(ms)
	assert.EqualValues(t, generateTestDoubleSum(), ms)
}

func TestDoubleSum_AggregationTemporality(t *testing.T) {
	ms := NewDoubleSum()
	assert.EqualValues(t, AggregationTemporalityUnspecified, ms.AggregationTemporality())
	testValAggregationTemporality := AggregationTemporalityCumulative
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.EqualValues(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestDoubleSum_IsMonotonic(t *testing.T) {
	ms := NewDoubleSum()
	assert.EqualValues(t, false, ms.IsMonotonic())
	testValIsMonotonic := true
	ms.SetIsMonotonic(testValIsMonotonic)
	assert.EqualValues(t, testValIsMonotonic, ms.IsMonotonic())
}

func TestDoubleSum_DataPoints(t *testing.T) {
	ms := NewDoubleSum()
	assert.EqualValues(t, NewDoubleDataPointSlice(), ms.DataPoints())
	fillTestDoubleDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestDoubleDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestIntHistogram_CopyTo(t *testing.T) {
	ms := NewIntHistogram()
	generateTestIntHistogram().CopyTo(ms)
	assert.EqualValues(t, generateTestIntHistogram(), ms)
}

func TestIntHistogram_AggregationTemporality(t *testing.T) {
	ms := NewIntHistogram()
	assert.EqualValues(t, AggregationTemporalityUnspecified, ms.AggregationTemporality())
	testValAggregationTemporality := AggregationTemporalityCumulative
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.EqualValues(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestIntHistogram_DataPoints(t *testing.T) {
	ms := NewIntHistogram()
	assert.EqualValues(t, NewIntHistogramDataPointSlice(), ms.DataPoints())
	fillTestIntHistogramDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestIntHistogramDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestHistogram_CopyTo(t *testing.T) {
	ms := NewHistogram()
	generateTestHistogram().CopyTo(ms)
	assert.EqualValues(t, generateTestHistogram(), ms)
}

func TestHistogram_AggregationTemporality(t *testing.T) {
	ms := NewHistogram()
	assert.EqualValues(t, AggregationTemporalityUnspecified, ms.AggregationTemporality())
	testValAggregationTemporality := AggregationTemporalityCumulative
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.EqualValues(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestHistogram_DataPoints(t *testing.T) {
	ms := NewHistogram()
	assert.EqualValues(t, NewHistogramDataPointSlice(), ms.DataPoints())
	fillTestHistogramDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestHistogramDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestSummary_CopyTo(t *testing.T) {
	ms := NewSummary()
	generateTestSummary().CopyTo(ms)
	assert.EqualValues(t, generateTestSummary(), ms)
}

func TestSummary_DataPoints(t *testing.T) {
	ms := NewSummary()
	assert.EqualValues(t, NewSummaryDataPointSlice(), ms.DataPoints())
	fillTestSummaryDataPointSlice(ms.DataPoints())
	testValDataPoints := generateTestSummaryDataPointSlice()
	assert.EqualValues(t, testValDataPoints, ms.DataPoints())
}

func TestIntDataPointSlice(t *testing.T) {
	es := NewIntDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newIntDataPointSlice(&[]*otlpmetrics.IntDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewIntDataPoint()
	testVal := generateTestIntDataPoint()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestIntDataPoint(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestIntDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestIntDataPointSlice()
	dest := NewIntDataPointSlice()
	src := generateTestIntDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestIntDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestIntDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestIntDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestIntDataPointSlice_CopyTo(t *testing.T) {
	dest := NewIntDataPointSlice()
	// Test CopyTo to empty
	NewIntDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewIntDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestIntDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestIntDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestIntDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestIntDataPointSlice(), dest)
}

func TestIntDataPointSlice_Resize(t *testing.T) {
	es := generateTestIntDataPointSlice()
	emptyVal := NewIntDataPoint()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.IntDataPoint]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.IntDataPoint]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.IntDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.IntDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestIntDataPointSlice_Append(t *testing.T) {
	es := generateTestIntDataPointSlice()

	emptyVal := NewIntDataPoint()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewIntDataPoint()
	fillTestIntDataPoint(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestIntDataPoint_CopyTo(t *testing.T) {
	ms := NewIntDataPoint()
	generateTestIntDataPoint().CopyTo(ms)
	assert.EqualValues(t, generateTestIntDataPoint(), ms)
}

func TestIntDataPoint_LabelsMap(t *testing.T) {
	ms := NewIntDataPoint()
	assert.EqualValues(t, NewStringMap(), ms.LabelsMap())
	fillTestStringMap(ms.LabelsMap())
	testValLabelsMap := generateTestStringMap()
	assert.EqualValues(t, testValLabelsMap, ms.LabelsMap())
}

func TestIntDataPoint_StartTimestamp(t *testing.T) {
	ms := NewIntDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.EqualValues(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestIntDataPoint_Timestamp(t *testing.T) {
	ms := NewIntDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestIntDataPoint_Value(t *testing.T) {
	ms := NewIntDataPoint()
	assert.EqualValues(t, int64(0), ms.Value())
	testValValue := int64(-17)
	ms.SetValue(testValValue)
	assert.EqualValues(t, testValValue, ms.Value())
}

func TestIntDataPoint_Exemplars(t *testing.T) {
	ms := NewIntDataPoint()
	assert.EqualValues(t, NewIntExemplarSlice(), ms.Exemplars())
	fillTestIntExemplarSlice(ms.Exemplars())
	testValExemplars := generateTestIntExemplarSlice()
	assert.EqualValues(t, testValExemplars, ms.Exemplars())
}

func TestDoubleDataPointSlice(t *testing.T) {
	es := NewDoubleDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newDoubleDataPointSlice(&[]*otlpmetrics.DoubleDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewDoubleDataPoint()
	testVal := generateTestDoubleDataPoint()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestDoubleDataPoint(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestDoubleDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestDoubleDataPointSlice()
	dest := NewDoubleDataPointSlice()
	src := generateTestDoubleDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestDoubleDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestDoubleDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestDoubleDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestDoubleDataPointSlice_CopyTo(t *testing.T) {
	dest := NewDoubleDataPointSlice()
	// Test CopyTo to empty
	NewDoubleDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewDoubleDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestDoubleDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestDoubleDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestDoubleDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestDoubleDataPointSlice(), dest)
}

func TestDoubleDataPointSlice_Resize(t *testing.T) {
	es := generateTestDoubleDataPointSlice()
	emptyVal := NewDoubleDataPoint()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.DoubleDataPoint]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.DoubleDataPoint]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.DoubleDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.DoubleDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestDoubleDataPointSlice_Append(t *testing.T) {
	es := generateTestDoubleDataPointSlice()

	emptyVal := NewDoubleDataPoint()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewDoubleDataPoint()
	fillTestDoubleDataPoint(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestDoubleDataPoint_CopyTo(t *testing.T) {
	ms := NewDoubleDataPoint()
	generateTestDoubleDataPoint().CopyTo(ms)
	assert.EqualValues(t, generateTestDoubleDataPoint(), ms)
}

func TestDoubleDataPoint_LabelsMap(t *testing.T) {
	ms := NewDoubleDataPoint()
	assert.EqualValues(t, NewStringMap(), ms.LabelsMap())
	fillTestStringMap(ms.LabelsMap())
	testValLabelsMap := generateTestStringMap()
	assert.EqualValues(t, testValLabelsMap, ms.LabelsMap())
}

func TestDoubleDataPoint_StartTimestamp(t *testing.T) {
	ms := NewDoubleDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.EqualValues(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestDoubleDataPoint_Timestamp(t *testing.T) {
	ms := NewDoubleDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestDoubleDataPoint_Value(t *testing.T) {
	ms := NewDoubleDataPoint()
	assert.EqualValues(t, float64(0.0), ms.Value())
	testValValue := float64(17.13)
	ms.SetValue(testValValue)
	assert.EqualValues(t, testValValue, ms.Value())
}

func TestDoubleDataPoint_Exemplars(t *testing.T) {
	ms := NewDoubleDataPoint()
	assert.EqualValues(t, NewExemplarSlice(), ms.Exemplars())
	fillTestExemplarSlice(ms.Exemplars())
	testValExemplars := generateTestExemplarSlice()
	assert.EqualValues(t, testValExemplars, ms.Exemplars())
}

func TestIntHistogramDataPointSlice(t *testing.T) {
	es := NewIntHistogramDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newIntHistogramDataPointSlice(&[]*otlpmetrics.IntHistogramDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewIntHistogramDataPoint()
	testVal := generateTestIntHistogramDataPoint()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestIntHistogramDataPoint(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestIntHistogramDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestIntHistogramDataPointSlice()
	dest := NewIntHistogramDataPointSlice()
	src := generateTestIntHistogramDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestIntHistogramDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestIntHistogramDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestIntHistogramDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestIntHistogramDataPointSlice_CopyTo(t *testing.T) {
	dest := NewIntHistogramDataPointSlice()
	// Test CopyTo to empty
	NewIntHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewIntHistogramDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestIntHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestIntHistogramDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestIntHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestIntHistogramDataPointSlice(), dest)
}

func TestIntHistogramDataPointSlice_Resize(t *testing.T) {
	es := generateTestIntHistogramDataPointSlice()
	emptyVal := NewIntHistogramDataPoint()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.IntHistogramDataPoint]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.IntHistogramDataPoint]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.IntHistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.IntHistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestIntHistogramDataPointSlice_Append(t *testing.T) {
	es := generateTestIntHistogramDataPointSlice()

	emptyVal := NewIntHistogramDataPoint()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewIntHistogramDataPoint()
	fillTestIntHistogramDataPoint(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestIntHistogramDataPoint_CopyTo(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	generateTestIntHistogramDataPoint().CopyTo(ms)
	assert.EqualValues(t, generateTestIntHistogramDataPoint(), ms)
}

func TestIntHistogramDataPoint_LabelsMap(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, NewStringMap(), ms.LabelsMap())
	fillTestStringMap(ms.LabelsMap())
	testValLabelsMap := generateTestStringMap()
	assert.EqualValues(t, testValLabelsMap, ms.LabelsMap())
}

func TestIntHistogramDataPoint_StartTimestamp(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.EqualValues(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestIntHistogramDataPoint_Timestamp(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestIntHistogramDataPoint_Count(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, uint64(0), ms.Count())
	testValCount := uint64(17)
	ms.SetCount(testValCount)
	assert.EqualValues(t, testValCount, ms.Count())
}

func TestIntHistogramDataPoint_Sum(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, int64(0.0), ms.Sum())
	testValSum := int64(1713)
	ms.SetSum(testValSum)
	assert.EqualValues(t, testValSum, ms.Sum())
}

func TestIntHistogramDataPoint_BucketCounts(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, []uint64(nil), ms.BucketCounts())
	testValBucketCounts := []uint64{1, 2, 3}
	ms.SetBucketCounts(testValBucketCounts)
	assert.EqualValues(t, testValBucketCounts, ms.BucketCounts())
}

func TestIntHistogramDataPoint_ExplicitBounds(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, []float64(nil), ms.ExplicitBounds())
	testValExplicitBounds := []float64{1, 2, 3}
	ms.SetExplicitBounds(testValExplicitBounds)
	assert.EqualValues(t, testValExplicitBounds, ms.ExplicitBounds())
}

func TestIntHistogramDataPoint_Exemplars(t *testing.T) {
	ms := NewIntHistogramDataPoint()
	assert.EqualValues(t, NewIntExemplarSlice(), ms.Exemplars())
	fillTestIntExemplarSlice(ms.Exemplars())
	testValExemplars := generateTestIntExemplarSlice()
	assert.EqualValues(t, testValExemplars, ms.Exemplars())
}

func TestHistogramDataPointSlice(t *testing.T) {
	es := NewHistogramDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newHistogramDataPointSlice(&[]*otlpmetrics.DoubleHistogramDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewHistogramDataPoint()
	testVal := generateTestHistogramDataPoint()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestHistogramDataPoint(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestHistogramDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestHistogramDataPointSlice()
	dest := NewHistogramDataPointSlice()
	src := generateTestHistogramDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestHistogramDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestHistogramDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestHistogramDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestHistogramDataPointSlice_CopyTo(t *testing.T) {
	dest := NewHistogramDataPointSlice()
	// Test CopyTo to empty
	NewHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewHistogramDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestHistogramDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestHistogramDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestHistogramDataPointSlice(), dest)
}

func TestHistogramDataPointSlice_Resize(t *testing.T) {
	es := generateTestHistogramDataPointSlice()
	emptyVal := NewHistogramDataPoint()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.DoubleHistogramDataPoint]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.DoubleHistogramDataPoint]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.DoubleHistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.DoubleHistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestHistogramDataPointSlice_Append(t *testing.T) {
	es := generateTestHistogramDataPointSlice()

	emptyVal := NewHistogramDataPoint()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewHistogramDataPoint()
	fillTestHistogramDataPoint(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestHistogramDataPoint_CopyTo(t *testing.T) {
	ms := NewHistogramDataPoint()
	generateTestHistogramDataPoint().CopyTo(ms)
	assert.EqualValues(t, generateTestHistogramDataPoint(), ms)
}

func TestHistogramDataPoint_LabelsMap(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, NewStringMap(), ms.LabelsMap())
	fillTestStringMap(ms.LabelsMap())
	testValLabelsMap := generateTestStringMap()
	assert.EqualValues(t, testValLabelsMap, ms.LabelsMap())
}

func TestHistogramDataPoint_StartTimestamp(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.EqualValues(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestHistogramDataPoint_Timestamp(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestHistogramDataPoint_Count(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, uint64(0), ms.Count())
	testValCount := uint64(17)
	ms.SetCount(testValCount)
	assert.EqualValues(t, testValCount, ms.Count())
}

func TestHistogramDataPoint_Sum(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, float64(0.0), ms.Sum())
	testValSum := float64(17.13)
	ms.SetSum(testValSum)
	assert.EqualValues(t, testValSum, ms.Sum())
}

func TestHistogramDataPoint_BucketCounts(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, []uint64(nil), ms.BucketCounts())
	testValBucketCounts := []uint64{1, 2, 3}
	ms.SetBucketCounts(testValBucketCounts)
	assert.EqualValues(t, testValBucketCounts, ms.BucketCounts())
}

func TestHistogramDataPoint_ExplicitBounds(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, []float64(nil), ms.ExplicitBounds())
	testValExplicitBounds := []float64{1, 2, 3}
	ms.SetExplicitBounds(testValExplicitBounds)
	assert.EqualValues(t, testValExplicitBounds, ms.ExplicitBounds())
}

func TestHistogramDataPoint_Exemplars(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.EqualValues(t, NewExemplarSlice(), ms.Exemplars())
	fillTestExemplarSlice(ms.Exemplars())
	testValExemplars := generateTestExemplarSlice()
	assert.EqualValues(t, testValExemplars, ms.Exemplars())
}

func TestSummaryDataPointSlice(t *testing.T) {
	es := NewSummaryDataPointSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newSummaryDataPointSlice(&[]*otlpmetrics.DoubleSummaryDataPoint{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewSummaryDataPoint()
	testVal := generateTestSummaryDataPoint()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestSummaryDataPoint(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestSummaryDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestSummaryDataPointSlice()
	dest := NewSummaryDataPointSlice()
	src := generateTestSummaryDataPointSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestSummaryDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestSummaryDataPointSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestSummaryDataPointSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestSummaryDataPointSlice_CopyTo(t *testing.T) {
	dest := NewSummaryDataPointSlice()
	// Test CopyTo to empty
	NewSummaryDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, NewSummaryDataPointSlice(), dest)

	// Test CopyTo larger slice
	generateTestSummaryDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestSummaryDataPointSlice(), dest)

	// Test CopyTo same size slice
	generateTestSummaryDataPointSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestSummaryDataPointSlice(), dest)
}

func TestSummaryDataPointSlice_Resize(t *testing.T) {
	es := generateTestSummaryDataPointSlice()
	emptyVal := NewSummaryDataPoint()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.DoubleSummaryDataPoint]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.DoubleSummaryDataPoint]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.DoubleSummaryDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.DoubleSummaryDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestSummaryDataPointSlice_Append(t *testing.T) {
	es := generateTestSummaryDataPointSlice()

	emptyVal := NewSummaryDataPoint()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewSummaryDataPoint()
	fillTestSummaryDataPoint(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestSummaryDataPoint_CopyTo(t *testing.T) {
	ms := NewSummaryDataPoint()
	generateTestSummaryDataPoint().CopyTo(ms)
	assert.EqualValues(t, generateTestSummaryDataPoint(), ms)
}

func TestSummaryDataPoint_LabelsMap(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, NewStringMap(), ms.LabelsMap())
	fillTestStringMap(ms.LabelsMap())
	testValLabelsMap := generateTestStringMap()
	assert.EqualValues(t, testValLabelsMap, ms.LabelsMap())
}

func TestSummaryDataPoint_StartTimestamp(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.EqualValues(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestSummaryDataPoint_Timestamp(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestSummaryDataPoint_Count(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, uint64(0), ms.Count())
	testValCount := uint64(17)
	ms.SetCount(testValCount)
	assert.EqualValues(t, testValCount, ms.Count())
}

func TestSummaryDataPoint_Sum(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, float64(0.0), ms.Sum())
	testValSum := float64(17.13)
	ms.SetSum(testValSum)
	assert.EqualValues(t, testValSum, ms.Sum())
}

func TestSummaryDataPoint_QuantileValues(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.EqualValues(t, NewValueAtQuantileSlice(), ms.QuantileValues())
	fillTestValueAtQuantileSlice(ms.QuantileValues())
	testValQuantileValues := generateTestValueAtQuantileSlice()
	assert.EqualValues(t, testValQuantileValues, ms.QuantileValues())
}

func TestValueAtQuantileSlice(t *testing.T) {
	es := NewValueAtQuantileSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newValueAtQuantileSlice(&[]*otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewValueAtQuantile()
	testVal := generateTestValueAtQuantile()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestValueAtQuantile(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestValueAtQuantileSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestValueAtQuantileSlice()
	dest := NewValueAtQuantileSlice()
	src := generateTestValueAtQuantileSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestValueAtQuantileSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestValueAtQuantileSlice_CopyTo(t *testing.T) {
	dest := NewValueAtQuantileSlice()
	// Test CopyTo to empty
	NewValueAtQuantileSlice().CopyTo(dest)
	assert.EqualValues(t, NewValueAtQuantileSlice(), dest)

	// Test CopyTo larger slice
	generateTestValueAtQuantileSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)

	// Test CopyTo same size slice
	generateTestValueAtQuantileSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestValueAtQuantileSlice(), dest)
}

func TestValueAtQuantileSlice_Resize(t *testing.T) {
	es := generateTestValueAtQuantileSlice()
	emptyVal := NewValueAtQuantile()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.DoubleSummaryDataPoint_ValueAtQuantile]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestValueAtQuantileSlice_Append(t *testing.T) {
	es := generateTestValueAtQuantileSlice()

	emptyVal := NewValueAtQuantile()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal.orig, es.At(7).orig)

	value := NewValueAtQuantile()
	fillTestValueAtQuantile(value)
	es.Append(value)
	assert.EqualValues(t, value.orig, es.At(8).orig)

	assert.Equal(t, 9, es.Len())
}

func TestValueAtQuantile_CopyTo(t *testing.T) {
	ms := NewValueAtQuantile()
	generateTestValueAtQuantile().CopyTo(ms)
	assert.EqualValues(t, generateTestValueAtQuantile(), ms)
}

func TestValueAtQuantile_Quantile(t *testing.T) {
	ms := NewValueAtQuantile()
	assert.EqualValues(t, float64(0.0), ms.Quantile())
	testValQuantile := float64(17.13)
	ms.SetQuantile(testValQuantile)
	assert.EqualValues(t, testValQuantile, ms.Quantile())
}

func TestValueAtQuantile_Value(t *testing.T) {
	ms := NewValueAtQuantile()
	assert.EqualValues(t, float64(0.0), ms.Value())
	testValValue := float64(17.13)
	ms.SetValue(testValValue)
	assert.EqualValues(t, testValValue, ms.Value())
}

func TestIntExemplarSlice(t *testing.T) {
	es := NewIntExemplarSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newIntExemplarSlice(&[]otlpmetrics.IntExemplar{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewIntExemplar()
	testVal := generateTestIntExemplar()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestIntExemplar(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestIntExemplarSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestIntExemplarSlice()
	dest := NewIntExemplarSlice()
	src := generateTestIntExemplarSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestIntExemplarSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestIntExemplarSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestIntExemplarSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestIntExemplarSlice_CopyTo(t *testing.T) {
	dest := NewIntExemplarSlice()
	// Test CopyTo to empty
	NewIntExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, NewIntExemplarSlice(), dest)

	// Test CopyTo larger slice
	generateTestIntExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestIntExemplarSlice(), dest)

	// Test CopyTo same size slice
	generateTestIntExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestIntExemplarSlice(), dest)
}

func TestIntExemplarSlice_Resize(t *testing.T) {
	es := generateTestIntExemplarSlice()
	emptyVal := NewIntExemplar()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.IntExemplar]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.IntExemplar]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.IntExemplar]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.IntExemplar]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestIntExemplarSlice_Append(t *testing.T) {
	es := generateTestIntExemplarSlice()

	emptyVal := NewIntExemplar()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal, es.At(7))

	value := NewIntExemplar()
	fillTestIntExemplar(value)
	es.Append(value)
	assert.EqualValues(t, value, es.At(8))

	assert.Equal(t, 9, es.Len())
}

func TestIntExemplar_CopyTo(t *testing.T) {
	ms := NewIntExemplar()
	generateTestIntExemplar().CopyTo(ms)
	assert.EqualValues(t, generateTestIntExemplar(), ms)
}

func TestIntExemplar_Timestamp(t *testing.T) {
	ms := NewIntExemplar()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestIntExemplar_Value(t *testing.T) {
	ms := NewIntExemplar()
	assert.EqualValues(t, int64(0), ms.Value())
	testValValue := int64(-17)
	ms.SetValue(testValValue)
	assert.EqualValues(t, testValValue, ms.Value())
}

func TestIntExemplar_FilteredLabels(t *testing.T) {
	ms := NewIntExemplar()
	assert.EqualValues(t, NewStringMap(), ms.FilteredLabels())
	fillTestStringMap(ms.FilteredLabels())
	testValFilteredLabels := generateTestStringMap()
	assert.EqualValues(t, testValFilteredLabels, ms.FilteredLabels())
}

func TestExemplarSlice(t *testing.T) {
	es := NewExemplarSlice()
	assert.EqualValues(t, 0, es.Len())
	es = newExemplarSlice(&[]otlpmetrics.DoubleExemplar{})
	assert.EqualValues(t, 0, es.Len())

	es.Resize(7)
	emptyVal := NewExemplar()
	testVal := generateTestExemplar()
	assert.EqualValues(t, 7, es.Len())
	for i := 0; i < es.Len(); i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
		fillTestExemplar(es.At(i))
		assert.EqualValues(t, testVal, es.At(i))
	}
}

func TestExemplarSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestExemplarSlice()
	dest := NewExemplarSlice()
	src := generateTestExemplarSlice()
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestExemplarSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.EqualValues(t, generateTestExemplarSlice(), dest)
	assert.EqualValues(t, 0, src.Len())
	assert.EqualValues(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestExemplarSlice().MoveAndAppendTo(dest)
	assert.EqualValues(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i))
		assert.EqualValues(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestExemplarSlice_CopyTo(t *testing.T) {
	dest := NewExemplarSlice()
	// Test CopyTo to empty
	NewExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, NewExemplarSlice(), dest)

	// Test CopyTo larger slice
	generateTestExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestExemplarSlice(), dest)

	// Test CopyTo same size slice
	generateTestExemplarSlice().CopyTo(dest)
	assert.EqualValues(t, generateTestExemplarSlice(), dest)
}

func TestExemplarSlice_Resize(t *testing.T) {
	es := generateTestExemplarSlice()
	emptyVal := NewExemplar()
	// Test Resize less elements.
	const resizeSmallLen = 4
	expectedEs := make(map[*otlpmetrics.DoubleExemplar]bool, resizeSmallLen)
	for i := 0; i < resizeSmallLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, resizeSmallLen, len(expectedEs))
	es.Resize(resizeSmallLen)
	assert.Equal(t, resizeSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.DoubleExemplar]bool, resizeSmallLen)
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)

	// Test Resize more elements.
	const resizeLargeLen = 7
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.DoubleExemplar]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).orig] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.Resize(resizeLargeLen)
	assert.Equal(t, resizeLargeLen, es.Len())
	foundEs = make(map[*otlpmetrics.DoubleExemplar]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).orig] = true
	}
	assert.EqualValues(t, expectedEs, foundEs)
	for i := oldLen; i < resizeLargeLen; i++ {
		assert.EqualValues(t, emptyVal, es.At(i))
	}

	// Test Resize 0 elements.
	es.Resize(0)
	assert.Equal(t, 0, es.Len())
}

func TestExemplarSlice_Append(t *testing.T) {
	es := generateTestExemplarSlice()

	emptyVal := NewExemplar()
	es.Append(emptyVal)
	assert.EqualValues(t, emptyVal, es.At(7))

	value := NewExemplar()
	fillTestExemplar(value)
	es.Append(value)
	assert.EqualValues(t, value, es.At(8))

	assert.Equal(t, 9, es.Len())
}

func TestExemplar_CopyTo(t *testing.T) {
	ms := NewExemplar()
	generateTestExemplar().CopyTo(ms)
	assert.EqualValues(t, generateTestExemplar(), ms)
}

func TestExemplar_Timestamp(t *testing.T) {
	ms := NewExemplar()
	assert.EqualValues(t, Timestamp(0), ms.Timestamp())
	testValTimestamp := Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.EqualValues(t, testValTimestamp, ms.Timestamp())
}

func TestExemplar_Value(t *testing.T) {
	ms := NewExemplar()
	assert.EqualValues(t, float64(0.0), ms.Value())
	testValValue := float64(17.13)
	ms.SetValue(testValValue)
	assert.EqualValues(t, testValValue, ms.Value())
}

func TestExemplar_FilteredLabels(t *testing.T) {
	ms := NewExemplar()
	assert.EqualValues(t, NewStringMap(), ms.FilteredLabels())
	fillTestStringMap(ms.FilteredLabels())
	testValFilteredLabels := generateTestStringMap()
	assert.EqualValues(t, testValFilteredLabels, ms.FilteredLabels())
}

func generateTestResourceMetricsSlice() ResourceMetricsSlice {
	tv := NewResourceMetricsSlice()
	fillTestResourceMetricsSlice(tv)
	return tv
}

func fillTestResourceMetricsSlice(tv ResourceMetricsSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestResourceMetrics(tv.At(i))
	}
}

func generateTestResourceMetrics() ResourceMetrics {
	tv := NewResourceMetrics()
	fillTestResourceMetrics(tv)
	return tv
}

func fillTestResourceMetrics(tv ResourceMetrics) {
	fillTestResource(tv.Resource())
	fillTestInstrumentationLibraryMetricsSlice(tv.InstrumentationLibraryMetrics())
}

func generateTestInstrumentationLibraryMetricsSlice() InstrumentationLibraryMetricsSlice {
	tv := NewInstrumentationLibraryMetricsSlice()
	fillTestInstrumentationLibraryMetricsSlice(tv)
	return tv
}

func fillTestInstrumentationLibraryMetricsSlice(tv InstrumentationLibraryMetricsSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestInstrumentationLibraryMetrics(tv.At(i))
	}
}

func generateTestInstrumentationLibraryMetrics() InstrumentationLibraryMetrics {
	tv := NewInstrumentationLibraryMetrics()
	fillTestInstrumentationLibraryMetrics(tv)
	return tv
}

func fillTestInstrumentationLibraryMetrics(tv InstrumentationLibraryMetrics) {
	fillTestInstrumentationLibrary(tv.InstrumentationLibrary())
	fillTestMetricSlice(tv.Metrics())
}

func generateTestMetricSlice() MetricSlice {
	tv := NewMetricSlice()
	fillTestMetricSlice(tv)
	return tv
}

func fillTestMetricSlice(tv MetricSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestMetric(tv.At(i))
	}
}

func generateTestMetric() Metric {
	tv := NewMetric()
	fillTestMetric(tv)
	return tv
}

func fillTestMetric(tv Metric) {
	tv.SetName("test_name")
	tv.SetDescription("test_description")
	tv.SetUnit("1")
	(*tv.orig).Data = &otlpmetrics.Metric_IntGauge{IntGauge: &otlpmetrics.IntGauge{}}
	fillTestIntGauge(tv.IntGauge())
}

func generateTestIntGauge() IntGauge {
	tv := NewIntGauge()
	fillTestIntGauge(tv)
	return tv
}

func fillTestIntGauge(tv IntGauge) {
	fillTestIntDataPointSlice(tv.DataPoints())
}

func generateTestDoubleGauge() DoubleGauge {
	tv := NewDoubleGauge()
	fillTestDoubleGauge(tv)
	return tv
}

func fillTestDoubleGauge(tv DoubleGauge) {
	fillTestDoubleDataPointSlice(tv.DataPoints())
}

func generateTestIntSum() IntSum {
	tv := NewIntSum()
	fillTestIntSum(tv)
	return tv
}

func fillTestIntSum(tv IntSum) {
	tv.SetAggregationTemporality(AggregationTemporalityCumulative)
	tv.SetIsMonotonic(true)
	fillTestIntDataPointSlice(tv.DataPoints())
}

func generateTestDoubleSum() DoubleSum {
	tv := NewDoubleSum()
	fillTestDoubleSum(tv)
	return tv
}

func fillTestDoubleSum(tv DoubleSum) {
	tv.SetAggregationTemporality(AggregationTemporalityCumulative)
	tv.SetIsMonotonic(true)
	fillTestDoubleDataPointSlice(tv.DataPoints())
}

func generateTestIntHistogram() IntHistogram {
	tv := NewIntHistogram()
	fillTestIntHistogram(tv)
	return tv
}

func fillTestIntHistogram(tv IntHistogram) {
	tv.SetAggregationTemporality(AggregationTemporalityCumulative)
	fillTestIntHistogramDataPointSlice(tv.DataPoints())
}

func generateTestHistogram() Histogram {
	tv := NewHistogram()
	fillTestHistogram(tv)
	return tv
}

func fillTestHistogram(tv Histogram) {
	tv.SetAggregationTemporality(AggregationTemporalityCumulative)
	fillTestHistogramDataPointSlice(tv.DataPoints())
}

func generateTestSummary() Summary {
	tv := NewSummary()
	fillTestSummary(tv)
	return tv
}

func fillTestSummary(tv Summary) {
	fillTestSummaryDataPointSlice(tv.DataPoints())
}

func generateTestIntDataPointSlice() IntDataPointSlice {
	tv := NewIntDataPointSlice()
	fillTestIntDataPointSlice(tv)
	return tv
}

func fillTestIntDataPointSlice(tv IntDataPointSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestIntDataPoint(tv.At(i))
	}
}

func generateTestIntDataPoint() IntDataPoint {
	tv := NewIntDataPoint()
	fillTestIntDataPoint(tv)
	return tv
}

func fillTestIntDataPoint(tv IntDataPoint) {
	fillTestStringMap(tv.LabelsMap())
	tv.SetStartTimestamp(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetValue(int64(-17))
	fillTestIntExemplarSlice(tv.Exemplars())
}

func generateTestDoubleDataPointSlice() DoubleDataPointSlice {
	tv := NewDoubleDataPointSlice()
	fillTestDoubleDataPointSlice(tv)
	return tv
}

func fillTestDoubleDataPointSlice(tv DoubleDataPointSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestDoubleDataPoint(tv.At(i))
	}
}

func generateTestDoubleDataPoint() DoubleDataPoint {
	tv := NewDoubleDataPoint()
	fillTestDoubleDataPoint(tv)
	return tv
}

func fillTestDoubleDataPoint(tv DoubleDataPoint) {
	fillTestStringMap(tv.LabelsMap())
	tv.SetStartTimestamp(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetValue(float64(17.13))
	fillTestExemplarSlice(tv.Exemplars())
}

func generateTestIntHistogramDataPointSlice() IntHistogramDataPointSlice {
	tv := NewIntHistogramDataPointSlice()
	fillTestIntHistogramDataPointSlice(tv)
	return tv
}

func fillTestIntHistogramDataPointSlice(tv IntHistogramDataPointSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestIntHistogramDataPoint(tv.At(i))
	}
}

func generateTestIntHistogramDataPoint() IntHistogramDataPoint {
	tv := NewIntHistogramDataPoint()
	fillTestIntHistogramDataPoint(tv)
	return tv
}

func fillTestIntHistogramDataPoint(tv IntHistogramDataPoint) {
	fillTestStringMap(tv.LabelsMap())
	tv.SetStartTimestamp(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetCount(uint64(17))
	tv.SetSum(int64(1713))
	tv.SetBucketCounts([]uint64{1, 2, 3})
	tv.SetExplicitBounds([]float64{1, 2, 3})
	fillTestIntExemplarSlice(tv.Exemplars())
}

func generateTestHistogramDataPointSlice() HistogramDataPointSlice {
	tv := NewHistogramDataPointSlice()
	fillTestHistogramDataPointSlice(tv)
	return tv
}

func fillTestHistogramDataPointSlice(tv HistogramDataPointSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestHistogramDataPoint(tv.At(i))
	}
}

func generateTestHistogramDataPoint() HistogramDataPoint {
	tv := NewHistogramDataPoint()
	fillTestHistogramDataPoint(tv)
	return tv
}

func fillTestHistogramDataPoint(tv HistogramDataPoint) {
	fillTestStringMap(tv.LabelsMap())
	tv.SetStartTimestamp(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetCount(uint64(17))
	tv.SetSum(float64(17.13))
	tv.SetBucketCounts([]uint64{1, 2, 3})
	tv.SetExplicitBounds([]float64{1, 2, 3})
	fillTestExemplarSlice(tv.Exemplars())
}

func generateTestSummaryDataPointSlice() SummaryDataPointSlice {
	tv := NewSummaryDataPointSlice()
	fillTestSummaryDataPointSlice(tv)
	return tv
}

func fillTestSummaryDataPointSlice(tv SummaryDataPointSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestSummaryDataPoint(tv.At(i))
	}
}

func generateTestSummaryDataPoint() SummaryDataPoint {
	tv := NewSummaryDataPoint()
	fillTestSummaryDataPoint(tv)
	return tv
}

func fillTestSummaryDataPoint(tv SummaryDataPoint) {
	fillTestStringMap(tv.LabelsMap())
	tv.SetStartTimestamp(Timestamp(1234567890))
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetCount(uint64(17))
	tv.SetSum(float64(17.13))
	fillTestValueAtQuantileSlice(tv.QuantileValues())
}

func generateTestValueAtQuantileSlice() ValueAtQuantileSlice {
	tv := NewValueAtQuantileSlice()
	fillTestValueAtQuantileSlice(tv)
	return tv
}

func fillTestValueAtQuantileSlice(tv ValueAtQuantileSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestValueAtQuantile(tv.At(i))
	}
}

func generateTestValueAtQuantile() ValueAtQuantile {
	tv := NewValueAtQuantile()
	fillTestValueAtQuantile(tv)
	return tv
}

func fillTestValueAtQuantile(tv ValueAtQuantile) {
	tv.SetQuantile(float64(17.13))
	tv.SetValue(float64(17.13))
}

func generateTestIntExemplarSlice() IntExemplarSlice {
	tv := NewIntExemplarSlice()
	fillTestIntExemplarSlice(tv)
	return tv
}

func fillTestIntExemplarSlice(tv IntExemplarSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestIntExemplar(tv.At(i))
	}
}

func generateTestIntExemplar() IntExemplar {
	tv := NewIntExemplar()
	fillTestIntExemplar(tv)
	return tv
}

func fillTestIntExemplar(tv IntExemplar) {
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetValue(int64(-17))
	fillTestStringMap(tv.FilteredLabels())
}

func generateTestExemplarSlice() ExemplarSlice {
	tv := NewExemplarSlice()
	fillTestExemplarSlice(tv)
	return tv
}

func fillTestExemplarSlice(tv ExemplarSlice) {
	tv.Resize(7)
	for i := 0; i < tv.Len(); i++ {
		fillTestExemplar(tv.At(i))
	}
}

func generateTestExemplar() Exemplar {
	tv := NewExemplar()
	fillTestExemplar(tv)
	return tv
}

func fillTestExemplar(tv Exemplar) {
	tv.SetTimestamp(Timestamp(1234567890))
	tv.SetValue(float64(17.13))
	fillTestStringMap(tv.FilteredLabels())
}
