# Fluent Forward Receiver

This receiver runs a TCP server that accepts events via the [Fluent Forward
protocol](https://github.com/fluent/fluentd/wiki/Forward-Protocol-Specification-v1).

This receiver:

 - Does **not** support TLS or the handshake portion of the Forward protocol.
 - Does support acknowledgments of events that have the `chunk` option, as per the spec.
 - Supports all three event types (message, forward, packed forward, including
   compressed packed forward)
 - Supports listening on a Unix domain socket by making the `listenAddress`
   option of the form `unix://<path to socket>`.
 - If using TCP, it will start a UDP server on the same port to deliver
   heartbeat echos, as per the spec.

Here is a basic example config that makes the receiver listen on all interfaces
on port 8006:

```yaml
receivers:
  fluentforward:
    endpoint: 0.0.0.0:8006
```


## Development

If you are working on this receiver and need to regenerate any of the message
pack autogenerated code, just run `go generate` on this package and its
subpackages.  You can get the `msgp` binary by just running `go get -u -t
github.com/tinylib/msgp`, and make sure the Go binary path is on your shell's
PATH.
