// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package ptrace

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestResourceSpans_MoveTo(t *testing.T) {
	ms := generateTestResourceSpans()
	dest := NewResourceSpans()
	ms.MoveTo(dest)
	assert.Equal(t, NewResourceSpans(), ms)
	assert.Equal(t, generateTestResourceSpans(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestResourceSpans(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newResourceSpans(internal.NewResourceSpans(), sharedState)) })
	assert.Panics(t, func() { newResourceSpans(internal.NewResourceSpans(), sharedState).MoveTo(dest) })
}

func TestResourceSpans_CopyTo(t *testing.T) {
	ms := NewResourceSpans()
	orig := NewResourceSpans()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestResourceSpans()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newResourceSpans(internal.NewResourceSpans(), sharedState)) })
}

func TestResourceSpans_Resource(t *testing.T) {
	ms := NewResourceSpans()
	assert.Equal(t, pcommon.NewResource(), ms.Resource())
	ms.orig.Resource = *internal.GenTestResource()
	assert.Equal(t, pcommon.Resource(internal.GenTestResourceWrapper()), ms.Resource())
}

func TestResourceSpans_ScopeSpans(t *testing.T) {
	ms := NewResourceSpans()
	assert.Equal(t, NewScopeSpansSlice(), ms.ScopeSpans())
	ms.orig.ScopeSpans = internal.GenTestScopeSpansPtrSlice()
	assert.Equal(t, generateTestScopeSpansSlice(), ms.ScopeSpans())
}

func TestResourceSpans_SchemaUrl(t *testing.T) {
	ms := NewResourceSpans()
	assert.Empty(t, ms.SchemaUrl())
	ms.SetSchemaUrl("test_schemaurl")
	assert.Equal(t, "test_schemaurl", ms.SchemaUrl())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newResourceSpans(internal.NewResourceSpans(), sharedState).SetSchemaUrl("test_schemaurl") })
}

func generateTestResourceSpans() ResourceSpans {
	return newResourceSpans(internal.GenTestResourceSpans(), internal.NewState())
}
