// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlptrace "go.opentelemetry.io/proto/slim/otlp/trace/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyResourceSpans(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceSpans() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewResourceSpans()
				CopyResourceSpans(dest, src)
				assert.Equal(t, src, dest)
				CopyResourceSpans(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyResourceSpansSlice(t *testing.T) {
	src := []ResourceSpans{}
	dest := []ResourceSpans{}
	// Test CopyTo empty
	dest = CopyResourceSpansSlice(dest, src)
	assert.Equal(t, []ResourceSpans{}, dest)

	// Test CopyTo larger slice
	src = GenTestResourceSpansSlice()
	dest = CopyResourceSpansSlice(dest, src)
	assert.Equal(t, GenTestResourceSpansSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyResourceSpansSlice(dest, src)
	assert.Equal(t, GenTestResourceSpansSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyResourceSpansSlice(dest, []ResourceSpans{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyResourceSpansSlice(dest, src)
	assert.Equal(t, GenTestResourceSpansSlice(), dest)
}

func TestCopyResourceSpansPtrSlice(t *testing.T) {
	src := []*ResourceSpans{}
	dest := []*ResourceSpans{}
	// Test CopyTo empty
	dest = CopyResourceSpansPtrSlice(dest, src)
	assert.Equal(t, []*ResourceSpans{}, dest)

	// Test CopyTo larger slice
	src = GenTestResourceSpansPtrSlice()
	dest = CopyResourceSpansPtrSlice(dest, src)
	assert.Equal(t, GenTestResourceSpansPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyResourceSpansPtrSlice(dest, src)
	assert.Equal(t, GenTestResourceSpansPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyResourceSpansPtrSlice(dest, []*ResourceSpans{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyResourceSpansPtrSlice(dest, src)
	assert.Equal(t, GenTestResourceSpansPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONResourceSpansUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewResourceSpans()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewResourceSpans(), dest)
}

func TestMarshalAndUnmarshalJSONResourceSpans(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceSpans() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewResourceSpans()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteResourceSpans(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoResourceSpansFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesResourceSpans() {
		t.Run(name, func(t *testing.T) {
			dest := NewResourceSpans()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoResourceSpansUnknown(t *testing.T) {
	dest := NewResourceSpans()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewResourceSpans(), dest)
}

func TestMarshalAndUnmarshalProtoResourceSpans(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceSpans() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewResourceSpans()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteResourceSpans(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufResourceSpans(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceSpans() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlptrace.ResourceSpans{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewResourceSpans()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesResourceSpans() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                        {0x02},
		"Resource/wrong_wire_type":             {0xc},
		"Resource/missing_value":               {0xa},
		"ScopeSpans/wrong_wire_type":           {0x14},
		"ScopeSpans/missing_value":             {0x12},
		"SchemaUrl/wrong_wire_type":            {0x1c},
		"SchemaUrl/missing_value":              {0x1a},
		"DeprecatedScopeSpans/wrong_wire_type": {0xc4, 0x3e},
		"DeprecatedScopeSpans/missing_value":   {0xc2, 0x3e},
	}
}

func genTestEncodingValuesResourceSpans() map[string]*ResourceSpans {
	return map[string]*ResourceSpans{
		"empty":                     NewResourceSpans(),
		"Resource/test":             {Resource: *GenTestResource()},
		"ScopeSpans/test":           {ScopeSpans: []*ScopeSpans{{}, GenTestScopeSpans()}},
		"SchemaUrl/test":            {SchemaUrl: "test_schemaurl"},
		"DeprecatedScopeSpans/test": {DeprecatedScopeSpans: []*ScopeSpans{{}, GenTestScopeSpans()}},
	}
}
