// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	"google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/types/known/emptypb"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyIPAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesIPAddr() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewIPAddr()
				CopyIPAddr(dest, src)
				assert.Equal(t, src, dest)
				CopyIPAddr(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyIPAddrSlice(t *testing.T) {
	src := []IPAddr{}
	dest := []IPAddr{}
	// Test CopyTo empty
	dest = CopyIPAddrSlice(dest, src)
	assert.Equal(t, []IPAddr{}, dest)

	// Test CopyTo larger slice
	src = GenTestIPAddrSlice()
	dest = CopyIPAddrSlice(dest, src)
	assert.Equal(t, GenTestIPAddrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyIPAddrSlice(dest, src)
	assert.Equal(t, GenTestIPAddrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyIPAddrSlice(dest, []IPAddr{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyIPAddrSlice(dest, src)
	assert.Equal(t, GenTestIPAddrSlice(), dest)
}

func TestCopyIPAddrPtrSlice(t *testing.T) {
	src := []*IPAddr{}
	dest := []*IPAddr{}
	// Test CopyTo empty
	dest = CopyIPAddrPtrSlice(dest, src)
	assert.Equal(t, []*IPAddr{}, dest)

	// Test CopyTo larger slice
	src = GenTestIPAddrPtrSlice()
	dest = CopyIPAddrPtrSlice(dest, src)
	assert.Equal(t, GenTestIPAddrPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyIPAddrPtrSlice(dest, src)
	assert.Equal(t, GenTestIPAddrPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyIPAddrPtrSlice(dest, []*IPAddr{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyIPAddrPtrSlice(dest, src)
	assert.Equal(t, GenTestIPAddrPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONIPAddrUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewIPAddr()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewIPAddr(), dest)
}

func TestMarshalAndUnmarshalJSONIPAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesIPAddr() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewIPAddr()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteIPAddr(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoIPAddrFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesIPAddr() {
		t.Run(name, func(t *testing.T) {
			dest := NewIPAddr()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoIPAddrUnknown(t *testing.T) {
	dest := NewIPAddr()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewIPAddr(), dest)
}

func TestMarshalAndUnmarshalProtoIPAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesIPAddr() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewIPAddr()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteIPAddr(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufIPAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesIPAddr() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &emptypb.Empty{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewIPAddr()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesIPAddr() map[string][]byte {
	return map[string][]byte{
		"invalid_field":        {0x02},
		"IP/wrong_wire_type":   {0xc},
		"IP/missing_value":     {0xa},
		"Zone/wrong_wire_type": {0x14},
		"Zone/missing_value":   {0x12},
	}
}

func genTestEncodingValuesIPAddr() map[string]*IPAddr {
	return map[string]*IPAddr{
		"empty":     NewIPAddr(),
		"IP/test":   {IP: []byte{1, 2, 3}},
		"Zone/test": {Zone: "test_zone"},
	}
}
