// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectorlogs "go.opentelemetry.io/proto/slim/otlp/collector/logs/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcollectorlogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/logs/v1"
	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportLogsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigExportLogsServiceRequest()
				CopyOrigExportLogsServiceRequest(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigExportLogsServiceRequest(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigExportLogsServiceRequestUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigExportLogsServiceRequest()
	UnmarshalJSONOrigExportLogsServiceRequest(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigExportLogsServiceRequest(), dest)
}

func TestMarshalAndUnmarshalJSONOrigExportLogsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigExportLogsServiceRequest(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigExportLogsServiceRequest()
				UnmarshalJSONOrigExportLogsServiceRequest(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigExportLogsServiceRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigExportLogsServiceRequestFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportLogsServiceRequest() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigExportLogsServiceRequest()
			require.Error(t, UnmarshalProtoOrigExportLogsServiceRequest(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportLogsServiceRequestUnknown(t *testing.T) {
	dest := NewOrigExportLogsServiceRequest()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigExportLogsServiceRequest(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigExportLogsServiceRequest(), dest)
}

func TestMarshalAndUnmarshalProtoOrigExportLogsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigExportLogsServiceRequest(src))
				gotSize := MarshalProtoOrigExportLogsServiceRequest(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigExportLogsServiceRequest()
				require.NoError(t, UnmarshalProtoOrigExportLogsServiceRequest(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigExportLogsServiceRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportLogsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceRequest() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportLogsServiceRequest(src))
			gotSize := MarshalProtoOrigExportLogsServiceRequest(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectorlogs.ExportLogsServiceRequest{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigExportLogsServiceRequest()
			require.NoError(t, UnmarshalProtoOrigExportLogsServiceRequest(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportLogsServiceRequest() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                {0x02},
		"ResourceLogs/wrong_wire_type": {0xc},
		"ResourceLogs/missing_value":   {0xa},
	}
}

func genTestEncodingValuesExportLogsServiceRequest() map[string]*otlpcollectorlogs.ExportLogsServiceRequest {
	return map[string]*otlpcollectorlogs.ExportLogsServiceRequest{
		"empty":                         NewOrigExportLogsServiceRequest(),
		"ResourceLogs/default_and_test": {ResourceLogs: []*otlplogs.ResourceLogs{{}, GenTestOrigResourceLogs()}},
	}
}
