// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type InstrumentationScope struct {
	orig  *otlpcommon.InstrumentationScope
	state *State
}

func GetOrigInstrumentationScope(ms InstrumentationScope) *otlpcommon.InstrumentationScope {
	return ms.orig
}

func GetInstrumentationScopeState(ms InstrumentationScope) *State {
	return ms.state
}

func NewInstrumentationScope(orig *otlpcommon.InstrumentationScope, state *State) InstrumentationScope {
	return InstrumentationScope{orig: orig, state: state}
}

var (
	protoPoolInstrumentationScope = sync.Pool{
		New: func() any {
			return &otlpcommon.InstrumentationScope{}
		},
	}
)

func NewOrigInstrumentationScope() *otlpcommon.InstrumentationScope {
	if !UseProtoPooling.IsEnabled() {
		return &otlpcommon.InstrumentationScope{}
	}
	return protoPoolInstrumentationScope.Get().(*otlpcommon.InstrumentationScope)
}

func DeleteOrigInstrumentationScope(orig *otlpcommon.InstrumentationScope, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.Attributes {
		DeleteOrigKeyValue(&orig.Attributes[i], false)
	}

	orig.Reset()
	if nullable {
		protoPoolInstrumentationScope.Put(orig)
	}
}

func CopyOrigInstrumentationScope(dest, src *otlpcommon.InstrumentationScope) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.Name = src.Name
	dest.Version = src.Version
	dest.Attributes = CopyOrigKeyValueSlice(dest.Attributes, src.Attributes)
	dest.DroppedAttributesCount = src.DroppedAttributesCount
}

func GenTestOrigInstrumentationScope() *otlpcommon.InstrumentationScope {
	orig := NewOrigInstrumentationScope()
	orig.Name = "test_name"
	orig.Version = "test_version"
	orig.Attributes = GenerateOrigTestKeyValueSlice()
	orig.DroppedAttributesCount = uint32(13)
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigInstrumentationScope(orig *otlpcommon.InstrumentationScope, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.Name != "" {
		dest.WriteObjectField("name")
		dest.WriteString(orig.Name)
	}
	if orig.Version != "" {
		dest.WriteObjectField("version")
		dest.WriteString(orig.Version)
	}
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		MarshalJSONOrigKeyValue(&orig.Attributes[0], dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			MarshalJSONOrigKeyValue(&orig.Attributes[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.DroppedAttributesCount != uint32(0) {
		dest.WriteObjectField("droppedAttributesCount")
		dest.WriteUint32(orig.DroppedAttributesCount)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigInstrumentationScope unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigInstrumentationScope(orig *otlpcommon.InstrumentationScope, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "name":
			orig.Name = iter.ReadString()
		case "version":
			orig.Version = iter.ReadString()
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, otlpcommon.KeyValue{})
				UnmarshalJSONOrigKeyValue(&orig.Attributes[len(orig.Attributes)-1], iter)
			}

		case "droppedAttributesCount", "dropped_attributes_count":
			orig.DroppedAttributesCount = iter.ReadUint32()
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigInstrumentationScope(orig *otlpcommon.InstrumentationScope) int {
	var n int
	var l int
	_ = l
	l = len(orig.Name)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.Version)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.Attributes {
		l = SizeProtoOrigKeyValue(&orig.Attributes[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DroppedAttributesCount != 0 {
		n += 1 + proto.Sov(uint64(orig.DroppedAttributesCount))
	}
	return n
}

func MarshalProtoOrigInstrumentationScope(orig *otlpcommon.InstrumentationScope, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = len(orig.Name)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Name)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	l = len(orig.Version)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Version)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = MarshalProtoOrigKeyValue(&orig.Attributes[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	if orig.DroppedAttributesCount != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedAttributesCount))
		pos--
		buf[pos] = 0x20
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigInstrumentationScope(orig *otlpcommon.InstrumentationScope, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Name = string(buf[startPos:pos])

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Version = string(buf[startPos:pos])

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, otlpcommon.KeyValue{})
			err = UnmarshalProtoOrigKeyValue(&orig.Attributes[len(orig.Attributes)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 4:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.DroppedAttributesCount = uint32(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
