// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestHistogramDataPoint_MoveTo(t *testing.T) {
	ms := generateTestHistogramDataPoint()
	dest := NewHistogramDataPoint()
	ms.MoveTo(dest)
	assert.Equal(t, NewHistogramDataPoint(), ms)
	assert.Equal(t, generateTestHistogramDataPoint(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestHistogramDataPoint(), dest)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.MoveTo(newHistogramDataPoint(&otlpmetrics.HistogramDataPoint{}, &sharedState)) })
	assert.Panics(t, func() { newHistogramDataPoint(&otlpmetrics.HistogramDataPoint{}, &sharedState).MoveTo(dest) })
}

func TestHistogramDataPoint_CopyTo(t *testing.T) {
	ms := NewHistogramDataPoint()
	orig := NewHistogramDataPoint()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestHistogramDataPoint()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.CopyTo(newHistogramDataPoint(&otlpmetrics.HistogramDataPoint{}, &sharedState)) })
}

func TestHistogramDataPoint_Attributes(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, pcommon.NewMap(), ms.Attributes())
	ms.orig.Attributes = internal.GenerateOrigTestKeyValueSlice()
	assert.Equal(t, pcommon.Map(internal.GenerateTestMap()), ms.Attributes())
}

func TestHistogramDataPoint_StartTimestamp(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, pcommon.Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := pcommon.Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.Equal(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestHistogramDataPoint_Timestamp(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, pcommon.Timestamp(0), ms.Timestamp())
	testValTimestamp := pcommon.Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.Equal(t, testValTimestamp, ms.Timestamp())
}

func TestHistogramDataPoint_Count(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, uint64(0), ms.Count())
	ms.SetCount(uint64(13))
	assert.Equal(t, uint64(13), ms.Count())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newHistogramDataPoint(&otlpmetrics.HistogramDataPoint{}, &sharedState).SetCount(uint64(13)) })
}

func TestHistogramDataPoint_Sum(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.InDelta(t, float64(0), ms.Sum(), 0.01)
	ms.SetSum(float64(3.1415926))
	assert.True(t, ms.HasSum())
	assert.InDelta(t, float64(3.1415926), ms.Sum(), 0.01)
	ms.RemoveSum()
	assert.False(t, ms.HasSum())
	dest := NewHistogramDataPoint()
	dest.SetSum(float64(3.1415926))
	ms.CopyTo(dest)
	assert.False(t, dest.HasSum())
}

func TestHistogramDataPoint_BucketCounts(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, pcommon.NewUInt64Slice(), ms.BucketCounts())
	ms.orig.BucketCounts = internal.GenerateOrigTestUint64Slice()
	assert.Equal(t, pcommon.UInt64Slice(internal.GenerateTestUInt64Slice()), ms.BucketCounts())
}

func TestHistogramDataPoint_ExplicitBounds(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, pcommon.NewFloat64Slice(), ms.ExplicitBounds())
	ms.orig.ExplicitBounds = internal.GenerateOrigTestFloat64Slice()
	assert.Equal(t, pcommon.Float64Slice(internal.GenerateTestFloat64Slice()), ms.ExplicitBounds())
}

func TestHistogramDataPoint_Exemplars(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, NewExemplarSlice(), ms.Exemplars())
	ms.orig.Exemplars = internal.GenerateOrigTestExemplarSlice()
	assert.Equal(t, generateTestExemplarSlice(), ms.Exemplars())
}

func TestHistogramDataPoint_Flags(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, DataPointFlags(0), ms.Flags())
	testValFlags := DataPointFlags(1)
	ms.SetFlags(testValFlags)
	assert.Equal(t, testValFlags, ms.Flags())
}

func TestHistogramDataPoint_Min(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.InDelta(t, float64(0), ms.Min(), 0.01)
	ms.SetMin(float64(3.1415926))
	assert.True(t, ms.HasMin())
	assert.InDelta(t, float64(3.1415926), ms.Min(), 0.01)
	ms.RemoveMin()
	assert.False(t, ms.HasMin())
	dest := NewHistogramDataPoint()
	dest.SetMin(float64(3.1415926))
	ms.CopyTo(dest)
	assert.False(t, dest.HasMin())
}

func TestHistogramDataPoint_Max(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.InDelta(t, float64(0), ms.Max(), 0.01)
	ms.SetMax(float64(3.1415926))
	assert.True(t, ms.HasMax())
	assert.InDelta(t, float64(3.1415926), ms.Max(), 0.01)
	ms.RemoveMax()
	assert.False(t, ms.HasMax())
	dest := NewHistogramDataPoint()
	dest.SetMax(float64(3.1415926))
	ms.CopyTo(dest)
	assert.False(t, dest.HasMax())
}

func generateTestHistogramDataPoint() HistogramDataPoint {
	ms := NewHistogramDataPoint()
	internal.FillOrigTestHistogramDataPoint(ms.orig)
	return ms
}
