// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigSpan_Event(t *testing.T) {
	src := &otlptrace.Span_Event{}
	dest := &otlptrace.Span_Event{}
	CopyOrigSpan_Event(dest, src)
	assert.Equal(t, &otlptrace.Span_Event{}, dest)
	FillOrigTestSpan_Event(src)
	CopyOrigSpan_Event(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigSpan_EventUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlptrace.Span_Event{}
	UnmarshalJSONOrigSpan_Event(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlptrace.Span_Event{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigSpan_Event(t *testing.T) {
	for name, src := range getEncodingTestValuesSpan_Event() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigSpan_Event(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlptrace.Span_Event{}
			UnmarshalJSONOrigSpan_Event(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigSpan_Event(t *testing.T) {
	for name, src := range getEncodingTestValuesSpan_Event() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigSpan_Event(src))
			gotSize := MarshalProtoOrigSpan_Event(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlptrace.Span_Event{}
			require.NoError(t, UnmarshalProtoOrigSpan_Event(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesSpan_Event() map[string]*otlptrace.Span_Event {
	return map[string]*otlptrace.Span_Event{
		"empty": {},
		"fill_test": func() *otlptrace.Span_Event {
			src := &otlptrace.Span_Event{}
			FillOrigTestSpan_Event(src)
			return src
		}(),
	}
}
