// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigScopeMetrics(t *testing.T) {
	src := &otlpmetrics.ScopeMetrics{}
	dest := &otlpmetrics.ScopeMetrics{}
	CopyOrigScopeMetrics(dest, src)
	assert.Equal(t, &otlpmetrics.ScopeMetrics{}, dest)
	FillOrigTestScopeMetrics(src)
	CopyOrigScopeMetrics(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigScopeMetricsUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpmetrics.ScopeMetrics{}
	UnmarshalJSONOrigScopeMetrics(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpmetrics.ScopeMetrics{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigScopeMetrics(t *testing.T) {
	for name, src := range getEncodingTestValuesScopeMetrics() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigScopeMetrics(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpmetrics.ScopeMetrics{}
			UnmarshalJSONOrigScopeMetrics(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigScopeMetrics(t *testing.T) {
	for name, src := range getEncodingTestValuesScopeMetrics() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigScopeMetrics(src))
			gotSize := MarshalProtoOrigScopeMetrics(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpmetrics.ScopeMetrics{}
			require.NoError(t, UnmarshalProtoOrigScopeMetrics(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesScopeMetrics() map[string]*otlpmetrics.ScopeMetrics {
	return map[string]*otlpmetrics.ScopeMetrics{
		"empty": {},
		"fill_test": func() *otlpmetrics.ScopeMetrics {
			src := &otlpmetrics.ScopeMetrics{}
			FillOrigTestScopeMetrics(src)
			return src
		}(),
	}
}
