// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigResourceLogs(t *testing.T) {
	src := &otlplogs.ResourceLogs{}
	dest := &otlplogs.ResourceLogs{}
	CopyOrigResourceLogs(dest, src)
	assert.Equal(t, &otlplogs.ResourceLogs{}, dest)
	FillOrigTestResourceLogs(src)
	CopyOrigResourceLogs(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigResourceLogsUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlplogs.ResourceLogs{}
	UnmarshalJSONOrigResourceLogs(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlplogs.ResourceLogs{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigResourceLogs(t *testing.T) {
	for name, src := range getEncodingTestValuesResourceLogs() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigResourceLogs(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlplogs.ResourceLogs{}
			UnmarshalJSONOrigResourceLogs(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigResourceLogs(t *testing.T) {
	for name, src := range getEncodingTestValuesResourceLogs() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigResourceLogs(src))
			gotSize := MarshalProtoOrigResourceLogs(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlplogs.ResourceLogs{}
			require.NoError(t, UnmarshalProtoOrigResourceLogs(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesResourceLogs() map[string]*otlplogs.ResourceLogs {
	return map[string]*otlplogs.ResourceLogs{
		"empty": {},
		"fill_test": func() *otlplogs.ResourceLogs {
			src := &otlplogs.ResourceLogs{}
			FillOrigTestResourceLogs(src)
			return src
		}(),
	}
}
