// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpresource "go.opentelemetry.io/collector/pdata/internal/data/protogen/resource/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigResource(t *testing.T) {
	src := &otlpresource.Resource{}
	dest := &otlpresource.Resource{}
	CopyOrigResource(dest, src)
	assert.Equal(t, &otlpresource.Resource{}, dest)
	FillOrigTestResource(src)
	CopyOrigResource(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigResourceUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpresource.Resource{}
	UnmarshalJSONOrigResource(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpresource.Resource{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigResource(t *testing.T) {
	for name, src := range getEncodingTestValuesResource() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigResource(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpresource.Resource{}
			UnmarshalJSONOrigResource(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigResource(t *testing.T) {
	for name, src := range getEncodingTestValuesResource() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigResource(src))
			gotSize := MarshalProtoOrigResource(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpresource.Resource{}
			require.NoError(t, UnmarshalProtoOrigResource(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesResource() map[string]*otlpresource.Resource {
	return map[string]*otlpresource.Resource{
		"empty": {},
		"fill_test": func() *otlpresource.Resource {
			src := &otlpresource.Resource{}
			FillOrigTestResource(src)
			return src
		}(),
	}
}
