// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigProfilesDictionary(t *testing.T) {
	src := &otlpprofiles.ProfilesDictionary{}
	dest := &otlpprofiles.ProfilesDictionary{}
	CopyOrigProfilesDictionary(dest, src)
	assert.Equal(t, &otlpprofiles.ProfilesDictionary{}, dest)
	FillOrigTestProfilesDictionary(src)
	CopyOrigProfilesDictionary(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigProfilesDictionaryUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpprofiles.ProfilesDictionary{}
	UnmarshalJSONOrigProfilesDictionary(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpprofiles.ProfilesDictionary{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigProfilesDictionary(t *testing.T) {
	for name, src := range getEncodingTestValuesProfilesDictionary() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigProfilesDictionary(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpprofiles.ProfilesDictionary{}
			UnmarshalJSONOrigProfilesDictionary(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigProfilesDictionary(t *testing.T) {
	for name, src := range getEncodingTestValuesProfilesDictionary() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigProfilesDictionary(src))
			gotSize := MarshalProtoOrigProfilesDictionary(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpprofiles.ProfilesDictionary{}
			require.NoError(t, UnmarshalProtoOrigProfilesDictionary(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesProfilesDictionary() map[string]*otlpprofiles.ProfilesDictionary {
	return map[string]*otlpprofiles.ProfilesDictionary{
		"empty": {},
		"fill_test": func() *otlpprofiles.ProfilesDictionary {
			src := &otlpprofiles.ProfilesDictionary{}
			FillOrigTestProfilesDictionary(src)
			return src
		}(),
	}
}
