// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigMetric(t *testing.T) {
	src := &otlpmetrics.Metric{}
	dest := &otlpmetrics.Metric{}
	CopyOrigMetric(dest, src)
	assert.Equal(t, &otlpmetrics.Metric{}, dest)
	FillOrigTestMetric(src)
	CopyOrigMetric(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigMetricUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpmetrics.Metric{}
	UnmarshalJSONOrigMetric(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpmetrics.Metric{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigMetric(t *testing.T) {
	for name, src := range getEncodingTestValuesMetric() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigMetric(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpmetrics.Metric{}
			UnmarshalJSONOrigMetric(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigMetric(t *testing.T) {
	for name, src := range getEncodingTestValuesMetric() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigMetric(src))
			gotSize := MarshalProtoOrigMetric(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpmetrics.Metric{}
			require.NoError(t, UnmarshalProtoOrigMetric(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesMetric() map[string]*otlpmetrics.Metric {
	return map[string]*otlpmetrics.Metric{
		"empty": {},
		"fill_test": func() *otlpmetrics.Metric {
			src := &otlpmetrics.Metric{}
			FillOrigTestMetric(src)
			return src
		}(),
		"oneof_gauge": {Data: func() *otlpmetrics.Metric_Gauge {
			val := &otlpmetrics.Gauge{}
			FillOrigTestGauge(val)
			return &otlpmetrics.Metric_Gauge{Gauge: val}
		}()},
		"oneof_sum": {Data: func() *otlpmetrics.Metric_Sum {
			val := &otlpmetrics.Sum{}
			FillOrigTestSum(val)
			return &otlpmetrics.Metric_Sum{Sum: val}
		}()},
		"oneof_histogram": {Data: func() *otlpmetrics.Metric_Histogram {
			val := &otlpmetrics.Histogram{}
			FillOrigTestHistogram(val)
			return &otlpmetrics.Metric_Histogram{Histogram: val}
		}()},
		"oneof_exponentialhistogram": {Data: func() *otlpmetrics.Metric_ExponentialHistogram {
			val := &otlpmetrics.ExponentialHistogram{}
			FillOrigTestExponentialHistogram(val)
			return &otlpmetrics.Metric_ExponentialHistogram{ExponentialHistogram: val}
		}()},
		"oneof_summary": {Data: func() *otlpmetrics.Metric_Summary {
			val := &otlpmetrics.Summary{}
			FillOrigTestSummary(val)
			return &otlpmetrics.Metric_Summary{Summary: val}
		}()},
	}
}
