// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigLogRecord(t *testing.T) {
	src := &otlplogs.LogRecord{}
	dest := &otlplogs.LogRecord{}
	CopyOrigLogRecord(dest, src)
	assert.Equal(t, &otlplogs.LogRecord{}, dest)
	FillOrigTestLogRecord(src)
	CopyOrigLogRecord(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigLogRecordUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlplogs.LogRecord{}
	UnmarshalJSONOrigLogRecord(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlplogs.LogRecord{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigLogRecord(t *testing.T) {
	for name, src := range getEncodingTestValuesLogRecord() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigLogRecord(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlplogs.LogRecord{}
			UnmarshalJSONOrigLogRecord(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigLogRecord(t *testing.T) {
	for name, src := range getEncodingTestValuesLogRecord() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigLogRecord(src))
			gotSize := MarshalProtoOrigLogRecord(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlplogs.LogRecord{}
			require.NoError(t, UnmarshalProtoOrigLogRecord(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesLogRecord() map[string]*otlplogs.LogRecord {
	return map[string]*otlplogs.LogRecord{
		"empty": {},
		"fill_test": func() *otlplogs.LogRecord {
			src := &otlplogs.LogRecord{}
			FillOrigTestLogRecord(src)
			return src
		}(),
	}
}
