// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigLine(t *testing.T) {
	src := &otlpprofiles.Line{}
	dest := &otlpprofiles.Line{}
	CopyOrigLine(dest, src)
	assert.Equal(t, &otlpprofiles.Line{}, dest)
	FillOrigTestLine(src)
	CopyOrigLine(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigLineUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpprofiles.Line{}
	UnmarshalJSONOrigLine(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpprofiles.Line{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigLine(t *testing.T) {
	for name, src := range getEncodingTestValuesLine() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigLine(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpprofiles.Line{}
			UnmarshalJSONOrigLine(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigLine(t *testing.T) {
	for name, src := range getEncodingTestValuesLine() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigLine(src))
			gotSize := MarshalProtoOrigLine(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpprofiles.Line{}
			require.NoError(t, UnmarshalProtoOrigLine(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesLine() map[string]*otlpprofiles.Line {
	return map[string]*otlpprofiles.Line{
		"empty": {},
		"fill_test": func() *otlpprofiles.Line {
			src := &otlpprofiles.Line{}
			FillOrigTestLine(src)
			return src
		}(),
	}
}
