// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigLine(dest, src *otlpprofiles.Line) {
	dest.FunctionIndex = src.FunctionIndex
	dest.Line = src.Line
	dest.Column = src.Column
}

func FillOrigTestLine(orig *otlpprofiles.Line) {
	orig.FunctionIndex = int32(13)
	orig.Line = int64(13)
	orig.Column = int64(13)
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigLine(orig *otlpprofiles.Line, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.FunctionIndex != int32(0) {
		dest.WriteObjectField("functionIndex")
		dest.WriteInt32(orig.FunctionIndex)
	}
	if orig.Line != int64(0) {
		dest.WriteObjectField("line")
		dest.WriteInt64(orig.Line)
	}
	if orig.Column != int64(0) {
		dest.WriteObjectField("column")
		dest.WriteInt64(orig.Column)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigLine unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigLine(orig *otlpprofiles.Line, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "functionIndex", "function_index":
			orig.FunctionIndex = iter.ReadInt32()
		case "line":
			orig.Line = iter.ReadInt64()
		case "column":
			orig.Column = iter.ReadInt64()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigLine(orig *otlpprofiles.Line) int {
	var n int
	var l int
	_ = l
	if orig.FunctionIndex != 0 {
		n += 1 + proto.Sov(uint64(orig.FunctionIndex))
	}
	if orig.Line != 0 {
		n += 1 + proto.Sov(uint64(orig.Line))
	}
	if orig.Column != 0 {
		n += 1 + proto.Sov(uint64(orig.Column))
	}
	return n
}

func MarshalProtoOrigLine(orig *otlpprofiles.Line, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.FunctionIndex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.FunctionIndex))
		pos--
		buf[pos] = 0x8
	}
	if orig.Line != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Line))
		pos--
		buf[pos] = 0x10
	}
	if orig.Column != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Column))
		pos--
		buf[pos] = 0x18
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigLine(orig *otlpprofiles.Line, buf []byte) error {
	return orig.Unmarshal(buf)
}
