// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type InstrumentationScope struct {
	orig  *otlpcommon.InstrumentationScope
	state *State
}

func GetOrigInstrumentationScope(ms InstrumentationScope) *otlpcommon.InstrumentationScope {
	return ms.orig
}

func GetInstrumentationScopeState(ms InstrumentationScope) *State {
	return ms.state
}

func NewInstrumentationScope(orig *otlpcommon.InstrumentationScope, state *State) InstrumentationScope {
	return InstrumentationScope{orig: orig, state: state}
}

func GenerateTestInstrumentationScope() InstrumentationScope {
	orig := otlpcommon.InstrumentationScope{}
	FillOrigTestInstrumentationScope(&orig)
	state := StateMutable
	return NewInstrumentationScope(&orig, &state)
}

func CopyOrigInstrumentationScope(dest, src *otlpcommon.InstrumentationScope) {
	dest.Name = src.Name
	dest.Version = src.Version
	dest.Attributes = CopyOrigKeyValueSlice(dest.Attributes, src.Attributes)
	dest.DroppedAttributesCount = src.DroppedAttributesCount
}

func FillOrigTestInstrumentationScope(orig *otlpcommon.InstrumentationScope) {
	orig.Name = "test_name"
	orig.Version = "test_version"
	orig.Attributes = GenerateOrigTestKeyValueSlice()
	orig.DroppedAttributesCount = uint32(13)
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigInstrumentationScope(orig *otlpcommon.InstrumentationScope, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.Name != "" {
		dest.WriteObjectField("name")
		dest.WriteString(orig.Name)
	}
	if orig.Version != "" {
		dest.WriteObjectField("version")
		dest.WriteString(orig.Version)
	}
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		MarshalJSONOrigKeyValue(&orig.Attributes[0], dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			MarshalJSONOrigKeyValue(&orig.Attributes[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.DroppedAttributesCount != uint32(0) {
		dest.WriteObjectField("droppedAttributesCount")
		dest.WriteUint32(orig.DroppedAttributesCount)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigInstrumentationScope unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigInstrumentationScope(orig *otlpcommon.InstrumentationScope, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "name":
			orig.Name = iter.ReadString()
		case "version":
			orig.Version = iter.ReadString()
		case "attributes":
			orig.Attributes = UnmarshalJSONOrigKeyValueSlice(iter)
		case "droppedAttributesCount", "dropped_attributes_count":
			orig.DroppedAttributesCount = iter.ReadUint32()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigInstrumentationScope(orig *otlpcommon.InstrumentationScope) int {
	var n int
	var l int
	_ = l
	l = len(orig.Name)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.Version)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.Attributes {
		l = SizeProtoOrigKeyValue(&orig.Attributes[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DroppedAttributesCount != 0 {
		n += 1 + proto.Sov(uint64(orig.DroppedAttributesCount))
	}
	return n
}

func MarshalProtoOrigInstrumentationScope(orig *otlpcommon.InstrumentationScope, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = len(orig.Name)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Name)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	l = len(orig.Version)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Version)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	for i := range orig.Attributes {
		l = MarshalProtoOrigKeyValue(&orig.Attributes[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	if orig.DroppedAttributesCount != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedAttributesCount))
		pos--
		buf[pos] = 0x20
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigInstrumentationScope(orig *otlpcommon.InstrumentationScope, buf []byte) error {
	return orig.Unmarshal(buf)
}
