// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigHistogram(dest, src *otlpmetrics.Histogram) {
	dest.DataPoints = CopyOrigHistogramDataPointSlice(dest.DataPoints, src.DataPoints)
	dest.AggregationTemporality = src.AggregationTemporality
}

func FillOrigTestHistogram(orig *otlpmetrics.Histogram) {
	orig.DataPoints = GenerateOrigTestHistogramDataPointSlice()
	orig.AggregationTemporality = otlpmetrics.AggregationTemporality(1)
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigHistogram(orig *otlpmetrics.Histogram, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.DataPoints) > 0 {
		dest.WriteObjectField("dataPoints")
		dest.WriteArrayStart()
		MarshalJSONOrigHistogramDataPoint(orig.DataPoints[0], dest)
		for i := 1; i < len(orig.DataPoints); i++ {
			dest.WriteMore()
			MarshalJSONOrigHistogramDataPoint(orig.DataPoints[i], dest)
		}
		dest.WriteArrayEnd()
	}

	if int32(orig.AggregationTemporality) != 0 {
		dest.WriteObjectField("aggregationTemporality")
		dest.WriteInt32(int32(orig.AggregationTemporality))
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigHistogram unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigHistogram(orig *otlpmetrics.Histogram, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "dataPoints", "data_points":
			orig.DataPoints = UnmarshalJSONOrigHistogramDataPointSlice(iter)
		case "aggregationTemporality", "aggregation_temporality":
			orig.AggregationTemporality = otlpmetrics.AggregationTemporality(iter.ReadEnumValue(otlpmetrics.AggregationTemporality_value))
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigHistogram(orig *otlpmetrics.Histogram) int {
	var n int
	var l int
	_ = l
	for i := range orig.DataPoints {
		l = SizeProtoOrigHistogramDataPoint(orig.DataPoints[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.AggregationTemporality != 0 {
		n += 1 + proto.Sov(uint64(orig.AggregationTemporality))
	}
	return n
}

func MarshalProtoOrigHistogram(orig *otlpmetrics.Histogram, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := range orig.DataPoints {
		l = MarshalProtoOrigHistogramDataPoint(orig.DataPoints[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	if orig.AggregationTemporality != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.AggregationTemporality))
		pos--
		buf[pos] = 0x10
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigHistogram(orig *otlpmetrics.Histogram, buf []byte) error {
	return orig.Unmarshal(buf)
}
