// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigGauge(t *testing.T) {
	src := &otlpmetrics.Gauge{}
	dest := &otlpmetrics.Gauge{}
	CopyOrigGauge(dest, src)
	assert.Equal(t, &otlpmetrics.Gauge{}, dest)
	FillOrigTestGauge(src)
	CopyOrigGauge(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigGaugeUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpmetrics.Gauge{}
	UnmarshalJSONOrigGauge(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpmetrics.Gauge{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigGauge(t *testing.T) {
	for name, src := range getEncodingTestValuesGauge() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigGauge(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpmetrics.Gauge{}
			UnmarshalJSONOrigGauge(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigGauge(t *testing.T) {
	for name, src := range getEncodingTestValuesGauge() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigGauge(src))
			gotSize := MarshalProtoOrigGauge(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpmetrics.Gauge{}
			require.NoError(t, UnmarshalProtoOrigGauge(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesGauge() map[string]*otlpmetrics.Gauge {
	return map[string]*otlpmetrics.Gauge{
		"empty": {},
		"fill_test": func() *otlpmetrics.Gauge {
			src := &otlpmetrics.Gauge{}
			FillOrigTestGauge(src)
			return src
		}(),
	}
}
