// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpcollectortrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportTraceServiceResponse(t *testing.T) {
	src := &otlpcollectortrace.ExportTraceServiceResponse{}
	dest := &otlpcollectortrace.ExportTraceServiceResponse{}
	CopyOrigExportTraceServiceResponse(dest, src)
	assert.Equal(t, &otlpcollectortrace.ExportTraceServiceResponse{}, dest)
	FillOrigTestExportTraceServiceResponse(src)
	CopyOrigExportTraceServiceResponse(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportTraceServiceResponseUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpcollectortrace.ExportTraceServiceResponse{}
	UnmarshalJSONOrigExportTraceServiceResponse(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpcollectortrace.ExportTraceServiceResponse{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportTraceServiceResponse(t *testing.T) {
	for name, src := range getEncodingTestValuesExportTraceServiceResponse() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExportTraceServiceResponse(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpcollectortrace.ExportTraceServiceResponse{}
			UnmarshalJSONOrigExportTraceServiceResponse(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportTraceServiceResponse(t *testing.T) {
	for name, src := range getEncodingTestValuesExportTraceServiceResponse() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportTraceServiceResponse(src))
			gotSize := MarshalProtoOrigExportTraceServiceResponse(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpcollectortrace.ExportTraceServiceResponse{}
			require.NoError(t, UnmarshalProtoOrigExportTraceServiceResponse(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExportTraceServiceResponse() map[string]*otlpcollectortrace.ExportTraceServiceResponse {
	return map[string]*otlpcollectortrace.ExportTraceServiceResponse{
		"empty": {},
		"fill_test": func() *otlpcollectortrace.ExportTraceServiceResponse {
			src := &otlpcollectortrace.ExportTraceServiceResponse{}
			FillOrigTestExportTraceServiceResponse(src)
			return src
		}(),
	}
}
