// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpcollectortrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportTraceServiceRequest(t *testing.T) {
	src := &otlpcollectortrace.ExportTraceServiceRequest{}
	dest := &otlpcollectortrace.ExportTraceServiceRequest{}
	CopyOrigExportTraceServiceRequest(dest, src)
	assert.Equal(t, &otlpcollectortrace.ExportTraceServiceRequest{}, dest)
	FillOrigTestExportTraceServiceRequest(src)
	CopyOrigExportTraceServiceRequest(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportTraceServiceRequestUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpcollectortrace.ExportTraceServiceRequest{}
	UnmarshalJSONOrigExportTraceServiceRequest(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpcollectortrace.ExportTraceServiceRequest{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportTraceServiceRequest(t *testing.T) {
	for name, src := range getEncodingTestValuesExportTraceServiceRequest() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExportTraceServiceRequest(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpcollectortrace.ExportTraceServiceRequest{}
			UnmarshalJSONOrigExportTraceServiceRequest(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportTraceServiceRequest(t *testing.T) {
	for name, src := range getEncodingTestValuesExportTraceServiceRequest() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportTraceServiceRequest(src))
			gotSize := MarshalProtoOrigExportTraceServiceRequest(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpcollectortrace.ExportTraceServiceRequest{}
			require.NoError(t, UnmarshalProtoOrigExportTraceServiceRequest(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExportTraceServiceRequest() map[string]*otlpcollectortrace.ExportTraceServiceRequest {
	return map[string]*otlpcollectortrace.ExportTraceServiceRequest{
		"empty": {},
		"fill_test": func() *otlpcollectortrace.ExportTraceServiceRequest {
			src := &otlpcollectortrace.ExportTraceServiceRequest{}
			FillOrigTestExportTraceServiceRequest(src)
			return src
		}(),
	}
}
