// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpcollectormetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportMetricsPartialSuccess(t *testing.T) {
	src := &otlpcollectormetrics.ExportMetricsPartialSuccess{}
	dest := &otlpcollectormetrics.ExportMetricsPartialSuccess{}
	CopyOrigExportMetricsPartialSuccess(dest, src)
	assert.Equal(t, &otlpcollectormetrics.ExportMetricsPartialSuccess{}, dest)
	FillOrigTestExportMetricsPartialSuccess(src)
	CopyOrigExportMetricsPartialSuccess(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportMetricsPartialSuccessUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpcollectormetrics.ExportMetricsPartialSuccess{}
	UnmarshalJSONOrigExportMetricsPartialSuccess(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpcollectormetrics.ExportMetricsPartialSuccess{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportMetricsPartialSuccess(t *testing.T) {
	for name, src := range getEncodingTestValuesExportMetricsPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExportMetricsPartialSuccess(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpcollectormetrics.ExportMetricsPartialSuccess{}
			UnmarshalJSONOrigExportMetricsPartialSuccess(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportMetricsPartialSuccess(t *testing.T) {
	for name, src := range getEncodingTestValuesExportMetricsPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportMetricsPartialSuccess(src))
			gotSize := MarshalProtoOrigExportMetricsPartialSuccess(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpcollectormetrics.ExportMetricsPartialSuccess{}
			require.NoError(t, UnmarshalProtoOrigExportMetricsPartialSuccess(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExportMetricsPartialSuccess() map[string]*otlpcollectormetrics.ExportMetricsPartialSuccess {
	return map[string]*otlpcollectormetrics.ExportMetricsPartialSuccess{
		"empty": {},
		"fill_test": func() *otlpcollectormetrics.ExportMetricsPartialSuccess {
			src := &otlpcollectormetrics.ExportMetricsPartialSuccess{}
			FillOrigTestExportMetricsPartialSuccess(src)
			return src
		}(),
	}
}
